/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.inspections.quickfix.PyAddSpecifierToFormatQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySliceExpression;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedRatedResolveResult;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStringFormatInspection
extends PyInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = PyBundle.message("INSP.NAME.str.format", new Object[0]);
        if (string == null) {
            PyStringFormatInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyStringFormatInspection.$$$reportNull$$$0(1);
        }
        if (session == null) {
            PyStringFormatInspection.$$$reportNull$$$0(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyStringFormatInspection.$$$reportNull$$$0(3);
        }
        return visitor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyStringFormatInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Visitor
    extends PyInspectionVisitor {
        static int inspectCallExpression(@NotNull PyCallExpression callExpression, @NotNull PyResolveContext resolveContext, @NotNull TypeEvalContext evalContext) {
            IntSummaryStatistics statistics;
            if (callExpression == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (resolveContext == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (evalContext == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if ((statistics = callExpression.multiResolveCalleeFunction(resolveContext).stream().map(callable -> callable.getCallType(evalContext, callExpression)).collect(Collectors.summarizingInt(callType -> {
                if (callType instanceof PyNoneType) {
                    return 1;
                }
                if (callType instanceof PyClassType) {
                    return Visitor.countElements(evalContext, (PyClassType)callType);
                }
                if (callType instanceof PyUnionType) {
                    int maxNumber = 1;
                    boolean allForSure = true;
                    for (PyType member : ((PyUnionType)callType).getMembers()) {
                        PyClassType classType = PyUtil.as(member, PyClassType.class);
                        if (classType != null) {
                            int elementsCount = Visitor.countElements(evalContext, classType);
                            allForSure = allForSure && elementsCount != -1;
                            maxNumber = Math.max(maxNumber, elementsCount);
                            continue;
                        }
                        allForSure = false;
                    }
                    return allForSure ? maxNumber : -1;
                }
                return -1;
            }))).getMin() == statistics.getMax()) {
                return statistics.getMin();
            }
            return -1;
        }

        private static int countElements(@NotNull TypeEvalContext evalContext, PyClassType callType) {
            if (evalContext == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            if (!callType.getPyClass().isSubclass("tuple", evalContext)) {
                return 1;
            }
            if (callType instanceof PyTupleType) {
                return ((PyTupleType)callType).getElementCount();
            }
            return -1;
        }

        public Visitor(ProblemsHolder holder, LocalInspectionToolSession session) {
            super(holder, session);
        }

        @Override
        public void visitPyBinaryExpression(PyBinaryExpression node) {
            if (node.getLeftExpression() instanceof PyStringLiteralExpression && node.isOperator("%")) {
                Inspection inspection = new Inspection(this, this.myTypeEvalContext);
                PyStringLiteralExpression literalExpression = (PyStringLiteralExpression)node.getLeftExpression();
                inspection.inspectPercentFormat(literalExpression);
                if (inspection.isProblem()) {
                    return;
                }
                inspection.inspectValues(node.getRightExpression());
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyStringLiteralExpression literalExpression;
            PyExpression callee = node.getCallee();
            if (callee != null && callee.getName() != null && callee.getName().equals("format") && (literalExpression = (PyStringLiteralExpression)PsiTreeUtil.getChildOfType((PsiElement)callee, PyStringLiteralExpression.class)) != null) {
                NewStyleInspection inspection = new NewStyleInspection(literalExpression, this, this.myTypeEvalContext);
                inspection.inspect();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveContext";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evalContext";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "inspectCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "countElements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class NewStyleInspection {
            private static final List<String> CHECKED_TYPES = Arrays.asList("str", "int", "long", "float", "complex", "None");
            private static final List<String> NUMERIC_TYPES = Arrays.asList("int", "long", "float", "complex");
            private static final ImmutableMap<Character, String> NEW_STYLE_FORMAT_CONVERSIONS = ImmutableMap.builder().put((Object)Character.valueOf('s'), (Object)"str or None").put((Object)Character.valueOf('b'), (Object)"int").put((Object)Character.valueOf('c'), (Object)"int").put((Object)Character.valueOf('d'), (Object)"int").put((Object)Character.valueOf('o'), (Object)"int").put((Object)Character.valueOf('x'), (Object)"int").put((Object)Character.valueOf('X'), (Object)"int").put((Object)Character.valueOf('n'), (Object)"int or long or float or complex").put((Object)Character.valueOf('e'), (Object)"long or float or complex").put((Object)Character.valueOf('E'), (Object)"long or float or complex").put((Object)Character.valueOf('f'), (Object)"long or float or complex").put((Object)Character.valueOf('F'), (Object)"long or float or complex").put((Object)Character.valueOf('g'), (Object)"long or float or complex").put((Object)Character.valueOf('G'), (Object)"long or float or complex").put((Object)Character.valueOf('%'), (Object)"long or float").build();
            private final PyStringLiteralExpression myFormatExpression;
            private boolean myProblemRegister = false;
            private final Visitor myVisitor;
            private final TypeEvalContext myTypeEvalContext;
            private final Map<String, String> myFormatSpec = new HashMap<String, String>();

            NewStyleInspection(PyStringLiteralExpression formatExpression, Visitor visitor2, TypeEvalContext context) {
                this.myFormatExpression = formatExpression;
                this.myVisitor = visitor2;
                this.myTypeEvalContext = context;
            }

            public void inspect() {
                String value = this.myFormatExpression.getText();
                PyStringFormatParser parser = new PyStringFormatParser(value);
                List chunks = ContainerUtil.findAll(parser.parseNewStyle(), PyStringFormatParser.NewStyleSubstitutionChunk.class);
                for (int i = 0; i < chunks.size(); ++i) {
                    PyStringFormatParser.NewStyleSubstitutionChunk prevChunk = i > 0 ? (PyStringFormatParser.NewStyleSubstitutionChunk)chunks.get(i - 1) : null;
                    PyStringFormatParser.NewStyleSubstitutionChunk chunk = (PyStringFormatParser.NewStyleSubstitutionChunk)chunks.get(i);
                    if (prevChunk != null) {
                        if (prevChunk.getManualPosition() != null && chunk.getAutoPosition() != null) {
                            this.registerProblem(this.myFormatExpression, PyBundle.message("INSP.manual.to.auto.field.numbering", new Object[0]));
                        } else if (prevChunk.getAutoPosition() != null && chunk.getManualPosition() != null) {
                            this.registerProblem(this.myFormatExpression, PyBundle.message("INSP.auto.to.manual.field.numbering", new Object[0]));
                        }
                    }
                    String mappingKey = this.inspectNewStyleChunkAndGetMappingKey(chunk);
                    if (this.isProblem()) continue;
                    this.inspectArguments(chunk, mappingKey);
                }
            }

            private String inspectNewStyleChunkAndGetMappingKey(@NotNull PyStringFormatParser.NewStyleSubstitutionChunk chunk) {
                char conversionType;
                String mappingKey;
                if (chunk == null) {
                    NewStyleInspection.$$$reportNull$$$0(0);
                }
                HashSet<String> supportedTypes = new HashSet<String>();
                boolean hasTypeOptions = false;
                String string = mappingKey = chunk.getMappingKey() != null ? chunk.getMappingKey() : String.valueOf(chunk.getPosition());
                if (chunk.hasSignOption() || chunk.useAlternateForm() || chunk.hasZeroPadding() || chunk.hasThousandsSeparator()) {
                    NewStyleInspection.specifyTypes(supportedTypes, NUMERIC_TYPES);
                    hasTypeOptions = true;
                }
                if (chunk.getPrecision() != null) {
                    List<String> availableTypes = Arrays.asList("str", "float", "complex");
                    NewStyleInspection.specifyTypes(supportedTypes, availableTypes);
                    hasTypeOptions = true;
                }
                if ((conversionType = chunk.getConversionType()) != '\u0000') {
                    if (NEW_STYLE_FORMAT_CONVERSIONS.containsKey((Object)Character.valueOf(conversionType))) {
                        String[] s = ((String)NEW_STYLE_FORMAT_CONVERSIONS.get((Object)Character.valueOf(conversionType))).split(" or ");
                        NewStyleInspection.specifyTypes(supportedTypes, Arrays.asList(s));
                        hasTypeOptions = true;
                    } else {
                        this.registerProblem(this.myFormatExpression, PyBundle.message("INSP.unsupported.format.character", Character.valueOf(conversionType)));
                    }
                }
                if (!supportedTypes.isEmpty()) {
                    this.myFormatSpec.put(mappingKey, StringUtil.join(supportedTypes, (String)" or "));
                } else if (hasTypeOptions) {
                    this.registerProblem(this.myFormatExpression, PyBundle.message("INSP.incompatible.options", mappingKey));
                }
                return mappingKey;
            }

            private void inspectArguments(@NotNull PyStringFormatParser.NewStyleSubstitutionChunk chunk, @NotNull String mappingKey) {
                boolean hasElementIndex;
                if (chunk == null) {
                    NewStyleInspection.$$$reportNull$$$0(1);
                }
                if (mappingKey == null) {
                    NewStyleInspection.$$$reportNull$$$0(2);
                }
                PsiElement target = new PySubstitutionChunkReference(this.myFormatExpression, chunk).resolve();
                boolean bl = hasElementIndex = chunk.getMappingKeyElementIndex() != null;
                if (target == null) {
                    String chunkMapping = chunk.getMappingKey();
                    if (chunkMapping != null) {
                        this.registerProblem(this.myFormatExpression, hasElementIndex ? PyBundle.message("INSP.too.few.args.for.fmt.string", new Object[0]) : PyBundle.message("INSP.key.$0.has.no.arg", chunkMapping));
                    } else {
                        this.registerProblem(this.myFormatExpression, PyBundle.message("INSP.too.few.args.for.fmt.string", new Object[0]));
                    }
                } else {
                    this.checkTypesCompatibleForCheckedTypesOnly(this.myFormatExpression, target, mappingKey);
                }
            }

            private void registerProblem(@NotNull PsiElement problemTarget, @NotNull String message) {
                if (problemTarget == null) {
                    NewStyleInspection.$$$reportNull$$$0(3);
                }
                if (message == null) {
                    NewStyleInspection.$$$reportNull$$$0(4);
                }
                this.myProblemRegister = true;
                this.myVisitor.registerProblem(problemTarget, message);
            }

            private void checkTypesCompatibleForCheckedTypesOnly(@NotNull PyStringLiteralExpression anchor, @NotNull PsiElement target, @NotNull String mappingKey) {
                PyTypedElement typedElement;
                if (anchor == null) {
                    NewStyleInspection.$$$reportNull$$$0(5);
                }
                if (target == null) {
                    NewStyleInspection.$$$reportNull$$$0(6);
                }
                if (mappingKey == null) {
                    NewStyleInspection.$$$reportNull$$$0(7);
                }
                if ((typedElement = PyUtil.as(target, PyTypedElement.class)) != null && this.myFormatSpec.containsKey(mappingKey)) {
                    PyType actual = this.myTypeEvalContext.getType(typedElement);
                    PyType expected = PyTypeParser.getTypeByName(anchor, this.myFormatSpec.get(mappingKey));
                    if (expected != null && actual != null && CHECKED_TYPES.contains(actual.getName()) && !PyTypeChecker.match(expected, actual, this.myTypeEvalContext)) {
                        this.registerProblem((PsiElement)typedElement, PyBundle.message("INSP.unexpected.type.$0", actual.getName()));
                    }
                }
            }

            private static void specifyTypes(@NotNull Set<String> types, @NotNull List<String> supportedTypes) {
                if (types == null) {
                    NewStyleInspection.$$$reportNull$$$0(8);
                }
                if (supportedTypes == null) {
                    NewStyleInspection.$$$reportNull$$$0(9);
                }
                if (types.isEmpty()) {
                    types.addAll(supportedTypes);
                } else {
                    types.retainAll(supportedTypes);
                }
            }

            public boolean isProblem() {
                return this.myProblemRegister;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "chunk";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "mappingKey";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problemTarget";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "anchor";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "types";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "supportedTypes";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$NewStyleInspection";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectNewStyleChunkAndGetMappingKey";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectArguments";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypesCompatibleForCheckedTypesOnly";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "specifyTypes";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }

        private static class Inspection {
            private static final ImmutableMap<Character, String> PERCENT_FORMAT_CONVERSIONS = ImmutableMap.builder().put((Object)Character.valueOf('d'), (Object)"int or long or float").put((Object)Character.valueOf('i'), (Object)"int or long or float").put((Object)Character.valueOf('o'), (Object)"int or long or float").put((Object)Character.valueOf('u'), (Object)"int or long or float").put((Object)Character.valueOf('x'), (Object)"int or long or float").put((Object)Character.valueOf('X'), (Object)"int or long or float").put((Object)Character.valueOf('e'), (Object)"float").put((Object)Character.valueOf('E'), (Object)"float").put((Object)Character.valueOf('f'), (Object)"float").put((Object)Character.valueOf('F'), (Object)"float").put((Object)Character.valueOf('g'), (Object)"float").put((Object)Character.valueOf('G'), (Object)"float").put((Object)Character.valueOf('c'), (Object)"str").put((Object)Character.valueOf('r'), (Object)"str").put((Object)Character.valueOf('a'), (Object)"str").put((Object)Character.valueOf('s'), (Object)"str").put((Object)Character.valueOf('b'), (Object)"bytes").build();
            private final Map<String, Boolean> myUsedMappingKeys = new HashMap<String, Boolean>();
            private int myExpectedArguments = 0;
            private boolean myProblemRegister = false;
            private final Visitor myVisitor;
            private final TypeEvalContext myTypeEvalContext;
            private final Map<String, String> myFormatSpec = new HashMap<String, String>();

            Inspection(Visitor visitor2, TypeEvalContext typeEvalContext) {
                this.myVisitor = visitor2;
                this.myTypeEvalContext = typeEvalContext;
            }

            private int inspectArguments(@Nullable PyExpression rightExpression, @NotNull PsiElement problemTarget) {
                if (problemTarget == null) {
                    Inspection.$$$reportNull$$$0(0);
                }
                Class[] SIMPLE_RHS_EXPRESSIONS = new Class[]{PyLiteralExpression.class, PySubscriptionExpression.class, PyBinaryExpression.class, PyConditionalExpression.class};
                PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(problemTarget);
                PyResolveContext resolveContext = PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext);
                String s = this.myFormatSpec.get("1");
                if (PsiTreeUtil.instanceOf((Object)rightExpression, (Class[])SIMPLE_RHS_EXPRESSIONS)) {
                    if (s != null) {
                        PyType rightType = this.myTypeEvalContext.getType(rightExpression);
                        if (rightType instanceof PyTupleType) {
                            PyTupleType tupleType = (PyTupleType)rightType;
                            for (int i = 0; i < tupleType.getElementCount(); ++i) {
                                PyType elementType = tupleType.getElementType(i);
                                if (elementType == null) continue;
                                String typeName = this.myFormatSpec.get(String.valueOf(i + 1));
                                PyType type = typeName != null ? PyTypeParser.getTypeByName(problemTarget, typeName, this.myTypeEvalContext) : null;
                                this.checkTypeCompatible(problemTarget, elementType, type);
                            }
                            return tupleType.getElementCount();
                        }
                        this.checkExpressionType(rightExpression, s, problemTarget);
                    }
                    return 1;
                }
                if (rightExpression instanceof PyReferenceExpression) {
                    if ("__dict__".equals(rightExpression.getName())) {
                        return -1;
                    }
                    List<QualifiedRatedResolveResult> resolveResults = ((PyReferenceExpression)rightExpression).multiFollowAssignmentsChain(resolveContext);
                    if (resolveResults.isEmpty()) {
                        return -1;
                    }
                    PsiElement pyElement = PyUtil.filterTopPriorityResults(resolveResults).get(0).getElement();
                    if (pyElement == rightExpression || !(pyElement instanceof PyExpression)) {
                        return -1;
                    }
                    if (pyElement instanceof PyDictLiteralExpression) {
                        return this.inspectDict(rightExpression, problemTarget, true);
                    }
                    return this.inspectArguments((PyExpression)pyElement, problemTarget);
                }
                if (rightExpression instanceof PyCallExpression) {
                    PyExpression callee = ((PyCallExpression)rightExpression).getCallee();
                    if (callee != null && "dict".equals(callee.getName())) {
                        return 1;
                    }
                    return Visitor.inspectCallExpression((PyCallExpression)rightExpression, resolveContext, this.myTypeEvalContext);
                }
                if (rightExpression instanceof PyParenthesizedExpression) {
                    PyExpression rhs = ((PyParenthesizedExpression)rightExpression).getContainedExpression();
                    if (rhs != null) {
                        return this.inspectArguments(rhs, (PsiElement)rhs);
                    }
                } else {
                    if (rightExpression instanceof PyTupleExpression) {
                        PyExpression[] expressions = ((PyTupleExpression)rightExpression).getElements();
                        int i = 1;
                        for (PyExpression expression : expressions) {
                            String formatSpec = this.myFormatSpec.get(Integer.toString(i));
                            if (formatSpec != null) {
                                this.checkExpressionType(expression, formatSpec, (PsiElement)expression);
                            }
                            ++i;
                        }
                        return expressions.length;
                    }
                    if (rightExpression instanceof PyDictLiteralExpression) {
                        return this.inspectDict(rightExpression, problemTarget, false);
                    }
                    if (PsiTreeUtil.instanceOf((Object)rightExpression, (Class[])new Class[]{PySequenceExpression.class, PyComprehensionElement.class})) {
                        if (s != null) {
                            this.checkTypeCompatible(problemTarget, builtinCache.getStrType(), PyTypeParser.getTypeByName(problemTarget, s, this.myTypeEvalContext));
                            return 1;
                        }
                    } else if (rightExpression instanceof PySliceExpression && s != null) {
                        PyType type = this.myTypeEvalContext.getType(((PySliceExpression)rightExpression).getOperand());
                        PyType stringType = PyBuiltinCache.getInstance((PsiElement)rightExpression).getStringType(LanguageLevel.forElement((PsiElement)rightExpression));
                        PyClassType listType = PyBuiltinCache.getInstance((PsiElement)rightExpression).getListType();
                        if (type == null) {
                            return -1;
                        }
                        if (PyTypeChecker.match((PyType)listType, type, this.myTypeEvalContext) || PyTypeChecker.match(stringType, type, this.myTypeEvalContext)) {
                            this.checkTypeCompatible(problemTarget, builtinCache.getStrType(), PyTypeParser.getTypeByName(problemTarget, s, this.myTypeEvalContext));
                            return 1;
                        }
                        PySliceItem sliceItem = ((PySliceExpression)rightExpression).getSliceItem();
                        if (sliceItem != null) {
                            PyExpression lower = sliceItem.getLowerBound();
                            PyExpression upper = sliceItem.getUpperBound();
                            PyExpression stride = sliceItem.getStride();
                            if (upper instanceof PyNumericLiteralExpression) {
                                BigInteger lowerVal = lower instanceof PyNumericLiteralExpression ? ((PyNumericLiteralExpression)lower).getBigIntegerValue() : BigInteger.ZERO;
                                int count = ((PyNumericLiteralExpression)upper).getBigIntegerValue().subtract(lowerVal).intValue();
                                int strideVal = stride instanceof PyNumericLiteralExpression ? ((PyNumericLiteralExpression)stride).getBigIntegerValue().intValue() : 1;
                                int res = count / strideVal;
                                int residue = count % strideVal == 0 ? 0 : 1;
                                return res + residue;
                            }
                        }
                        return -1;
                    }
                }
                return -1;
            }

            private static Map<PyExpression, PyExpression> addSubscriptions(PsiFile file, String operand) {
                HashMap<PyExpression, PyExpression> additionalExpressions = new HashMap<PyExpression, PyExpression>();
                Collection subscriptionExpressions = PsiTreeUtil.findChildrenOfType((PsiElement)file, PySubscriptionExpression.class);
                for (PySubscriptionExpression expr : subscriptionExpressions) {
                    PyExpression key;
                    PsiElement parent;
                    if (!expr.getOperand().getText().equals(operand) || !((parent = expr.getParent()) instanceof PyAssignmentStatement) || !expr.equals(((PyAssignmentStatement)parent).getLeftHandSideExpression()) || (key = expr.getIndexExpression()) == null) continue;
                    additionalExpressions.put(key, ((PyAssignmentStatement)parent).getAssignedValue());
                }
                return additionalExpressions;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private int inspectDict(PyExpression rightExpression, PsiElement problemTarget, boolean addSubscriptions) {
                PyExpression pyElement;
                Map<Object, Object> additionalExpressions;
                if (addSubscriptions) {
                    additionalExpressions = Inspection.addSubscriptions(rightExpression.getContainingFile(), rightExpression.getText());
                    pyElement = ((PyReferenceExpression)rightExpression).followAssignmentsChain(PyResolveContext.noImplicits().withTypeEvalContext(this.myTypeEvalContext)).getElement();
                } else {
                    additionalExpressions = new HashMap();
                    pyElement = rightExpression;
                }
                if (pyElement == null) {
                    return 0;
                }
                PyKeyValueExpression[] expressions = ((PyDictLiteralExpression)pyElement).getElements();
                if (this.myUsedMappingKeys.isEmpty()) {
                    if (this.myExpectedArguments <= 0) return 0;
                    if (this.myExpectedArguments <= 1 || this.myExpectedArguments != expressions.length + additionalExpressions.size()) return 1;
                    this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.format.requires.no.mapping", new Object[0]));
                }
                int referenceKeyNumber = 0;
                for (PyKeyValueExpression expression : expressions) {
                    PyExpression key = expression.getKey();
                    PyExpression value = expression.getValue();
                    if (key instanceof PyStringLiteralExpression) {
                        this.resolveMappingKey(problemTarget, (PyStringLiteralExpression)key, value);
                        continue;
                    }
                    if (!(key instanceof PyReferenceExpression)) continue;
                    ++referenceKeyNumber;
                }
                for (Map.Entry entry : additionalExpressions.entrySet()) {
                    PyExpression key = (PyExpression)entry.getKey();
                    PyExpression value = (PyExpression)entry.getValue();
                    if (key instanceof PyStringLiteralExpression) {
                        this.resolveMappingKey(problemTarget, (PyStringLiteralExpression)key, value);
                        continue;
                    }
                    if (!(key instanceof PyReferenceExpression)) continue;
                    ++referenceKeyNumber;
                }
                int unresolved = 0;
                for (String key : this.myUsedMappingKeys.keySet()) {
                    if (this.myUsedMappingKeys.get(key).booleanValue() || ++unresolved <= referenceKeyNumber) continue;
                    this.registerProblem(problemTarget, PyBundle.message("INSP.key.$0.has.no.arg", key));
                    return expressions.length + additionalExpressions.size();
                }
                return expressions.length + additionalExpressions.size();
            }

            private void resolveMappingKey(PsiElement problemTarget, PyStringLiteralExpression key, PyExpression value) {
                String name = key.getStringValue();
                if (this.myUsedMappingKeys.get(name) != null) {
                    this.myUsedMappingKeys.put(name, true);
                    if (value != null) {
                        this.checkExpressionType(value, this.myFormatSpec.get(name), problemTarget);
                    }
                }
            }

            private void registerProblem(@NotNull PsiElement problemTarget, @NotNull String message, @NotNull LocalQuickFix quickFix) {
                if (problemTarget == null) {
                    Inspection.$$$reportNull$$$0(1);
                }
                if (message == null) {
                    Inspection.$$$reportNull$$$0(2);
                }
                if (quickFix == null) {
                    Inspection.$$$reportNull$$$0(3);
                }
                this.myProblemRegister = true;
                this.myVisitor.registerProblem(problemTarget, message, quickFix);
            }

            private void registerProblem(@NotNull PsiElement problemTarget, @NotNull String message) {
                if (problemTarget == null) {
                    Inspection.$$$reportNull$$$0(4);
                }
                if (message == null) {
                    Inspection.$$$reportNull$$$0(5);
                }
                this.myProblemRegister = true;
                this.myVisitor.registerProblem(problemTarget, message);
            }

            private void checkExpressionType(@NotNull PyExpression expression, @NotNull String expectedTypeName, @NotNull PsiElement problemTarget) {
                if (expression == null) {
                    Inspection.$$$reportNull$$$0(6);
                }
                if (expectedTypeName == null) {
                    Inspection.$$$reportNull$$$0(7);
                }
                if (problemTarget == null) {
                    Inspection.$$$reportNull$$$0(8);
                }
                PyType actual = this.myTypeEvalContext.getType(expression);
                PyType expected = PyTypeParser.getTypeByName(problemTarget, expectedTypeName, this.myTypeEvalContext);
                if (actual != null) {
                    this.checkTypeCompatible(problemTarget, actual, expected);
                }
            }

            private void checkTypeCompatible(@NotNull PsiElement problemTarget, @Nullable PyType actual, @Nullable PyType expected) {
                if (problemTarget == null) {
                    Inspection.$$$reportNull$$$0(9);
                }
                if (expected != null && "str".equals(expected.getName())) {
                    return;
                }
                if (actual != null && !PyTypeChecker.match(expected, actual, this.myTypeEvalContext)) {
                    this.registerProblem(problemTarget, PyBundle.message("INSP.unexpected.type.$0", actual.getName()));
                }
            }

            private void inspectPercentFormat(@NotNull PyStringLiteralExpression formatExpression) {
                if (formatExpression == null) {
                    Inspection.$$$reportNull$$$0(10);
                }
                String value = formatExpression.getText();
                List<PyStringFormatParser.SubstitutionChunk> chunks = PyStringFormatParser.filterSubstitutions(PyStringFormatParser.parsePercentFormat(value));
                this.myExpectedArguments = chunks.size();
                this.myUsedMappingKeys.clear();
                boolean mapping = chunks.size() > 0 && chunks.get(0).getMappingKey() != null;
                for (int i = 0; i < chunks.size(); ++i) {
                    LanguageLevel languageLevel;
                    PyStringFormatParser.PercentSubstitutionChunk chunk = PyUtil.as(chunks.get(i), PyStringFormatParser.PercentSubstitutionChunk.class);
                    if (chunk == null) continue;
                    String mappingKey = Integer.toString(i + 1);
                    if (mapping) {
                        if (chunk.getMappingKey() == null || chunk.isUnclosedMapping()) {
                            this.registerProblem(formatExpression, PyBundle.message("INSP.too.few.keys", new Object[0]));
                            break;
                        }
                        mappingKey = chunk.getMappingKey();
                        this.myUsedMappingKeys.put(mappingKey, false);
                    }
                    this.inspectWidth(formatExpression, chunk.getWidth());
                    this.inspectWidth(formatExpression, chunk.getPrecision());
                    char conversionType = chunk.getConversionType();
                    if (conversionType == 'b' && ((languageLevel = LanguageLevel.forElement(formatExpression)).isOlderThan(LanguageLevel.PYTHON35) || !Inspection.isBytesLiteral(formatExpression, this.myTypeEvalContext))) {
                        this.registerProblem(formatExpression, "Unsupported format character 'b'");
                        return;
                    }
                    languageLevel = LanguageLevel.forElement(formatExpression);
                    if (PERCENT_FORMAT_CONVERSIONS.containsKey((Object)Character.valueOf(conversionType)) && (!languageLevel.isPython2() || conversionType != 'a')) {
                        this.myFormatSpec.put(mappingKey, (String)PERCENT_FORMAT_CONVERSIONS.get((Object)Character.valueOf(conversionType)));
                        continue;
                    }
                    this.registerProblem(formatExpression, PyBundle.message("INSP.no.format.specifier.char", new Object[0]), new PyAddSpecifierToFormatQuickFix());
                    return;
                }
            }

            private static boolean isBytesLiteral(@NotNull PyStringLiteralExpression expr, @NotNull TypeEvalContext context) {
                if (expr == null) {
                    Inspection.$$$reportNull$$$0(11);
                }
                if (context == null) {
                    Inspection.$$$reportNull$$$0(12);
                }
                PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(expr);
                PyClassType bytesType = builtinCache.getBytesType(LanguageLevel.forElement(expr));
                PyType actualType = context.getType(expr);
                return bytesType != null && actualType != null && PyTypeChecker.match((PyType)bytesType, actualType, context);
            }

            private void inspectWidth(@NotNull PyStringLiteralExpression formatExpression, String width) {
                if (formatExpression == null) {
                    Inspection.$$$reportNull$$$0(13);
                }
                if ("*".equals(width)) {
                    ++this.myExpectedArguments;
                    if (this.myUsedMappingKeys.size() > 0) {
                        this.registerProblem(formatExpression, "Can't use '*' in formats when using a mapping");
                    }
                }
            }

            public boolean isProblem() {
                return this.myProblemRegister;
            }

            private void inspectValues(@Nullable PyExpression rightExpression) {
                if (rightExpression == null) {
                    return;
                }
                if (rightExpression instanceof PyParenthesizedExpression) {
                    this.inspectValues(((PyParenthesizedExpression)rightExpression).getContainedExpression());
                } else {
                    PyClassType type = PyUtil.as(this.myTypeEvalContext.getType(rightExpression), PyClassType.class);
                    if (type != null && this.myUsedMappingKeys.size() > 0 && !PyABCUtil.isSubclass(type.getPyClass(), "Mapping", this.myTypeEvalContext)) {
                        this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.format.requires.mapping", new Object[0]));
                        return;
                    }
                    this.inspectArgumentsNumber(rightExpression);
                }
            }

            private void inspectArgumentsNumber(@NotNull PyExpression rightExpression) {
                if (rightExpression == null) {
                    Inspection.$$$reportNull$$$0(14);
                }
                int arguments = this.inspectArguments(rightExpression, (PsiElement)rightExpression);
                if (this.myUsedMappingKeys.isEmpty() && arguments >= 0) {
                    if (this.myExpectedArguments < arguments) {
                        this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.too.many.args.for.fmt.string", new Object[0]));
                    } else if (this.myExpectedArguments > arguments) {
                        this.registerProblem((PsiElement)rightExpression, PyBundle.message("INSP.too.few.args.for.fmt.string", new Object[0]));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problemTarget";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "quickFix";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedTypeName";
                        break;
                    }
                    case 10: 
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "formatExpression";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expr";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 14: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rightExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/inspections/PyStringFormatInspection$Visitor$Inspection";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectArguments";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "registerProblem";
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkExpressionType";
                        break;
                    }
                    case 9: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkTypeCompatible";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectPercentFormat";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isBytesLiteral";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectWidth";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray2;
                        objectArray2[2] = "inspectArgumentsNumber";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

