/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.search;

public class SearchOptions {
    public static final boolean USE_REGEX_DEFAULT_SETTING = false;
    public static final boolean DEFAULT_CASE_SENSITIVE_SETTING = false;
    public static final boolean DEFAULT_IGNORE_WHITE_SPACE_SETTING = false;
    public static final boolean DEFAULT_WHOLE_WORDS_SETTING = false;
    public static final boolean DEFAULT_SHOW_ALL_RESULTS_SETTING = false;
    public static final boolean DEFAULT_SEARCH_IN_ANNOTATION_VALUES_SETTING = true;
    public static final boolean DEFAULT_SEARCH_IN_LOGICAL_AXIOM_SETTING = true;
    public static final boolean DEFAULT_SEARCH_IN_IRIS_SETTING = true;
    private final boolean useRegex;
    private final boolean caseSensitive;
    private final boolean wholeWords;
    private final boolean ignoreWhiteSpace;
    private final boolean showAllResults;
    private final boolean searchInAnnotationValues;
    private final boolean searchInLogicalAxioms;
    private final boolean searchInIRIs;

    public SearchOptions() {
        this.useRegex = false;
        this.caseSensitive = false;
        this.wholeWords = false;
        this.ignoreWhiteSpace = false;
        this.showAllResults = false;
        this.searchInAnnotationValues = true;
        this.searchInLogicalAxioms = true;
        this.searchInIRIs = true;
    }

    private SearchOptions(Builder builder) {
        this.useRegex = builder.isUseRegex();
        this.caseSensitive = builder.isCaseSensitive();
        this.wholeWords = builder.isWholeWords();
        this.ignoreWhiteSpace = builder.isIgnoreWhiteSpace();
        this.showAllResults = builder.isShowAllResults();
        this.searchInAnnotationValues = builder.isSearchInAnnotationValues();
        this.searchInLogicalAxioms = builder.isSearchInLogicalAxioms();
        this.searchInIRIs = builder.isSearchInIRIs();
    }

    public boolean isUseRegex() {
        return this.useRegex;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public boolean isIgnoreWhiteSpace() {
        return this.ignoreWhiteSpace;
    }

    public boolean isShowAllResults() {
        return this.showAllResults;
    }

    public boolean isSearchInAnnotationValues() {
        return this.searchInAnnotationValues;
    }

    public boolean isSearchInLogicalAxioms() {
        return this.searchInLogicalAxioms;
    }

    public boolean isSearchInIRIs() {
        return this.searchInIRIs;
    }

    public static class Builder {
        private boolean useRegex = false;
        private boolean caseSensitive = false;
        private boolean wholeWords = false;
        private boolean ignoreWhiteSpace = false;
        private boolean showAllResults;
        private boolean searchInAnnotationValues;
        private boolean searchInLogicalAxioms;
        private boolean searchInIRIs;

        public SearchOptions build() {
            return new SearchOptions(this);
        }

        public void setUseRegex(boolean useRegex) {
            this.useRegex = useRegex;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
        }

        public void setWholeWords(boolean wholeWords) {
            this.wholeWords = wholeWords;
        }

        public void setIgnoreWhiteSpace(boolean ignoreWhiteSpace) {
            this.ignoreWhiteSpace = ignoreWhiteSpace;
        }

        public void setShowAllResults(boolean showAllResults) {
            this.showAllResults = showAllResults;
        }

        public void setSearchInAnnotationValues(boolean searchInAnnotationValues) {
            this.searchInAnnotationValues = searchInAnnotationValues;
        }

        public void setSearchInLogicalAxioms(boolean searchInLogicalAxioms) {
            this.searchInLogicalAxioms = searchInLogicalAxioms;
        }

        public void setSearchInIRIs(boolean searchInIRIs) {
            this.searchInIRIs = searchInIRIs;
        }

        public boolean isUseRegex() {
            return this.useRegex;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public boolean isWholeWords() {
            return this.wholeWords;
        }

        public boolean isIgnoreWhiteSpace() {
            return this.ignoreWhiteSpace;
        }

        public boolean isShowAllResults() {
            return this.showAllResults;
        }

        public boolean isSearchInAnnotationValues() {
            return this.searchInAnnotationValues;
        }

        public boolean isSearchInLogicalAxioms() {
            return this.searchInLogicalAxioms;
        }

        public boolean isSearchInIRIs() {
            return this.searchInIRIs;
        }
    }
}

