/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.LinkedObjectComponent;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class LinkedObjectComponentMediator {
    private OWLEditorKit editorKit;
    private LinkedObjectComponent linkedObjectComponent;
    private MouseMotionListener mouseMotionListener;
    private MouseListener mouseListener;
    private Rectangle rect;
    private OWLObject linkedObject;
    private Cursor defaultCursor;

    public LinkedObjectComponentMediator(OWLEditorKit owlEditorKit, LinkedObjectComponent linkedObjectComponent) {
        this.linkedObjectComponent = linkedObjectComponent;
        this.editorKit = owlEditorKit;
        this.mouseMotionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                LinkedObjectComponentMediator.this.doUpdate(e.getPoint());
            }
        };
        this.mouseListener = new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                LinkedObjectComponentMediator.this.navigateToObject();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkedObjectComponentMediator.this.doUpdate(e.getPoint());
            }
        };
        linkedObjectComponent.getComponent().addMouseMotionListener(this.mouseMotionListener);
        linkedObjectComponent.getComponent().addMouseListener(this.mouseListener);
    }

    public void setLinkedObject(OWLObject linkedObject) {
        this.linkedObject = linkedObject;
        if (linkedObject != null) {
            this.linkedObjectComponent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.linkedObjectComponent.getComponent().setCursor(this.defaultCursor);
        }
    }

    private void navigateToObject() {
        OWLObject object = this.linkedObjectComponent.getLinkedObject();
        if (!(object instanceof OWLEntity)) {
            return;
        }
        this.editorKit.getWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)object);
        this.editorKit.getWorkspace().displayOWLEntity((OWLEntity)object);
    }

    private void doUpdate(Point mousePoint) {
        if (this.rect != null) {
            this.linkedObjectComponent.getComponent().repaint(this.rect);
        }
        this.rect = this.linkedObjectComponent.getMouseCellRect();
        if (this.rect != null) {
            this.linkedObjectComponent.getComponent().repaint(this.rect);
        }
    }

    public void dispose() {
        this.linkedObjectComponent.getComponent().removeMouseMotionListener(this.mouseMotionListener);
        this.linkedObjectComponent.getComponent().removeMouseListener(this.mouseListener);
    }

    public OWLObject getLinkedObject() {
        return this.linkedObject;
    }
}

