/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.util.Collection;
import java.util.Objects;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.form.PDField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignatureClipper {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureClipper.class);

    private SignatureClipper() {
    }

    public static void clipSignatures(Collection<PDAnnotation> annotations) {
        if (Objects.nonNull(annotations)) {
            for (PDAnnotation annotation : annotations) {
                if (!COSName.WIDGET.getName().equals(annotation.getSubtype()) || !COSName.SIG.equals((Object)annotation.getCOSObject().getCOSName(COSName.FT))) continue;
                SignatureClipper.clipSignature(annotation.getCOSObject());
            }
        }
    }

    public static void clipSignatures(PDDocument doc) {
        for (PDPage page : doc.getPages()) {
            SignatureClipper.clipSignatures(page.getAnnotations());
        }
    }

    public static boolean clipSignature(PDField field) {
        if (Objects.nonNull(field) && COSName.SIG.getName().equals(field.getFieldType())) {
            SignatureClipper.clipSignature(field.getCOSObject());
            return true;
        }
        return false;
    }

    private static void clipSignature(COSDictionary item) {
        LOG.info("Removing signature value from the field if any");
        item.removeItem(COSName.V);
        item.removeItem(COSName.SV);
        item.removeItem(COSName.LOCK);
    }
}

