/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sejda.model.exception.TaskIOException;
import org.sejda.model.scale.Margins;
import org.sejda.model.scale.ScaleType;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSFloat;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.PDPage;
import org.sejda.sambox.pdmodel.PDPageContentStream;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotation;
import org.sejda.sambox.pdmodel.interactive.annotation.PDAnnotationLine;
import org.sejda.sambox.util.Matrix;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfScaler {
    private static final Logger LOG = LoggerFactory.getLogger(PdfScaler.class);
    private ScaleType type;

    public PdfScaler(ScaleType type) {
        RequireUtils.requireNotNullArg((Object)type, (String)"Scale type cannot be null");
        this.type = type;
    }

    public void scalePages(PDDocument doc) throws TaskIOException {
        PDPage firstPage = doc.getPage(0);
        PDRectangle targetBox = firstPage.getCropBox().rotate(firstPage.getRotation());
        this.scalePages(doc, (Iterable<PDPage>)doc.getPages(), targetBox);
    }

    public void scalePages(PDDocument doc, Iterable<PDPage> pages, PDRectangle targetBox) throws TaskIOException {
        for (PDPage page : pages) {
            PDRectangle cropBox = page.getCropBox().rotate(page.getRotation());
            double scale = this.getScalingFactorMatchWidth(targetBox, cropBox);
            LOG.debug("Scaling page from {} to {}, factor of {}", new Object[]{cropBox, targetBox, scale});
            this.scale(doc, page, scale);
        }
    }

    public void changePageSize(PDDocument doc, Iterable<PDPage> pages, PDRectangle desiredPageSize) throws TaskIOException {
        for (PDPage page : pages) {
            this.changePageSize(doc, page, desiredPageSize);
        }
    }

    public void scale(PDDocument doc, double scale) throws TaskIOException {
        this.scale(doc, (Iterable<PDPage>)doc.getPages(), scale);
    }

    public void scale(PDDocument doc, PDPage page, double scale) throws TaskIOException {
        this.scale(doc, Collections.singletonList(page), scale);
    }

    public void scale(PDDocument doc, Iterable<PDPage> pages, double scale) throws TaskIOException {
        if (scale != 1.0) {
            this.doScale(doc, pages, scale);
        }
    }

    public void changePageSize(PDDocument doc, PDPage page, PDRectangle desiredPageSize) throws TaskIOException {
        boolean mismatchingOrientation;
        PDRectangle scaledPageSize;
        PDRectangle currentPageSize = page.getCropBox().rotate(page.getRotation());
        LOG.debug("Current page size: {}", (Object)currentPageSize);
        LOG.debug("Desired page size: {}", (Object)desiredPageSize);
        double scale = this.getScalingFactorMatchWidthOrHeight(desiredPageSize, currentPageSize);
        this.doScale(doc, Collections.singletonList(page), scale);
        PDRectangle normalizedScaledPageSize = scaledPageSize = page.getCropBox().rotate(page.getRotation());
        boolean bl = mismatchingOrientation = this.isLandscape(scaledPageSize) != this.isLandscape(desiredPageSize);
        if (mismatchingOrientation) {
            normalizedScaledPageSize = scaledPageSize.rotate();
        }
        double widthDiff = desiredPageSize.getWidth() - normalizedScaledPageSize.getWidth();
        double heightDiff = desiredPageSize.getHeight() - normalizedScaledPageSize.getHeight();
        if (widthDiff < 1.0) {
            widthDiff = 0.0;
        }
        if (heightDiff < 1.0) {
            heightDiff = 0.0;
        }
        if (widthDiff > 0.0 || heightDiff > 0.0) {
            double top = Margins.pointsToInches((double)heightDiff) / 2.0;
            double left = Margins.pointsToInches((double)widthDiff) / 2.0;
            Margins margins = new Margins(top, left, top, left);
            if (mismatchingOrientation) {
                margins = margins.rotate();
            }
            PdfScaler.margin(doc, Collections.singleton(page), margins);
        }
        PDRectangle finalPageSize = page.getCropBox().rotate(page.getRotation());
    }

    private void doScale(PDDocument doc, Iterable<PDPage> pages, double scale) throws TaskIOException {
        HashSet<COSDictionary> processedAnnots = new HashSet<COSDictionary>();
        for (PDPage page : pages) {
            try {
                PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.PREPEND, true);
                Throwable throwable = null;
                try {
                    Matrix matrix = this.getMatrix(scale, page.getCropBox(), page.getCropBox());
                    contentStream.transform(matrix);
                    if (ScaleType.PAGE == this.type) {
                        this.scalePageBoxes(scale, page);
                    } else {
                        this.scaleContentBoxes(scale, page);
                    }
                    PdfScaler.transformAnnotations(page, matrix, processedAnnots);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contentStream == null) continue;
                    if (throwable != null) {
                        try {
                            contentStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    contentStream.close();
                }
            }
            catch (IOException e) {
                throw new TaskIOException("An error occurred writing scaling the page.", (Throwable)e);
            }
        }
    }

    private static void transformAnnotations(PDPage page, Matrix transform, Set<COSDictionary> processedAnnots) {
        page.getAnnotations().stream().filter(a -> !processedAnnots.contains(a.getCOSObject())).forEach(a -> {
            Optional.ofNullable(a.getRectangle()).map(r -> r.transform(transform).getBounds2D()).map(PDRectangle::new).ifPresent(arg_0 -> ((PDAnnotation)a).setRectangle(arg_0));
            Optional.ofNullable(a.getCOSObject().getDictionaryObject(COSName.QUADPOINTS, COSArray.class)).filter(p -> p.size() == 8).map(COSArray::toFloatArray).ifPresent(f -> a.getCOSObject().setItem(COSName.QUADPOINTS, (COSBase)PdfScaler.transformPoints(f, transform)));
            if (a instanceof PDAnnotationLine) {
                Optional.ofNullable(((PDAnnotationLine)a).getLine()).filter(p -> ((float[])p).length == 4).ifPresent(f -> a.getCOSObject().setItem(COSName.L, (COSBase)PdfScaler.transformPoints(f, transform)));
            }
            Optional.ofNullable(a.getCOSObject().getDictionaryObject(COSName.CL, COSArray.class)).filter(p -> p.size() % 2 == 0).map(COSArray::toFloatArray).ifPresent(f -> a.getCOSObject().setItem(COSName.CL, (COSBase)PdfScaler.transformPoints(f, transform)));
            Optional.ofNullable(a.getCOSObject().getDictionaryObject(COSName.VERTICES, COSArray.class)).filter(p -> p.size() % 2 == 0).map(COSArray::toFloatArray).ifPresent(f -> a.getCOSObject().setItem(COSName.VERTICES, (COSBase)PdfScaler.transformPoints(f, transform)));
            processedAnnots.add(a.getCOSObject());
        });
    }

    private static COSArray transformPoints(float[] points, Matrix transform) {
        COSArray newPoints = new COSArray();
        for (int i = 0; i < points.length; ++i) {
            Point2D.Float newPoint = transform.transformPoint(points[i], points[++i]);
            newPoints.add((COSBase)new COSFloat(newPoint.x));
            newPoints.add((COSBase)new COSFloat(newPoint.y));
        }
        return newPoints;
    }

    public static void margin(PDDocument doc, Iterable<PDPage> pages, Margins margins) throws TaskIOException {
        if (Objects.nonNull(margins)) {
            HashSet<COSDictionary> processedAnnots = new HashSet<COSDictionary>();
            for (PDPage page : pages) {
                try {
                    PDPageContentStream contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.PREPEND, true);
                    Throwable throwable = null;
                    try {
                        page.setCropBox(PdfScaler.addMargins(page.getCropBox().rotate(page.getRotation()), margins).rotate(-page.getRotation()));
                        page.setMediaBox(PdfScaler.addMargins(page.getMediaBox().rotate(page.getRotation()), margins).rotate(-page.getRotation()));
                        Optional.ofNullable(page.getBleedBoxRaw()).ifPresent(r -> page.setBleedBox(PdfScaler.addMargins(r.rotate(page.getRotation()), margins).rotate(-page.getRotation())));
                        Optional.ofNullable(page.getTrimBoxRaw()).ifPresent(r -> page.setTrimBox(PdfScaler.addMargins(r.rotate(page.getRotation()), margins).rotate(-page.getRotation())));
                        Optional.ofNullable(page.getArtBoxRaw()).ifPresent(r -> page.setArtBox(PdfScaler.addMargins(r.rotate(page.getRotation()), margins).rotate(-page.getRotation())));
                        Matrix matrix = new Matrix(AffineTransform.getTranslateInstance(Margins.inchesToPoints((double)margins.left), Margins.inchesToPoints((double)margins.bottom)));
                        contentStream.transform(matrix);
                        PdfScaler.transformAnnotations(page, matrix, processedAnnots);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (contentStream == null) continue;
                        if (throwable != null) {
                            try {
                                contentStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        contentStream.close();
                    }
                }
                catch (IOException e) {
                    throw new TaskIOException("An error occurred adding margins to the page.", (Throwable)e);
                }
            }
        }
    }

    private static PDRectangle addMargins(PDRectangle rect, Margins margins) {
        return new PDRectangle(rect.getLowerLeftX(), rect.getLowerLeftY(), (float)((double)rect.getWidth() + Margins.inchesToPoints((double)margins.left) + Margins.inchesToPoints((double)margins.right)), (float)((double)rect.getHeight() + Margins.inchesToPoints((double)margins.top) + Margins.inchesToPoints((double)margins.bottom)));
    }

    private Matrix getMatrix(double scale, PDRectangle crop, PDRectangle toScale) {
        if (ScaleType.CONTENT == this.type) {
            AffineTransform transform = AffineTransform.getTranslateInstance(((double)crop.getWidth() - (double)toScale.getWidth() * scale) / 2.0, ((double)crop.getHeight() - (double)toScale.getHeight() * scale) / 2.0);
            transform.scale(scale, scale);
            return new Matrix(transform);
        }
        return new Matrix(AffineTransform.getScaleInstance(scale, scale));
    }

    private void scaleContentBoxes(double scale, PDPage page) {
        PDRectangle cropBox = page.getCropBox();
        if (scale > 1.0) {
            page.setBleedBox(cropBox);
            page.setTrimBox(cropBox);
        } else {
            page.setBleedBox(new PDRectangle(page.getBleedBox().transform(this.getMatrix(scale, page.getCropBox(), page.getBleedBox())).getBounds2D()));
            page.setTrimBox(new PDRectangle(page.getTrimBox().transform(this.getMatrix(scale, page.getCropBox(), page.getTrimBox())).getBounds2D()));
        }
        Rectangle2D newArt = page.getArtBox().transform(this.getMatrix(scale, page.getCropBox(), page.getArtBox())).getBounds2D();
        if (newArt.getX() < (double)cropBox.getLowerLeftX() || newArt.getY() < (double)cropBox.getLowerLeftX()) {
            page.setArtBox(page.getCropBox());
        } else {
            page.setArtBox(new PDRectangle(newArt));
        }
    }

    private void scalePageBoxes(double scale, PDPage page) {
        page.setArtBox(new PDRectangle(page.getArtBox().transform(this.getMatrix(scale, page.getCropBox(), page.getArtBox())).getBounds2D()));
        page.setBleedBox(new PDRectangle(page.getBleedBox().transform(this.getMatrix(scale, page.getCropBox(), page.getBleedBox())).getBounds2D()));
        page.setTrimBox(new PDRectangle(page.getTrimBox().transform(this.getMatrix(scale, page.getCropBox(), page.getTrimBox())).getBounds2D()));
        page.setCropBox(new PDRectangle(page.getCropBox().transform(this.getMatrix(scale, page.getCropBox(), page.getCropBox())).getBounds2D()));
        page.setMediaBox(new PDRectangle(page.getMediaBox().transform(this.getMatrix(scale, page.getMediaBox(), page.getMediaBox())).getBounds2D()));
    }

    private double getScalingFactorMatchWidth(PDRectangle targetBox, PDRectangle pageBox) {
        if (this.isLandscape(targetBox) == this.isLandscape(pageBox)) {
            return targetBox.getWidth() / pageBox.getWidth();
        }
        return targetBox.getHeight() / pageBox.getWidth();
    }

    private double getScalingFactorMatchWidthOrHeight(PDRectangle targetBox, PDRectangle pageBox) {
        PDRectangle normalizedOrientationTargetBox = targetBox;
        if (this.isLandscape(targetBox) != this.isLandscape(pageBox)) {
            normalizedOrientationTargetBox = targetBox.rotate();
        }
        float widthFactor = normalizedOrientationTargetBox.getWidth() / pageBox.getWidth();
        float heightFactor = normalizedOrientationTargetBox.getHeight() / pageBox.getHeight();
        float factor = Math.min(widthFactor, heightFactor);
        return factor;
    }

    private boolean isLandscape(PDRectangle box) {
        return box.getWidth() > box.getHeight();
    }
}

