/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.views;

import gnu.trove.set.hash.TIntHashSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.data.LatLon;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

public class MapTextLayer
extends OsmandMapLayer {
    private Map<OsmandMapLayer, List<?>> textObjects = new LinkedHashMap();
    public static final int TEXT_WRAP = 15;
    public static final int TEXT_LINES = 3;
    private Stroke paintTextIcon;
    private Graphics2D gpaintTextIcon;
    private OsmBitmapPanel view;
    private boolean alwaysVisible;
    private float mTextSize;

    public void putData(OsmandMapLayer ml, List<?> objects) {
        if (objects == null || objects.isEmpty()) {
            this.textObjects.remove(ml);
        } else if (ml instanceof MapTextProvider) {
            this.textObjects.put(ml, objects);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public boolean isAlwaysVisible() {
        return this.alwaysVisible;
    }

    public void setAlwaysVisible(boolean alwaysVisible) {
        this.alwaysVisible = alwaysVisible;
    }

    public boolean isVisible() {
        return this.view.getSettings().SHOW_POI_LABEL.get() != false || this.isAlwaysVisible();
    }

    @Override
    public void onPrepareBufferImage(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
        if (!this.isVisible()) {
            return;
        }
        TIntHashSet set = new TIntHashSet();
        for (OsmandMapLayer l : this.textObjects.keySet()) {
            if (!this.view.isLayerVisible(l)) continue;
            for (Object o : this.textObjects.get(l)) {
                int lines;
                LatLon location = ((MapTextProvider)((Object)l)).getTextLocation(o);
                int x = (int)tileBox.getPixXFromLatLon(location.getLatitude(), location.getLongitude());
                int y = (int)tileBox.getPixYFromLatLon(location.getLatitude(), location.getLongitude());
                int tx = tileBox.getPixXFromLonNoRot(location.getLongitude());
                int ty = tileBox.getPixYFromLatNoRot(location.getLatitude());
                String name = ((MapTextProvider)((Object)l)).getText(o);
                if (name == null || name.length() <= 0) continue;
                for (lines = 0; !(lines >= 3 || set.contains(this.division(tx, ty, 0, lines)) || set.contains(this.division(tx, ty, -1, lines)) || set.contains(this.division(tx, ty, 1, lines))); ++lines) {
                }
                if (lines == 0) continue;
                int r = ((MapTextProvider)((Object)l)).getTextShift(o, tileBox);
                this.drawWrappedText(canvas, name, this.mTextSize, x, (float)(y + r + 2) + this.mTextSize / 2.0f, lines);
                while (lines > 0) {
                    set.add(this.division(tx, ty, 1, lines - 1));
                    set.add(this.division(tx, ty, -1, lines - 1));
                    set.add(this.division(tx, ty, 0, lines - 1));
                    --lines;
                }
            }
        }
    }

    private int division(int x, int y, int sx, int sy) {
        return (x + 10000 >> 4) + sx << 16 | (y + 10000 >> 4) + sy;
    }

    private void drawWrappedText(Graphics2D cv, String text, float textSize, float x, float y, int lines) {
        if (text.length() > 15) {
            int start = 0;
            int end = text.length();
            int lastSpace = -1;
            int pos = 0;
            int limit = 0;
            for (int line = 0; pos < end && line < lines; ++line) {
                lastSpace = -1;
                limit += 15;
                while (pos < limit && pos < end) {
                    if (!Character.isLetterOrDigit(text.charAt(pos))) {
                        lastSpace = pos;
                    }
                    ++pos;
                }
                if (lastSpace == -1 || pos == end) {
                    this.drawShadowText(cv, text.substring(start, pos), x, y + (float)line * (textSize + 2.0f));
                    start = pos;
                    continue;
                }
                String subtext = text.substring(start, lastSpace);
                if (line + 1 == lines) {
                    subtext = subtext + "..";
                }
                this.drawShadowText(cv, subtext, x, y + (float)line * (textSize + 2.0f));
                start = lastSpace + 1;
                limit += start - pos - 1;
            }
        } else {
            this.drawShadowText(cv, text, x, y);
        }
    }

    private void drawShadowText(Graphics2D cv, String text, float centerX, float centerY) {
        this.gpaintTextIcon = this.view.createGraphics(cv);
        Color c = this.gpaintTextIcon.getColor();
        this.gpaintTextIcon.setStroke(new BasicStroke(2.0f));
        this.gpaintTextIcon.setColor(Color.white);
        this.gpaintTextIcon.drawString(text, centerX, centerY);
        this.gpaintTextIcon.setStroke(new BasicStroke(2.0f));
        this.gpaintTextIcon.setColor(c);
        this.gpaintTextIcon.drawString(text, centerX, centerY);
        this.gpaintTextIcon.dispose();
    }

    @Override
    public void initLayer(OsmBitmapPanel v) {
        this.view = v;
        this.mTextSize = 13.0f * v.getDensity();
        TreeMap textObjectsLoc = new TreeMap(new Comparator<OsmandMapLayer>(){

            @Override
            public int compare(OsmandMapLayer lhs, OsmandMapLayer rhs) {
                if (MapTextLayer.this.view != null) {
                    float z1 = MapTextLayer.this.view.getZorder(lhs);
                    float z2 = MapTextLayer.this.view.getZorder(rhs);
                    return Float.compare(z1, z2);
                }
                return 0;
            }
        });
        textObjectsLoc.putAll(this.textObjects);
        this.textObjects = textObjectsLoc;
    }

    @Override
    public void onDraw(Graphics2D canvas, RotatedTileBox tileBox, OsmandMapLayer.DrawSettings settings) {
    }

    @Override
    public void destroyLayer() {
    }

    @Override
    public boolean drawInScreenPixels() {
        return true;
    }

    public static interface MapTextProvider<T> {
        public LatLon getTextLocation(T var1);

        public int getTextShift(T var1, RotatedTileBox var2);

        public String getText(T var1);
    }
}

