/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.Types;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.tools.Diagnostic;
import org.netbeans.api.java.source.CodeStyle;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.java.editor.base.javadoc.JavadocImports;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.netbeans.spi.java.hints.JavaFix;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OrganizeImports {
    private static final String ERROR_CODE = "compiler.err.expected";

    public static ErrorDescription checkImports(final HintContext context) {
        List diffs;
        Source source = context.getInfo().getSnapshot().getSource();
        ModificationResult result = null;
        try {
            result = ModificationResult.runModificationTask(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                    copy.toPhase(JavaSource.Phase.RESOLVED);
                    OrganizeImports.doOrganizeImports(copy, context.isBulkMode());
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        List list = diffs = result != null ? result.getDifferences(source.getFileObject()) : null;
        if (diffs != null && !diffs.isEmpty()) {
            Fix fix = new OrganizeImportsFix(context.getInfo(), context.getPath(), context.isBulkMode()).toEditorFix();
            SourcePositions sp = context.getInfo().getTrees().getSourcePositions();
            int offset = ((ModificationResult.Difference)diffs.get(0)).getStartPosition().getOffset();
            CompilationUnitTree cu = context.getInfo().getCompilationUnit();
            for (ImportTree importTree : cu.getImports()) {
                if (sp.getEndPosition(cu, importTree) < (long)offset) continue;
                return ErrorDescriptionFactory.forTree((HintContext)context, (Tree)importTree, (String)NbBundle.getMessage(OrganizeImports.class, (String)"MSG_OragnizeImports"), (Fix[])new Fix[]{fix});
            }
            return ErrorDescriptionFactory.forTree((HintContext)context, (Tree)context.getInfo().getCompilationUnit().getImports().get(0), (String)NbBundle.getMessage(OrganizeImports.class, (String)"MSG_OragnizeImports"), (Fix[])new Fix[]{fix});
        }
        return null;
    }

    private static void doOrganizeImports(WorkingCopy copy, boolean isBulkMode) throws IllegalStateException {
        OrganizeImports.doOrganizeImports(copy, null, isBulkMode);
    }

    public static void doOrganizeImports(WorkingCopy copy, Set<Element> addImports, boolean isBulkMode) throws IllegalStateException {
        List diags;
        CompilationUnitTree cu = copy.getCompilationUnit();
        List<? extends ImportTree> imports = cu.getImports();
        if (imports.isEmpty()) {
            if (addImports == null) {
                return;
            }
        } else if (addImports == null && !(diags = copy.getDiagnostics()).isEmpty()) {
            SourcePositions sp = copy.getTrees().getSourcePositions();
            long startPos = sp.getStartPosition(cu, imports.get(0));
            long endPos = sp.getEndPosition(cu, imports.get(imports.size() - 1));
            for (Diagnostic d : diags) {
                if (startPos > d.getPosition() || d.getPosition() > endPos || !ERROR_CODE.contentEquals(d.getCode())) continue;
                return;
            }
        }
        final CodeStyle cs = CodeStyle.getDefault((FileObject)copy.getFileObject());
        HashSet<Element> starImports = new HashSet<Element>();
        HashSet<Element> staticStarImports = new HashSet<Element>();
        Set<Element> toImport = OrganizeImports.getUsedElements((CompilationInfo)copy, cu, starImports, staticStarImports);
        LinkedList<? extends ImportTree> imps = new LinkedList<ImportTree>();
        TreeMaker maker = copy.getTreeMaker();
        if (addImports != null) {
            toImport.addAll(addImports);
            imps.addAll(cu.getImports());
        } else if (!toImport.isEmpty() || isBulkMode) {
            HashSet<Element> starImportScopes = new HashSet<Element>();
            Trees trees = copy.getTrees();
            for (ImportTree importTree : cu.getImports()) {
                Tree qualIdent = importTree.getQualifiedIdentifier();
                if (qualIdent.getKind() != Tree.Kind.MEMBER_SELECT || !"*".contentEquals(((MemberSelectTree)qualIdent).getIdentifier())) continue;
                ImportTree imp = null;
                Element importedScope = trees.getElement(TreePath.getPath(cu, (Tree)((MemberSelectTree)qualIdent).getExpression()));
                if (importTree.isStatic()) {
                    if (staticStarImports != null && staticStarImports.contains(importedScope) && !starImportScopes.contains(importedScope)) {
                        imp = maker.Import(qualIdent, true);
                    }
                } else if (starImports != null && starImports.contains(importedScope) && !starImportScopes.contains(importedScope)) {
                    imp = maker.Import(qualIdent, false);
                }
                if (imp == null) continue;
                starImportScopes.add(importedScope);
                imps.add(imp);
            }
        } else {
            return;
        }
        if (!imps.isEmpty()) {
            Collections.sort(imps, new Comparator<ImportTree>(){
                private CodeStyle.ImportGroups groups;
                {
                    this.groups = cs.getImportGroups();
                }

                @Override
                public int compare(ImportTree o1, ImportTree o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    String s1 = o1.getQualifiedIdentifier().toString();
                    String s2 = o2.getQualifiedIdentifier().toString();
                    int bal = this.groups.getGroupId(s1, o1.isStatic()) - this.groups.getGroupId(s2, o2.isStatic());
                    return bal == 0 ? s1.compareTo(s2) : bal;
                }
            });
        }
        CompilationUnitTree cut = maker.CompilationUnit(cu.getPackageAnnotations(), cu.getPackageName(), imps, cu.getTypeDecls(), cu.getSourceFile());
        ((JCTree.JCCompilationUnit)cut).packge = ((JCTree.JCCompilationUnit)cu).packge;
        if (starImports != null || staticStarImports != null) {
            ((JCTree.JCCompilationUnit)cut).starImportScope = ((JCTree.JCCompilationUnit)cu).starImportScope;
        }
        CompilationUnitTree ncu = toImport.isEmpty() ? cut : GeneratorUtilities.get((WorkingCopy)copy).addImports(cut, toImport);
        copy.rewrite((Tree)cu, (Tree)ncu);
    }

    private static Set<Element> getUsedElements(final CompilationInfo info, final CompilationUnitTree cut, final Set<Element> starImports, final Set<Element> staticStarImports) {
        final HashSet<Element> ret = new HashSet<Element>();
        final Trees trees = info.getTrees();
        Types types = info.getTypes();
        new ErrorAwareTreePathScanner<Void, Void>(){

            public Void visitIdentifier(IdentifierTree node, Void p) {
                this.addElement(trees.getElement(this.getCurrentPath()));
                return null;
            }

            public Void visitClass(ClassTree node, Void p) {
                for (Element element : JavadocImports.computeReferencedElements((CompilationInfo)info, (TreePath)this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitClass(node, (Object)p);
            }

            public Void visitMethod(MethodTree node, Void p) {
                for (Element element : JavadocImports.computeReferencedElements((CompilationInfo)info, (TreePath)this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitMethod(node, (Object)p);
            }

            public Void visitVariable(VariableTree node, Void p) {
                for (Element element : JavadocImports.computeReferencedElements((CompilationInfo)info, (TreePath)this.getCurrentPath())) {
                    this.addElement(element);
                }
                return (Void)super.visitVariable(node, (Object)p);
            }

            public Void visitCompilationUnit(CompilationUnitTree node, Void p) {
                this.scan(node.getPackageAnnotations(), p);
                return (Void)this.scan(node.getTypeDecls(), p);
            }

            private void addElement(Element element) {
                if (element != null) {
                    switch (element.getKind()) {
                        case ENUM_CONSTANT: 
                        case FIELD: 
                        case METHOD: {
                            Element glob;
                            if (!element.getModifiers().contains((Object)Modifier.STATIC) || (glob = this.global(element, staticStarImports)) == null) break;
                            ret.add(glob);
                            break;
                        }
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            Element glob = this.global(element, starImports);
                            if (glob == null) break;
                            ret.add(glob);
                        }
                    }
                }
            }

            private Element global(Element element, Set<Element> stars) {
                for (Symbol sym : ((JCTree.JCCompilationUnit)cut).namedImportScope.getSymbolsByName((Name)element.getSimpleName())) {
                    if (element != sym && (element.asType().getKind() != TypeKind.ERROR || element.getKind() != sym.getKind())) continue;
                    return sym;
                }
                for (Symbol sym : ((JCTree.JCCompilationUnit)cut).packge.members().getSymbolsByName((Name)element.getSimpleName())) {
                    if (element != sym && (element.asType().getKind() != TypeKind.ERROR || element.getKind() != sym.getKind())) continue;
                    return sym;
                }
                for (Symbol sym : ((JCTree.JCCompilationUnit)cut).starImportScope.getSymbolsByName((Name)element.getSimpleName())) {
                    if (element != sym && (element.asType().getKind() != TypeKind.ERROR || element.getKind() != sym.getKind())) continue;
                    if (stars != null) {
                        stars.add(sym.owner);
                    }
                    return sym;
                }
                return null;
            }
        }.scan((Tree)cut, null);
        return ret;
    }

    public static class OrganizeImportsAction
    extends BaseAction {
        public void actionPerformed(ActionEvent evt, JTextComponent component) {
            if (component == null || !component.isEditable() || !component.isEnabled()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            BaseDocument doc = (BaseDocument)component.getDocument();
            final Source source = Source.create((Document)doc);
            if (source != null) {
                AtomicBoolean cancel = new AtomicBoolean();
                ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ModificationResult.runModificationTask(Collections.singleton(source), (UserTask)new UserTask(){

                                public void run(ResultIterator resultIterator) throws Exception {
                                    WorkingCopy copy = WorkingCopy.get((Parser.Result)resultIterator.getParserResult());
                                    copy.toPhase(JavaSource.Phase.RESOLVED);
                                    OrganizeImports.doOrganizeImports(copy, false);
                                }
                            }).commit();
                        }
                        catch (Exception ex) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                }, (String)NbBundle.getMessage(OrganizeImports.class, (String)"MSG_OragnizeImports"), (AtomicBoolean)cancel, (boolean)false);
            }
        }
    }

    private static final class OrganizeImportsFix
    extends JavaFix {
        private final boolean isBulkMode;

        public OrganizeImportsFix(CompilationInfo info, TreePath tp, boolean isBulkMode) {
            super(info, tp);
            this.isBulkMode = isBulkMode;
        }

        public String getText() {
            return NbBundle.getMessage(OrganizeImports.class, (String)"FIX_OrganizeImports");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            OrganizeImports.doOrganizeImports(ctx.getWorkingCopy(), this.isBulkMode);
        }
    }
}

