/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.jshell.agent;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.instrument.ClassDefinition;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jdk.jshell.execution.RemoteExecutionControl;
import jdk.jshell.execution.Util;
import jdk.jshell.spi.ExecutionControl;
import org.netbeans.lib.jshell.agent.NbJShellAgent;
import org.netbeans.lib.jshell.agent.NbRemoteLoader;
import org.netbeans.lib.jshell.agent.RemoteClassLoader;

public class AgentWorker
extends RemoteExecutionControl
implements Executor,
Runnable {
    private static final Logger LOG = Logger.getLogger("org.netbeans.lib.jshell.agent.AgentWorker");
    public static final String PROPERTY_EXECUTOR = "org.netbeans.lib.jshell.agent.AgentWorker.executor";
    public static volatile ClassLoader referenceClassLoader;
    private final NbJShellAgent agent;
    private final Socket socket;
    private final int socketPort;
    private RemoteClassLoader loader;
    private ClassLoader lastClassLoader;
    private Callable<ClassLoader> loaderProvider;
    private Executor userExecutor;
    private static final Map<Integer, Thread> userCodeExecutingThreads;
    public static final int CMD_VM_INFO = 100;
    public static final int CMD_REDEFINE = 101;
    public static final int CMD_STOP = 102;
    public static final int CMD_CLASSID = 103;
    public static final int CMD_TYPE_ID = 101;
    private Pattern EXCLUDE_CLASSPATH_ITEMS = Pattern.compile("lib/tools.jar$|modules/ext/nb-custom-jshell-probe.jar$");
    private ClassLoader contextLoader;
    private AtomicBoolean killed = new AtomicBoolean();
    private List<URL> additionalClasspath = new ArrayList<URL>();

    private AgentWorker() {
        this.agent = null;
        this.socket = null;
        this.socketPort = -1;
        this.userExecutor = this.findExecutor();
        this.loaderProvider = new Callable<ClassLoader>(){

            @Override
            public ClassLoader call() {
                return AgentWorker.this.loader;
            }
        };
        this.setup();
    }

    public AgentWorker(NbJShellAgent agent, Socket controlSocket) {
        this.agent = agent;
        this.socket = controlSocket;
        this.socketPort = controlSocket.getLocalPort();
        this.setup();
    }

    private void setup() {
        this.loader = new NbRemoteLoader(ClassLoader.getSystemClassLoader(), null, new URL[0]);
        if (this.agent != null) {
            if (this.agent.getField() != null || this.agent.getMethod() != null) {
                this.loaderProvider = new LoaderEvaluator();
            } else if (this.agent.getClassName() != null) {
                this.loaderProvider = new LoaderAccessor(this.loader);
            }
        }
        if (this.loaderProvider == null) {
            this.loaderProvider = new Callable<ClassLoader>(){

                @Override
                public ClassLoader call() {
                    return AgentWorker.this.loader;
                }
            };
        }
        this.userExecutor = this.findExecutor();
    }

    private Executor findExecutor() {
        Object o = System.getProperties().get(PROPERTY_EXECUTOR);
        if (o instanceof Executor) {
            this.userExecutor = (Executor)o;
            return this.userExecutor;
        }
        if (o instanceof String) {
            try {
                Class<?> executorClazz = Class.forName((String)o);
                return (Executor)executorClazz.newInstance();
            }
            catch (ClassNotFoundException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (InstantiationException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                LOG.log(Level.SEVERE, null, ex);
            }
        }
        return this;
    }

    private void installNewClassLoader(ClassLoader delegate) {
        this.lastClassLoader = delegate;
        this.loader = new NbRemoteLoader(delegate, (ClassLoader)this.loader, this.additionalClasspath.toArray(new URL[this.additionalClasspath.size()]));
    }

    @Override
    public void execute(Runnable command) {
        command.run();
    }

    protected NbRemoteLoader prepareClassLoader() {
        try {
            ClassLoader current = this.loaderProvider.call();
            if (current != this.lastClassLoader && current != this.loader) {
                this.installNewClassLoader(current);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (NbRemoteLoader)this.loader;
    }

    public static void main(String[] args) throws Exception {
        String loopBack = null;
        LOG.log(Level.INFO, "Running main, port = ", args[0]);
        Socket socket = new Socket(loopBack, Integer.parseInt(args[0]));
        try {
            AgentWorker worker = new AgentWorker();
            LOG.log(Level.INFO, "Worker created", args[0]);
            InputStream inStream = socket.getInputStream();
            OutputStream outStream = socket.getOutputStream();
            HashMap<String, Consumer<OutputStream>> chans = new HashMap<String, Consumer<OutputStream>>();
            chans.put("out", st -> System.setOut(new PrintStream((OutputStream)st, true)));
            chans.put("err", st -> System.setErr(new PrintStream((OutputStream)st, true)));
            Util.forwardExecutionControlAndIO(worker, inStream, outStream, chans, Collections.emptyMap());
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    @Override
    public Object extensionCommand(String command, Object arg) throws ExecutionControl.RunException, ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        try {
            switch (command) {
                case "nb_vmInfo": {
                    return this.returnVMInfo(null);
                }
                case "nb_stop": {
                    if (!(arg instanceof Integer)) {
                        throw new InternalError("Unexpected agent ID: " + arg);
                    }
                    this.performStop((Integer)arg);
                    return 1;
                }
            }
            throw new ExecutionControl.NotImplementedException("Command " + command + " not implemented");
        }
        catch (Exception ex) {
            throw new ExecutionControl.InternalException("Internal error: " + ex.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream osm = null;
        InputStream ism = null;
        try {
            LOG.fine("Opening output stream to master");
            osm = this.socket.getOutputStream();
            ism = this.socket.getInputStream();
            LOG.fine("Opening input stream from master");
            HashMap<String, Consumer<OutputStream>> chans = new HashMap<String, Consumer<OutputStream>>();
            Util.forwardExecutionControlAndIO(this, ism, osm, chans, Collections.emptyMap());
        }
        catch (EOFException ex) {
            LOG.log(Level.FINE, "EOF", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.FINE, "I/O", ex);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (osm != null) {
                try {
                    osm.close();
                }
                catch (IOException ex) {}
            }
            if (ism != null) {
                try {
                    ism.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private Object returnVMInfo(ObjectOutput o) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties props = System.getProperties();
        for (String s : props.stringPropertyNames()) {
            if (!s.startsWith("java")) continue;
            result.put(s, props.getProperty(s));
        }
        LOG.log(Level.FINE, "Sending properties: " + props);
        StringBuilder cp = new StringBuilder();
        for (URL u : this.loader.getURLs()) {
            try {
                File f = new File(u.toURI());
                String s = f.getPath();
                if (this.EXCLUDE_CLASSPATH_ITEMS.matcher(s).find()) continue;
                if (cp.length() > 0) {
                    cp.append(":");
                }
                cp.append(f.getPath());
            }
            catch (URISyntaxException ex) {
                cp.append(u.toExternalForm());
            }
        }
        for (String s : props.getProperty("java.class.path").split(File.pathSeparator)) {
            if (s.isEmpty() || this.EXCLUDE_CLASSPATH_ITEMS.matcher(s).find()) continue;
            if (cp.length() > 0) {
                cp.append(":");
            }
            cp.append(s);
        }
        LOG.log(Level.FINE, "Classloader path: " + cp);
        result.put("nb.class.path", cp.toString());
        return result;
    }

    @Override
    protected void clientCodeEnter() {
        LOG.log(Level.FINER, "Entering client code");
        this.contextLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.loader);
        super.clientCodeEnter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void clientCodeLeave() throws ExecutionControl.InternalException {
        super.clientCodeLeave();
        LOG.log(Level.FINER, "Exiting client code");
        Thread.currentThread().setContextClassLoader(this.contextLoader);
        Map<Integer, Thread> map = userCodeExecutingThreads;
        synchronized (map) {
            Thread t = userCodeExecutingThreads.get(this.socketPort);
            if (t == Thread.currentThread()) {
                this.killed.set(userCodeExecutingThreads.remove(this.socketPort) != null);
            }
            LOG.log(Level.FINER, "User code killed: {0}", this.killed);
        }
    }

    @Override
    public String invoke(final String className, final String methodName) throws ExecutionControl.RunException, ExecutionControl.InternalException, ExecutionControl.EngineTerminationException {
        final Exception[] err = new Exception[1];
        final CountDownLatch execLatch = new CountDownLatch(1);
        final String[] result = new String[1];
        this.userExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = AgentWorker.this.performExecute(className, methodName, execLatch);
                }
                catch (Exception ex) {
                    err[0] = ex;
                }
            }
        });
        try {
            execLatch.await();
        }
        catch (InterruptedException ex) {
            throw new ExecutionControl.StoppedException();
        }
        if (err[0] != null) {
            try {
                throw err[0];
            }
            catch (ExecutionControl.EngineTerminationException | ExecutionControl.InternalException | ExecutionControl.RunException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new ExecutionControl.InternalException("InternalException: " + ex.getClass().getName());
            }
        }
        return result[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String performExecute(String className, String methodName, CountDownLatch latch) throws ExecutionControl.ExecutionControlException {
        this.killed.set(false);
        try {
            Object object = userCodeExecutingThreads;
            synchronized (object) {
                userCodeExecutingThreads.put(this.socketPort, Thread.currentThread());
            }
            object = super.invoke(className, methodName);
            return object;
        }
        catch (ThreadDeath td) {
            LOG.log(Level.FINE, "Received ThreadDeath, killed: {0}", this.killed);
            if (!this.killed.get()) {
                throw td;
            }
        }
        catch (ExecutionControl.ExecutionControlException ex) {
            throw ex;
        }
        catch (Throwable t) {
            this.killed.set(true);
        }
        finally {
            latch.countDown();
        }
        throw new ExecutionControl.StoppedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performStop(int agentId) throws ExecutionControl.ExecutionControlException {
        Thread targetThread;
        if (agentId == -1) {
            agentId = this.socketPort;
        }
        Map<Integer, Thread> map = userCodeExecutingThreads;
        synchronized (map) {
            targetThread = userCodeExecutingThreads.remove(agentId);
            if (targetThread != null) {
                targetThread.stop();
            }
        }
        if (targetThread == null) {
            throw new ExecutionControl.InternalException("Invalid agent ID or not executing user code");
        }
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.prepareClassLoader().findClass(name);
    }

    @Override
    public void addToClasspath(String cp) throws ExecutionControl.EngineTerminationException, ExecutionControl.InternalException {
        for (String cpItem : cp.split(";")) {
            File f = new File(cpItem);
            if (!f.isAbsolute()) {
                throw new ExecutionControl.InternalException("Relative paths unuspported yet");
            }
            try {
                URL url = f.toURI().toURL();
                this.additionalClasspath.add(url);
                if (this.loader == null) continue;
                this.loader.addURL(url);
            }
            catch (MalformedURLException ex) {
                throw new ExecutionControl.InternalException("Invalid file url: " + cpItem);
            }
        }
        this.lastClassLoader = null;
    }

    @Override
    public void load(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException, ExecutionControl.NotImplementedException, ExecutionControl.EngineTerminationException {
        int count = cbcs.length;
        boolean[] status = new boolean[cbcs.length];
        int success = 0;
        NbRemoteLoader ldr = this.prepareClassLoader();
        for (int i = 0; i < count; ++i) {
            String name = cbcs[i].name();
            byte[] byteCode = cbcs[i].bytecodes();
            ldr.delare(name, byteCode);
            try {
                Class.forName(name, false, ldr);
                ++success;
                status[i] = true;
                continue;
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(AgentWorker.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (success < count) {
            throw new ExecutionControl.ClassInstallException("Could not define class", status);
        }
    }

    @Override
    public void redefine(ExecutionControl.ClassBytecodes[] cbcs) throws ExecutionControl.ClassInstallException, ExecutionControl.NotImplementedException, ExecutionControl.EngineTerminationException {
        int count = cbcs.length;
        boolean[] status = new boolean[cbcs.length];
        int success = 0;
        NbRemoteLoader ldr = this.prepareClassLoader();
        for (int i = 0; i < count; ++i) {
            String name = cbcs[i].name();
            byte[] replaceBytecode = cbcs[i].bytecodes();
            Long id = ldr.getClassId(name);
            if (id != null) {
                Class defined = ldr.getClassOfId(id);
                try {
                    this.agent.getInstrumentation().redefineClasses(new ClassDefinition(defined, replaceBytecode));
                    status[i] = true;
                    ++success;
                }
                catch (ClassNotFoundException | UnmodifiableClassException ex) {
                    Logger.getLogger(AgentWorker.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (success >= count) continue;
            throw new ExecutionControl.ClassInstallException("Could not redefine classes", status);
        }
    }

    private void performClassId(ObjectInputStream in, ObjectOutputStream out) throws IOException {
        String className = in.readUTF();
        Long id = ((NbRemoteLoader)this.loader).getClassId(className);
        out.writeInt(100);
        if (id == null) {
            out.writeLong(-1L);
        } else {
            out.writeLong(id);
        }
        out.flush();
    }

    static {
        userCodeExecutingThreads = new HashMap<Integer, Thread>();
    }

    private class LoaderEvaluator
    implements Callable<ClassLoader> {
        private Class clazz;
        private Method method;
        private Field field;

        private LoaderEvaluator() {
        }

        @Override
        public ClassLoader call() throws Exception {
            if (this.clazz == null) {
                try {
                    this.clazz = Class.forName(AgentWorker.this.agent.getClassName(), false, AgentWorker.this.loader);
                }
                catch (ClassNotFoundException ex) {
                    return AgentWorker.this.loader;
                }
                String m = AgentWorker.this.agent.getMethod();
                String f = AgentWorker.this.agent.getField();
                if (m != null) {
                    this.method = this.clazz.getDeclaredMethod(m, new Class[0]);
                    if (!this.method.getReturnType().isAssignableFrom(ClassLoader.class) || (this.method.getModifiers() & 8) == 0) {
                        throw new IllegalStateException("Loader access method must be static and return ClassLoader");
                    }
                    this.method.setAccessible(true);
                } else if (f != null) {
                    this.field = this.clazz.getDeclaredField(f);
                    this.field.setAccessible(true);
                    if (!this.field.getType().isAssignableFrom(ClassLoader.class) || (this.field.getModifiers() & 8) == 0) {
                        throw new IllegalStateException("Loader access field must be static and assignable to ClassLoader");
                    }
                }
            }
            if (this.method != null) {
                return (ClassLoader)this.method.invoke(null, new Object[0]);
            }
            if (this.field != null) {
                return (ClassLoader)this.field.get(null);
            }
            return AgentWorker.this.loader;
        }
    }

    private static class LoaderAccessor
    implements Callable<ClassLoader> {
        private final ClassLoader defaultLoader;

        public LoaderAccessor(ClassLoader defaultLoader) {
            this.defaultLoader = defaultLoader;
        }

        @Override
        public ClassLoader call() throws Exception {
            if (referenceClassLoader != null) {
                return referenceClassLoader;
            }
            return this.defaultLoader;
        }
    }
}

