/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation;
import org.netbeans.spi.java.queries.AccessibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public class AccessibilityQuery {
    private static final Lookup.Result<? extends AccessibilityQueryImplementation> implementations = Lookup.getDefault().lookupResult(AccessibilityQueryImplementation.class);
    private static final Lookup.Result<? extends AccessibilityQueryImplementation2> implementations2 = Lookup.getDefault().lookupResult(AccessibilityQueryImplementation2.class);

    private AccessibilityQuery() {
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    @CheckForNull
    public static Boolean isPubliclyAccessible(@NonNull FileObject pkg) {
        if (!pkg.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + pkg);
        }
        for (Object aqi : implementations2.allInstances()) {
            AccessibilityQueryImplementation2.Result res = aqi.isPubliclyAccessible(pkg);
            if (res == null) continue;
            return res.getAccessibility().toBoolean();
        }
        for (Object aqi : implementations.allInstances()) {
            Boolean b = aqi.isPubliclyAccessible(pkg);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @NonNull
    public static Result isPubliclyAccessible2(@NonNull FileObject pkg) {
        Parameters.notNull((CharSequence)"pkg", (Object)pkg);
        if (!pkg.isFolder()) {
            throw new IllegalArgumentException("Not a folder: " + pkg);
        }
        for (AccessibilityQueryImplementation2 aqi : implementations2.allInstances()) {
            AccessibilityQueryImplementation2.Result res = aqi.isPubliclyAccessible(pkg);
            if (res == null) continue;
            return new Result(res);
        }
        return new Result(new Adapter(pkg));
    }

    private static final class Adapter
    implements AccessibilityQueryImplementation2.Result {
        private final FileObject pkg;

        Adapter(@NonNull FileObject pkg) {
            this.pkg = pkg;
        }

        @Override
        public Accessibility getAccessibility() {
            return Accessibility.fromBoolean(AccessibilityQuery.isPubliclyAccessible(this.pkg));
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
        }
    }

    public static final class Result {
        private final AccessibilityQueryImplementation2.Result delegate;
        private final ChangeSupport listeners;
        private ChangeListener spiListener;

        private Result(@NonNull AccessibilityQueryImplementation2.Result delegate) {
            this.delegate = delegate;
            this.listeners = new ChangeSupport((Object)this);
        }

        @NonNull
        public Accessibility getAccessibility() {
            return this.delegate.getAccessibility();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            Result result = this;
            synchronized (result) {
                if (this.spiListener == null) {
                    this.spiListener = e -> this.listeners.fireChange();
                    this.delegate.addChangeListener(WeakListeners.change((ChangeListener)this.spiListener, (Object)this.delegate));
                }
            }
            this.listeners.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            Parameters.notNull((CharSequence)"listener", (Object)listener);
            this.listeners.removeChangeListener(listener);
        }
    }

    public static enum Accessibility {
        EXPORTED{

            @Override
            Boolean toBoolean() {
                return Boolean.TRUE;
            }
        }
        ,
        PRIVATE{

            @Override
            Boolean toBoolean() {
                return Boolean.FALSE;
            }
        }
        ,
        UNKNOWN{

            @Override
            Boolean toBoolean() {
                return null;
            }
        };


        abstract Boolean toBoolean();

        @NonNull
        static Accessibility fromBoolean(@NullAllowed Boolean b) {
            return b == Boolean.TRUE ? EXPORTED : (b == Boolean.FALSE ? PRIVATE : UNKNOWN);
        }
    }
}

