/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.ModuleElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.lib.nbjavac.services.CancelAbort;
import org.netbeans.lib.nbjavac.services.CancelService;
import org.netbeans.modules.java.source.indexing.APTUtils;
import org.netbeans.modules.java.source.indexing.CompileWorker;
import org.netbeans.modules.java.source.indexing.DiagnosticListenerImpl;
import org.netbeans.modules.java.source.indexing.JavaCustomIndexer;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.indexing.JavaParsingContext;
import org.netbeans.modules.java.source.indexing.SourcePrefetcher;
import org.netbeans.modules.java.source.indexing.TransactionContext;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.netbeans.modules.java.source.parsing.OutputFileManager;
import org.netbeans.modules.java.source.parsing.PrefetchableJavaFileObject;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ExecutableFilesIndex;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.SuspendStatus;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

final class VanillaCompileWorker
extends CompileWorker {
    VanillaCompileWorker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompileWorker.ParsingOutput compile(CompileWorker.ParsingOutput previous, final org.netbeans.modules.parsing.spi.indexing.Context context, JavaParsingContext javaContext, Collection<? extends JavaCustomIndexer.CompileTuple> files) {
        HashMap<JavaFileObject, java.util.List<String>> file2FQNs = previous != null ? previous.file2FQNs : new HashMap<JavaFileObject, java.util.List<String>>();
        HashSet<ElementHandle<TypeElement>> addedTypes = previous != null ? previous.addedTypes : new HashSet<ElementHandle<TypeElement>>();
        HashSet<ElementHandle<ModuleElement>> addedModules = previous != null ? previous.addedModules : new HashSet<ElementHandle<ModuleElement>>();
        HashSet<File> createdFiles = previous != null ? previous.createdFiles : new HashSet<File>();
        HashSet<Indexable> finished = previous != null ? previous.finishedFiles : new HashSet<Indexable>();
        HashSet<ElementHandle<TypeElement>> modifiedTypes = previous != null ? previous.modifiedTypes : new HashSet<ElementHandle<TypeElement>>();
        HashSet<FileObject> aptGenerated = previous != null ? previous.aptGenerated : new HashSet<FileObject>();
        DiagnosticListenerImpl dc = new DiagnosticListenerImpl();
        LinkedList<CompilationUnitTree> trees = new LinkedList<CompilationUnitTree>();
        IdentityHashMap<CompilationUnitTree, JavaCustomIndexer.CompileTuple> units = new IdentityHashMap<CompilationUnitTree, JavaCustomIndexer.CompileTuple>();
        BasicJavacTask jt = null;
        boolean nop = true;
        SuspendStatus suspendStatus = context.getSuspendStatus();
        SourcePrefetcher sourcePrefetcher = SourcePrefetcher.create(files, suspendStatus);
        IdentityHashMap<PrefetchableJavaFileObject, JavaCustomIndexer.CompileTuple> fileObjects = new IdentityHashMap<PrefetchableJavaFileObject, JavaCustomIndexer.CompileTuple>();
        try {
            boolean[] flm = new boolean[]{true};
            while (sourcePrefetcher.hasNext()) {
                JavaCustomIndexer.CompileTuple tuple = sourcePrefetcher.next();
                try {
                    if (tuple == null) continue;
                    nop = false;
                    if (context.isCancelled()) {
                        CompileWorker.ParsingOutput parsingOutput = null;
                        return parsingOutput;
                    }
                    fileObjects.put(tuple.jfo, tuple);
                }
                finally {
                    sourcePrefetcher.remove();
                }
            }
        }
        finally {
            try {
                sourcePrefetcher.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        CompileWorker.ModuleName moduleName = new CompileWorker.ModuleName(javaContext.getModuleName());
        if (nop) {
            return CompileWorker.ParsingOutput.success(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        try {
            jt = JavacParser.createJavacTask(javaContext.getClasspathInfo(), dc, javaContext.getSourceLevel(), javaContext.getProfile(), javaContext.getFQNs(), new CancelService(){

                public boolean isCanceled() {
                    return context.isCancelled() || VanillaCompileWorker.this.isLowMemory(null);
                }
            }, ((JavaCustomIndexer.CompileTuple)fileObjects.values().iterator().next()).aptGenerated ? null : APTUtils.get(context.getRoot()), CompilerOptionsQuery.getOptions((org.openide.filesystems.FileObject)context.getRoot()), fileObjects.keySet());
            for (CompilationUnitTree compilationUnitTree : ((JavacTaskImpl)jt).parse()) {
                trees.add(compilationUnitTree);
                JavaCustomIndexer.CompileTuple tuple = (JavaCustomIndexer.CompileTuple)fileObjects.get(compilationUnitTree.getSourceFile());
                units.put(compilationUnitTree, tuple);
                this.computeFQNs(file2FQNs, compilationUnitTree, tuple);
            }
            Log.instance((Context)jt.getContext()).nerrors = 0;
        }
        catch (CancelAbort ca) {
            if (context.isCancelled() && JavaIndex.LOG.isLoggable(Level.FINEST)) {
                JavaIndex.LOG.log(Level.FINEST, "VanillaCompileWorker was canceled in root: " + FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)context.getRoot()), ca);
            }
        }
        catch (Throwable t) {
            if (JavaIndex.LOG.isLoggable(Level.WARNING)) {
                ClassPath classPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                ClassPath classPath2 = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                ClassPath sourcePath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                String message = String.format("VanillaCompileWorker caused an exception\nFile: %s\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", ((JavaCustomIndexer.CompileTuple)fileObjects.values().iterator().next()).indexable.getURL().toString(), FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)context.getRoot()), classPath == null ? null : classPath.toString(), classPath2 == null ? null : classPath2.toString(), sourcePath == null ? null : sourcePath.toString());
                JavaIndex.LOG.log(Level.WARNING, message, t);
            }
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            jt = null;
            units = null;
            dc.cleanDiagnostics();
            this.freeMemory(false);
        }
        if (jt == null || units == null || JavaCustomIndexer.NO_ONE_PASS_COMPILE_WORKER) {
            return CompileWorker.ParsingOutput.failure(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        if (context.isCancelled()) {
            return null;
        }
        if (this.isLowMemory(null)) {
            return CompileWorker.ParsingOutput.lowMemory(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        boolean aptEnabled = true;
        Log log = Log.instance(jt.getContext());
        JavaCompiler compiler = JavaCompiler.instance(jt.getContext());
        try {
            Iterable<? extends Element> types = ((JavacTaskImpl)jt).enter(trees);
            if (context.isCancelled()) {
                return null;
            }
            if (this.isLowMemory(null)) {
                return CompileWorker.ParsingOutput.lowMemory(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
            }
            IdentityHashMap clazz2Tuple = new IdentityHashMap();
            Enter enter = Enter.instance(jt.getContext());
            for (Element element : types) {
                if (!element.getKind().isClass() && !element.getKind().isInterface() && element.getKind() != ElementKind.MODULE) continue;
                Env<AttrContext> typeEnv = enter.getEnv((Symbol.TypeSymbol)element);
                if (typeEnv == null) {
                    JavaIndex.LOG.log(Level.FINE, "No Env for: {0}", ((Symbol.TypeSymbol)element).getQualifiedName());
                    continue;
                }
                clazz2Tuple.put(element, units.get(typeEnv.toplevel));
            }
            ((JavacTaskImpl)jt).analyze(types);
            if (context.isCancelled()) {
                return null;
            }
            if (this.isLowMemory(null)) {
                return CompileWorker.ParsingOutput.lowMemory(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
            }
            for (Map.Entry entry : units.entrySet()) {
                JavaCustomIndexer.CompileTuple active = (JavaCustomIndexer.CompileTuple)entry.getValue();
                if (aptEnabled) {
                    JavaCustomIndexer.addAptGenerated(context, javaContext, active, aptGenerated);
                }
                ArrayList<Symbol.TypeSymbol> arrayList = new ArrayList<Symbol.TypeSymbol>();
                if (((JavaCustomIndexer.CompileTuple)entry.getValue()).jfo.isNameCompatible("package-info", JavaFileObject.Kind.SOURCE)) {
                    Symbol.PackageSymbol packageSymbol;
                    PackageTree pt = ((CompilationUnitTree)entry.getKey()).getPackage();
                    if (pt instanceof JCTree.JCPackageDecl && (packageSymbol = ((JCTree.JCPackageDecl)pt).packge) != null) {
                        arrayList.add(packageSymbol);
                    }
                } else {
                    for (Tree tree : ((CompilationUnitTree)entry.getKey()).getTypeDecls()) {
                        Symbol.TypeSymbol sym;
                        if (!(tree instanceof JCTree)) continue;
                        JCTree jct = (JCTree)tree;
                        if (jct.getTag() == JCTree.Tag.CLASSDEF) {
                            sym = ((JCTree.JCClassDecl)tree).sym;
                            if (sym == null) continue;
                            arrayList.add(sym);
                            continue;
                        }
                        if (jct.getTag() != JCTree.Tag.MODULEDEF || (sym = ((JCTree.JCModuleDecl)tree).sym) == null) continue;
                        arrayList.add(sym);
                    }
                }
                javaContext.getFQNs().set(arrayList, active.indexable.getURL());
                boolean[] main = new boolean[1];
                if (javaContext.getCheckSums().checkAndSet(active.indexable.getURL(), arrayList.stream().filter(e -> e.getKind().isClass() || e.getKind().isInterface()).map(e -> (TypeElement)e).collect(Collectors.toList()), jt.getElements()) || context.isSupplementaryFilesIndexing()) {
                    javaContext.analyze(Collections.singleton(entry.getKey()), (JavacTaskImpl)jt, active, addedTypes, addedModules, main);
                } else {
                    HashSet hashSet = new HashSet();
                    javaContext.analyze(Collections.singleton(entry.getKey()), (JavacTaskImpl)jt, active, hashSet, addedModules, main);
                    addedTypes.addAll(hashSet);
                    modifiedTypes.addAll(hashSet);
                }
                ExecutableFilesIndex.DEFAULT.setMainClass(context.getRoot().toURL(), active.indexable.getURL(), main[0]);
                this.dropMethodsAndErrors(jt.getContext(), (CompilationUnitTree)entry.getKey());
                JavaCustomIndexer.setErrors(context, active, dc);
            }
            if (context.isCancelled()) {
                return null;
            }
            if (this.isLowMemory(null)) {
                return CompileWorker.ParsingOutput.lowMemory(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
            }
            BasicJavacTask jtFin = jt;
            Future<Void> future = FileManagerTransaction.runConcurrent(new FileSystem.AtomicAction((JavacTaskImpl)jtFin, compiler, types, log, clazz2Tuple, createdFiles, moduleName, trees){
                final /* synthetic */ JavacTaskImpl val$jtFin;
                final /* synthetic */ JavaCompiler val$compiler;
                final /* synthetic */ Iterable val$types;
                final /* synthetic */ Log val$log;
                final /* synthetic */ Map val$clazz2Tuple;
                final /* synthetic */ Set val$createdFiles;
                final /* synthetic */ CompileWorker.ModuleName val$moduleName;
                final /* synthetic */ LinkedList val$trees;
                {
                    this.val$jtFin = javacTaskImpl;
                    this.val$compiler = javaCompiler;
                    this.val$types = iterable;
                    this.val$log = log;
                    this.val$clazz2Tuple = map;
                    this.val$createdFiles = set;
                    this.val$moduleName = moduleName;
                    this.val$trees = linkedList;
                }

                public void run() throws IOException {
                    Modules modules = Modules.instance(this.val$jtFin.getContext());
                    this.val$compiler.shouldStopPolicyIfError = CompileStates.CompileState.FLOW;
                    for (Element type : this.val$types) {
                        TreePath tp = Trees.instance(this.val$jtFin).getPath(type);
                        assert (tp != null);
                        this.val$log.nerrors = 0;
                        Iterable<? extends JavaFileObject> generatedFiles = this.val$jtFin.generate(Collections.singletonList(type));
                        JavaCustomIndexer.CompileTuple unit = (JavaCustomIndexer.CompileTuple)this.val$clazz2Tuple.get(type);
                        if (unit != null && unit.virtual) continue;
                        for (JavaFileObject javaFileObject : generatedFiles) {
                            if (!(javaFileObject instanceof FileObjects.FileBase)) continue;
                            this.val$createdFiles.add(((FileObjects.FileBase)javaFileObject).getFile());
                        }
                    }
                    if (!this.val$moduleName.assigned) {
                        Symbol.ModuleSymbol module;
                        Symbol.ModuleSymbol moduleSymbol = module = !this.val$trees.isEmpty() ? ((JCTree.JCCompilationUnit)this.val$trees.getFirst()).modle : null;
                        if (module == null) {
                            module = modules.getDefaultModule();
                        }
                        this.val$moduleName.name = module == null || module.isUnnamed() ? null : module.getQualifiedName().toString();
                        this.val$moduleName.assigned = true;
                    }
                }
            });
            for (Map.Entry entry : units.entrySet()) {
                finished.add(((JavaCustomIndexer.CompileTuple)entry.getValue()).indexable);
            }
            future.get();
            return CompileWorker.ParsingOutput.success(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
        }
        catch (OutputFileManager.InvalidSourcePath isp) {
            if (JavaIndex.LOG.isLoggable(Level.FINEST)) {
                ClassPath bootPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                ClassPath classPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                ClassPath sourcePath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                String string = String.format("VanillaCompileWorker caused an exception\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), sourcePath == null ? null : sourcePath.toString());
                JavaIndex.LOG.log(Level.FINEST, string, isp);
            }
        }
        catch (CancelAbort ca) {
            if (this.isLowMemory(null)) {
                return CompileWorker.ParsingOutput.lowMemory(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
            }
            if (JavaIndex.LOG.isLoggable(Level.FINEST)) {
                JavaIndex.LOG.log(Level.FINEST, "VanillaCompileWorker was canceled in root: " + FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)context.getRoot()), ca);
            }
        }
        catch (Throwable t) {
            HashSet<String> filter;
            Level level;
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            Level level2 = level = t instanceof FatalError ? Level.FINEST : Level.WARNING;
            if (JavaIndex.LOG.isLoggable(level)) {
                ClassPath bootPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.BOOT);
                ClassPath classPath = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
                ClassPath classPath3 = javaContext.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
                String message = String.format("VanillaCompileWorker caused an exception\nRoot: %s\nBootpath: %s\nClasspath: %s\nSourcepath: %s", FileUtil.getFileDisplayName((org.openide.filesystems.FileObject)context.getRoot()), bootPath == null ? null : bootPath.toString(), classPath == null ? null : classPath.toString(), classPath3 == null ? null : classPath3.toString());
                JavaIndex.LOG.log(level, message, t);
            }
            BinaryForSourceQuery.Result res2 = BinaryForSourceQuery.findBinaryRoots((URL)context.getRootURI());
            if (!context.isAllFilesIndexing()) {
                filter = new HashSet<String>();
                for (JavaCustomIndexer.CompileTuple compileTuple : files) {
                    String path = compileTuple.indexable.getRelativePath();
                    filter.add(path.substring(0, path.lastIndexOf(".")));
                }
            } else {
                filter = null;
            }
            try {
                Future<Void> done = FileManagerTransaction.runConcurrent(() -> {
                    File cache = JavaIndex.getClassFolder(context.getRootURI(), false, false);
                    for (URL u : res2.getRoots()) {
                        org.openide.filesystems.FileObject binaryFO = URLMapper.findFileObject((URL)u);
                        if (binaryFO == null) continue;
                        FileManagerTransaction fmtx = TransactionContext.get().get(FileManagerTransaction.class);
                        ArrayList<File> copied = new ArrayList<File>();
                        VanillaCompileWorker.copyRecursively(binaryFO, cache, cache, filter, fmtx, copied);
                        ClassIndexImpl cii = javaContext.getClassIndexImpl();
                        if (cii == null) continue;
                        cii.getBinaryAnalyser().analyse(context, cache, copied);
                    }
                });
                done.get();
            }
            catch (IOException | InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return CompileWorker.ParsingOutput.success(moduleName.name, file2FQNs, addedTypes, addedModules, createdFiles, finished, modifiedTypes, aptGenerated);
    }

    private static void copyRecursively(org.openide.filesystems.FileObject source, File targetRoot, File target, Set<String> filter, FileManagerTransaction fmtx, java.util.List<File> copied) throws IOException {
        if (source.isFolder()) {
            org.openide.filesystems.FileObject[] listed;
            if (target.exists() && !target.isDirectory()) {
                throw new IOException("Cannot create folder: " + target.getAbsolutePath() + ", already exists as a file.");
            }
            for (org.openide.filesystems.FileObject f : listed = source.getChildren()) {
                String name = f.getNameExt();
                if (name.endsWith(".class")) {
                    name = name.substring(0, name.length() - "class".length()) + "sig";
                }
                VanillaCompileWorker.copyRecursively(f, targetRoot, new File(target, name), filter, fmtx, copied);
            }
        } else {
            boolean copy;
            if (target.isDirectory()) {
                throw new IOException("Cannot create file: " + target.getAbsolutePath() + ", already exists as a folder.");
            }
            if (filter != null) {
                int dollar;
                String path = FileObjects.getRelativePath(targetRoot, target);
                int dot = path.lastIndexOf(46);
                if (dot != -1) {
                    path = path.substring(0, dot);
                }
                if ((dollar = path.indexOf(36)) != -1) {
                    path = path.substring(0, dollar);
                }
                copy = filter.contains(path);
            } else {
                copy = true;
            }
            if (copy) {
                VanillaCompileWorker.copyFile(source, fmtx.createFileObject(StandardLocation.CLASS_OUTPUT, target, targetRoot, null, null));
                copied.add(target);
            }
        }
    }

    private static void copyFile(org.openide.filesystems.FileObject updatedFile, JavaFileObject target) throws IOException {
        try (InputStream ins = updatedFile.getInputStream();
             OutputStream out = target.openOutputStream();){
            FileUtil.copy((InputStream)ins, (OutputStream)out);
        }
    }

    private void dropMethodsAndErrors(Context ctx, CompilationUnitTree cut) {
        final Symtab syms = Symtab.instance(ctx);
        final Names names = Names.instance(ctx);
        Types types = Types.instance(ctx);
        final TreeMaker make = TreeMaker.instance(ctx);
        new TreePathScanner<Void, Void>(){
            private Set<Type> seen = Collections.newSetFromMap(new IdentityHashMap());

            @Override
            public Void visitVariable(VariableTree node, Void p) {
                JCTree.JCVariableDecl decl = (JCTree.JCVariableDecl)node;
                if ((decl.mods.flags & 0x4000L) == 0L) {
                    decl.init = null;
                } else {
                    Symbol.MethodSymbol constructor = (Symbol.MethodSymbol)decl.type.tsym.members().findFirst(names.init);
                    ListBuffer<JCTree.JCTypeCast> args = new ListBuffer<JCTree.JCTypeCast>();
                    for (Symbol.VarSymbol param : constructor.params) {
                        args.add(make.TypeCast(param.type, (JCTree.JCExpression)make.Literal(TypeTag.BOT, null).setType(syms.botType)));
                    }
                    JCTree.JCNewClass nct = (JCTree.JCNewClass)decl.init;
                    nct.args = args.toList();
                    nct.constructor = constructor;
                    nct.constructorType = constructor.type;
                    nct.def = null;
                }
                decl.sym.type = decl.type = this.error2Object(decl.type);
                this.clearAnnotations(decl.sym.getMetadata());
                return (Void)super.visitVariable(node, p);
            }

            @Override
            public Void visitMethod(MethodTree node, Void p) {
                Type.MethodType mt;
                JCTree.JCMethodDecl decl = (JCTree.JCMethodDecl)node;
                Symbol.MethodSymbol msym = decl.sym;
                if (Collections.disjoint(msym.getModifiers(), EnumSet.of(Modifier.NATIVE, Modifier.ABSTRACT))) {
                    JCTree.JCNewClass nct = make.NewClass(null, List.nil(), make.QualIdent(syms.runtimeExceptionType.tsym), List.of(make.Literal("")), null);
                    nct.type = syms.runtimeExceptionType;
                    nct.constructor = (Symbol)syms.runtimeExceptionType.tsym.members().getSymbols(s -> s.getKind() == ElementKind.CONSTRUCTOR && s.type.getParameterTypes().size() == 1 && ((Type)s.type.getParameterTypes().head).tsym == syms2.stringType.tsym).iterator().next();
                    decl.body = make.Block(0L, List.of(make.Throw(nct)));
                }
                if (msym.type.hasTag(TypeTag.FORALL)) {
                    Type.ForAll fa = (Type.ForAll)msym.type;
                    fa.tvars = this.error2Object(fa.tvars);
                    mt = fa.asMethodType();
                } else {
                    mt = (Type.MethodType)msym.type;
                }
                this.clearMethodType(mt);
                if (msym.erasure_field != null && msym.erasure_field.hasTag(TypeTag.METHOD)) {
                    this.clearMethodType((Type.MethodType)msym.erasure_field);
                }
                this.clearAnnotations(decl.sym.getMetadata());
                return (Void)super.visitMethod(node, p);
            }

            private void clearMethodType(Type.MethodType mt) {
                mt.restype = this.error2Object(mt.restype);
                mt.argtypes = this.error2Object(mt.argtypes);
                mt.thrown = this.error2Object(mt.thrown);
            }

            @Override
            public Void visitClass(ClassTree node, Void p) {
                JCTree.JCClassDecl clazz = (JCTree.JCClassDecl)node;
                Symbol.ClassSymbol csym = clazz.sym;
                Type.ClassType ct = (Type.ClassType)csym.type;
                ct.all_interfaces_field = this.error2Object(ct.all_interfaces_field);
                ct.allparams_field = this.error2Object(ct.allparams_field);
                ct.interfaces_field = this.error2Object(ct.interfaces_field);
                ct.typarams_field = this.error2Object(ct.typarams_field);
                ct.supertype_field = this.error2Object(ct.supertype_field);
                this.clearAnnotations(clazz.sym.getMetadata());
                super.visitClass(node, p);
                for (JCTree def : clazz.defs) {
                    if (!def.hasTag(JCTree.Tag.ERRONEOUS)) continue;
                    clazz.defs = List.filter(clazz.defs, def);
                }
                return null;
            }

            private void clearAnnotations(SymbolMetadata metadata) {
                if (metadata == null) {
                    return;
                }
                List<Attribute.Compound> annotations = metadata.getDeclarationAttributes();
                List<Attribute.Compound> prev = null;
                while (annotations.nonEmpty()) {
                    if (this.isErroneous(((Attribute.Compound)annotations.head).type)) {
                        if (prev == null) {
                            metadata.reset();
                            metadata.setDeclarationAttributes(annotations.tail);
                        } else {
                            prev.tail = annotations.tail;
                        }
                    }
                    prev = annotations;
                    annotations = annotations.tail;
                }
            }

            private boolean isErroneous(TypeMirror type) {
                return type == null || type.getKind() == TypeKind.ERROR || type.getKind() == TypeKind.NONE || type.getKind() == TypeKind.OTHER;
            }

            private Type error2Object(Type t) {
                if (t == null) {
                    return null;
                }
                if (this.isErroneous(t)) {
                    return syms.objectType;
                }
                if (!this.seen.add(t)) {
                    return t;
                }
                switch (t.getKind()) {
                    case DECLARED: {
                        this.resolveErrors((Type.ClassType)t);
                        break;
                    }
                    case WILDCARD: {
                        Type.WildcardType wt = (Type.WildcardType)t;
                        wt.type = this.error2Object(wt.type);
                        Type.TypeVar tv = wt.bound;
                        tv.bound = this.error2Object(tv.bound);
                        tv.lower = this.error2Object(tv.lower);
                        break;
                    }
                }
                return t;
            }

            private List<Type> error2Object(List<Type> types) {
                if (types == null) {
                    return null;
                }
                ListBuffer<Type> lb = new ListBuffer<Type>();
                boolean changed = false;
                for (Type t : types) {
                    Type nue = this.error2Object(t);
                    changed |= nue != t;
                    lb.append(nue);
                }
                return changed ? lb.toList() : types;
            }

            private void resolveErrors(Type.ClassType ct) {
                if (ct.tsym == syms.objectType.tsym) {
                    return;
                }
                ct.all_interfaces_field = this.error2Object(ct.all_interfaces_field);
                ct.allparams_field = this.error2Object(ct.allparams_field);
                ct.interfaces_field = this.error2Object(ct.interfaces_field);
                ct.typarams_field = this.error2Object(ct.typarams_field);
                ct.supertype_field = this.error2Object(ct.supertype_field);
            }
        }.scan(cut, null);
    }
}

