require 'msf/core'

RSpec.describe Msf::Exploit::Remote::BrowserProfileManager do

  subject(:exploit_remmote) {
    mod = Msf::Exploit::Remote.allocate
    mod.extend described_class
    mod
  }

  let(:default_profile) do
    {
      'PREFIX' => {'KEY'=>'VALUE'}
    }
  end

  before(:example) do
    framework = double('framework', browser_profiles: default_profile)
    allow(exploit_remmote).to receive(:framework).and_return(framework)
  end

  describe '#browser_profile_prefix' do
    it 'raises a NoMethodError' do
      expect{subject.browser_profile_prefix}.to raise_exception(NoMethodError)
    end
  end

  describe '#browser_profile' do
    before(:example) do
      allow(subject).to receive(:browser_profile_prefix).and_return('PREFIX')
    end

    it 'returns a hash for the profile' do
      expect(subject.browser_profile).to be_kind_of(Hash)
    end
  end

  describe '#clear_browser_profiles' do
    before(:example) do
      allow(subject).to receive(:browser_profile_prefix).and_return('PREFIX')
    end

    it 'clears profile cache' do
      expect(subject.browser_profile.length).to eq(1)
      subject.clear_browser_profiles
      expect(subject.browser_profile).to be_empty
    end
  end

end