/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMatcher;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.Elements;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleEdge;
import org.jmol.util.SimpleNode;

public class SmilesGenerator {
    private Node[] atoms;
    private int ac;
    private BS bsSelected;
    private BS bsAromatic;
    private int flags;
    private boolean explicitH;
    private Lst<BS> ringSets;
    private VTemp vTemp = new VTemp();
    private int nPairs;
    private int nPairsMax;
    private BS bsBondsUp = new BS();
    private BS bsBondsDn = new BS();
    private BS bsToDo;
    private SimpleNode prevAtom;
    private SimpleNode[] prevSp2Atoms;
    private SimpleNode[] alleneStereo;
    private Map<String, Object[]> htRingsSequence = new Hashtable<String, Object[]>();
    private Map<String, Object[]> htRings = new Hashtable<String, Object[]>();
    private BS bsRingKeys = new BS();
    private BS bsIncludingH;
    private boolean topologyOnly;
    boolean getAromatic = true;
    private boolean addAtomComment;
    private boolean noBioComment;
    private boolean aromaticDouble;
    private boolean noStereo;
    private boolean openSMILES;
    public P3 polySmilesCenter;
    private SmilesStereo smilesStereo;
    private boolean isPolyhedral;
    private Lst<BS> aromaticRings;
    private SmilesMatcher sm;
    private int iHypervalent;
    private int ptAtom;
    private int ptSp2Atom0;
    private SimpleNode[] atemp;
    private int chainCheck;

    String getSmiles(SmilesMatcher smilesMatcher, Node[] nodeArray, int n, BS bS, String string, int n2) throws InvalidSmilesException {
        int n3 = bS.nextSetBit(0);
        if (n3 < 0) {
            return "";
        }
        this.sm = smilesMatcher;
        this.flags = n2;
        this.atoms = nodeArray;
        this.ac = n;
        this.bsSelected = bS = BSUtil.copy(bS);
        this.flags = n2 = SmilesSearch.addFlags(n2, string == null ? "" : string.toUpperCase());
        if ((n2 & 0x100000) == 0x100000) {
            return this.getBioSmiles(bS, string, n2);
        }
        this.openSMILES = (n2 & 5) == 5;
        this.addAtomComment = (n2 & 0x20000) == 131072;
        this.aromaticDouble = (n2 & 0x200) == 512;
        this.explicitH = (n2 & 0x1000) == 4096;
        this.topologyOnly = (n2 & 0x2000) == 8192;
        this.getAromatic = (n2 & 0x10) != 16;
        this.noStereo = (n2 & 0x20) == 32;
        this.isPolyhedral = (n2 & 0x10000) == 65536;
        return this.getSmilesComponent(nodeArray[n3], bS, true, false, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getBioSmiles(BS bS, String string, int n) throws InvalidSmilesException {
        String string2;
        SB sB;
        boolean bl;
        boolean bl2;
        block27: {
            this.addAtomComment = (n & 0x20000) == 131072;
            bl2 = (n & 0x300000) == 0x300000;
            bl = (n & 0x2100000) == 0x2100000;
            boolean bl3 = (n & 0x500000) == 0x500000;
            boolean bl4 = (n & 0x900000) == 0x900000;
            boolean bl5 = bl3 || bl4;
            sB = new SB();
            BS bS2 = bS;
            if (string != null && !this.noBioComment) {
                sB.append("//* Jmol bioSMILES ").append(string.replace('*', '_')).append(" *//");
            }
            String string3 = this.noBioComment ? "" : "\n";
            BS bS3 = new BS();
            String string4 = null;
            String string5 = "";
            Lst<Integer> lst = new Lst<Integer>();
            try {
                int n2 = 0;
                int n3 = bS2.nextSetBit(0);
                while (n3 >= 0) {
                    block26: {
                        int n4;
                        boolean bl6;
                        String string6;
                        String string7;
                        Node node;
                        block28: {
                            block29: {
                                node = this.atoms[n3];
                                string7 = node.getGroup1('?');
                                string6 = node.getBioStructureTypeName();
                                boolean bl7 = bl6 = string7 == string7.toLowerCase();
                                if (string3 == null) break block28;
                                if (sB.length() > 0) {
                                    sB.append(string3);
                                }
                                string3 = null;
                                n2 = 0;
                                if (string6.length() > 0) break block29;
                                string2 = this.getSmilesComponent(node, bS2, false, true, true);
                                if (string2.equals(string4)) {
                                    string3 = "";
                                    break block26;
                                } else {
                                    String string8;
                                    string4 = string2;
                                    String string9 = node.getGroup3(true);
                                    if (bl) {
                                        string8 = "/" + string2 + "/";
                                    } else {
                                        if (string9 != null) {
                                            string2 = "//* " + string9 + " *//" + string2;
                                        }
                                        string8 = String.valueOf(string2) + "//";
                                    }
                                    if (string5.indexOf(string8) >= 0) {
                                        string3 = "";
                                        break block26;
                                    } else {
                                        string5 = String.valueOf(string5) + string8;
                                        sB.append(string2);
                                        string3 = bl ? "." : ".\n";
                                    }
                                }
                                break block26;
                            }
                            n4 = node.getChainID();
                            if (n4 != 0 && !bl) {
                                string2 = "//* chain " + node.getChainIDStr() + " " + string6 + " " + node.getResno() + " *// ";
                                n2 = string2.length();
                                sB.append(string2);
                            }
                            ++n2;
                            sB.append("~").appendC(string6.toLowerCase().charAt(0)).append("~");
                        }
                        if (n2 >= 75 && !bl) {
                            sB.append("\n  ");
                            n2 = 2;
                        }
                        if (this.addAtomComment) {
                            sB.append("\n//* [" + node.getGroup3(false) + "#" + node.getResno() + "] *//\t");
                        }
                        if (bl6) {
                            this.addBracketedBioName(sB, node, string6.length() > 0 ? ".0" : null, false);
                        } else {
                            sB.append(string7);
                        }
                        ++n2;
                        if (bl5) {
                            node.getCrossLinkVector(lst, bl3, bl4);
                            n4 = 0;
                            while (true) {
                                if (n4 >= lst.size()) {
                                    lst.clear();
                                    break;
                                }
                                sB.append(":");
                                string2 = this.getRingCache((Integer)lst.get(n4), (Integer)lst.get(n4 + 1), this.htRingsSequence);
                                sB.append(string2);
                                n2 += 1 + string2.length();
                                n4 += 3;
                            }
                        }
                        node.getGroupBits(bS3);
                        bS2.andNot(bS3);
                        n4 = node.getOffsetResidueAtom("\u0000", 1);
                        if (n4 < 0 || !bS2.get(n4)) {
                            if (!bl) {
                                sB.append(" //* ").appendI(node.getResno()).append(" *//");
                            }
                            if (n4 < 0 && (n4 = bS2.nextSetBit(n3 + 1)) < 0) break block27;
                            if (n2 > 0) {
                                string3 = bl ? "." : ".\n";
                            }
                        }
                        n3 = n4 - 1;
                    }
                    n3 = bS2.nextSetBit(n3 + 1);
                }
            }
            catch (Exception exception) {
                throw new InvalidSmilesException("//* error: " + exception.getMessage() + " *//");
            }
        }
        if (!bl2 && !this.htRingsSequence.isEmpty()) {
            this.dumpRingKeys(sB, this.htRingsSequence);
            throw new InvalidSmilesException("//* ?ring error? *//");
        }
        string2 = sB.toString();
        if (string2.endsWith(".\n")) {
            return string2.substring(0, string2.length() - 2);
        }
        if (!bl) return string2;
        if (!string2.endsWith(".")) return string2;
        return string2.substring(0, string2.length() - 1);
    }

    private void addBracketedBioName(SB sB, Node node, String string, boolean bl) {
        sB.append("[");
        if (string != null) {
            String string2 = node.getChainIDStr();
            sB.append(node.getGroup3(false));
            if (!string.equals(".0")) {
                sB.append(string).append("#").appendI(node.getElementNumber());
            }
            if (bl) {
                sB.append("//* ").appendI(node.getResno());
                if (string2.length() > 0) {
                    sB.append(":").append(string2);
                }
                sB.append(" *//");
            }
        } else {
            sB.append(Elements.elementNameFromNumber(node.getElementNumber()));
        }
        sB.append("]");
    }

    private String getSmilesComponent(Node node, BS bS, boolean bl, boolean bl2, boolean bl3) throws InvalidSmilesException {
        if (!this.explicitH && node.getAtomicAndIsotopeNumber() == 1 && node.getEdges().length > 0) {
            node = this.atoms[node.getBondedAtomIndex(0)];
        }
        this.bsSelected = JmolMolecule.getBranchBitSet(this.atoms, node.getIndex(), BSUtil.copy(bS), null, -1, true, bl);
        bS.andNot(this.bsSelected);
        this.iHypervalent = -1;
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0 && this.iHypervalent < 0) {
            if (this.atoms[n].getCovalentBondCount() > 4 || this.isPolyhedral) {
                this.iHypervalent = n;
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
        this.bsIncludingH = BSUtil.copy(this.bsSelected);
        if (!this.explicitH) {
            n = this.bsSelected.nextSetBit(0);
            while (n >= 0) {
                Node node2 = this.atoms[n];
                if (node2.getAtomicAndIsotopeNumber() == 1 && node2.getBondCount() > 0 && node2.getBondedAtomIndex(0) != this.iHypervalent) {
                    this.bsSelected.clear(n);
                }
                n = this.bsSelected.nextSetBit(n + 1);
            }
        }
        this.bsAromatic = new BS();
        if (!this.topologyOnly && this.bsSelected.cardinality() > 2) {
            this.generateRingData();
            this.setBondDirections();
        }
        this.bsToDo = BSUtil.copy(this.bsSelected);
        SB sB = new SB();
        int n2 = this.bsToDo.nextSetBit(0);
        while (n2 >= 0) {
            if (this.atoms[n2].getCovalentBondCount() > 4 || this.isPolyhedral) {
                if (node == null) {
                    sB.append(".");
                }
                this.getSmilesAt(sB, this.atoms[n2], bl2, false, bl3);
                node = null;
            }
            n2 = this.bsToDo.nextSetBit(n2 + 1);
        }
        if (node != null) {
            while ((node = this.getSmilesAt(sB, node, bl2, true, bl3)) != null) {
            }
        }
        while (this.bsToDo.cardinality() > 0 || !this.htRings.isEmpty()) {
            Iterator<Object[]> iterator = this.htRings.values().iterator();
            if (iterator.hasNext()) {
                node = this.atoms[(Integer)iterator.next()[1]];
                if (!this.bsToDo.get(node.getIndex())) {
                    break;
                }
            } else {
                node = this.atoms[this.bsToDo.nextSetBit(0)];
            }
            sB.append(".");
            this.alleneStereo = null;
            this.prevSp2Atoms = null;
            this.prevAtom = null;
            while ((node = this.getSmilesAt(sB, node, bl2, true, bl3)) != null) {
            }
        }
        if (!this.htRings.isEmpty()) {
            this.dumpRingKeys(sB, this.htRings);
            throw new InvalidSmilesException("//* ?ring error? *//\n" + sB);
        }
        String string = sB.toString();
        if (string.indexOf("^-") >= 0) {
            String string2 = string;
            try {
                String string3 = this.sm.getAtropisomerKeys(string, this.atoms, this.ac, this.bsSelected, this.bsAromatic, this.flags);
                int n3 = 1;
                while (n3 < string3.length()) {
                    int n4 = string.indexOf("^-");
                    if (n4 >= 0) {
                        string = String.valueOf(string.substring(0, n4 + 1)) + string3.substring(n3, n3 + 2) + string.substring(n4 + 1);
                        n3 += 3;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                System.out.println("???");
                string = string2;
            }
        }
        return string;
    }

    private void generateRingData() throws InvalidSmilesException {
        SmilesSearch smilesSearch = SmilesParser.newSearch("[r500]", true, true);
        smilesSearch.targetAtoms = this.atoms;
        smilesSearch.setSelected(this.bsSelected);
        smilesSearch.setFlags(this.flags);
        smilesSearch.targetAtomCount = this.ac;
        smilesSearch.ringDataMax = 7;
        smilesSearch.flags = this.flags;
        Lst<type>[] lstArray = AU.createArrayOfArrayList(4);
        smilesSearch.setRingData(null, lstArray, true);
        this.bsAromatic = smilesSearch.bsAromatic;
        this.ringSets = smilesSearch.ringSets;
        this.aromaticRings = lstArray[3];
    }

    private char getBondStereochemistry(Edge edge, SimpleNode simpleNode) {
        boolean bl;
        if (edge == null) {
            return '\u0000';
        }
        int n = edge.index;
        boolean bl2 = bl = simpleNode == null || edge.getAtomIndex1() == simpleNode.getIndex();
        return (char)(this.bsBondsUp.get(n) ? (bl ? 47 : 92) : (this.bsBondsDn.get(n) ? (bl ? 92 : 47) : 0));
    }

    private void setBondDirections() {
        BS bS = new BS();
        Edge[][] edgeArray = new Edge[2][3];
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            Node node = this.atoms[n];
            Edge[] edgeArray2 = node.getEdges();
            int n2 = 0;
            while (n2 < edgeArray2.length) {
                SimpleNode simpleNode;
                Edge edge = edgeArray2[n2];
                int n3 = edge.index;
                if (!bS.get(n3) && edge.getCovalentOrder() == 2 && !SmilesSearch.isRingBond(this.ringSets, null, n, (simpleNode = edge.getOtherNode(node)).getIndex())) {
                    Object object;
                    Object object2;
                    bS.set(n3);
                    int n4 = 0;
                    SimpleNode simpleNode2 = node;
                    while (simpleNode.getCovalentBondCount() == 2 && simpleNode.getValence() == 4) {
                        object = object2[(object2 = (Edge[])simpleNode.getEdges())[0].getOtherNode(simpleNode) == simpleNode2 ? 1 : 0];
                        bS.set(((Edge)object).index);
                        simpleNode2 = simpleNode;
                        simpleNode = object.getOtherNode(simpleNode);
                        ++n4;
                    }
                    if (n4 % 2 != 1) {
                        object2 = null;
                        object = null;
                        char c = '\u0000';
                        SimpleNode[] simpleNodeArray = new SimpleNode[]{node, simpleNode};
                        int n5 = 1;
                        char c2 = '\u0000';
                        while (c2 < '\u0002' && n5 > 0 && n5 < 3) {
                            n5 = 0;
                            SimpleNode simpleNode3 = simpleNodeArray[c2];
                            Edge[] edgeArray3 = ((Node)simpleNode3).getEdges();
                            int n6 = 0;
                            while (n6 < edgeArray3.length) {
                                SimpleNode simpleNode4;
                                if (edgeArray3[n6].getCovalentOrder() == 1 && ((simpleNode4 = edgeArray3[n6].getOtherNode(simpleNode3)).getElementNumber() != 1 || simpleNode4.getIsotopeNumber() != 0)) {
                                    edgeArray[c2][n5++] = edgeArray3[n6];
                                    if (this.getBondStereochemistry(edgeArray3[n6], simpleNode3) != '\u0000') {
                                        object2 = edgeArray3[n6];
                                        c = c2;
                                    }
                                }
                                ++n6;
                            }
                            ++c2;
                        }
                        if (n5 != 3 && n5 != 0) {
                            if (object2 == null) {
                                c = '\u0000';
                                object2 = edgeArray[c][0];
                                this.bsBondsUp.set(((Edge)object2).index);
                            }
                            c2 = this.getBondStereochemistry((Edge)object2, simpleNodeArray[c]);
                            object = object2.getOtherNode(simpleNodeArray[c]);
                            if (object != null) {
                                int n7 = 0;
                                while (n7 < 2) {
                                    int n8 = 0;
                                    while (n8 < 2) {
                                        Edge edge2 = edgeArray[n7][n8];
                                        if (edge2 != null && edge2 != object2) {
                                            int n9 = edge2.index;
                                            SimpleNode simpleNode5 = edge2.getOtherNode(simpleNodeArray[n7]);
                                            if (simpleNode5 != null) {
                                                char c3 = this.getBondStereochemistry(edge2, simpleNodeArray[n7]);
                                                boolean bl = SmilesStereo.isDiaxial(simpleNodeArray[c], simpleNodeArray[n7], (SimpleNode)object, simpleNode5, this.vTemp, 0.0f);
                                                if (c3 == '\u0000' || c3 != c2 == bl) {
                                                    boolean bl2 = c2 == '\\' && bl || c2 == '/' && !bl;
                                                    if (bl2 == (edge2.getAtomIndex1() != simpleNode5.getIndex())) {
                                                        this.bsBondsUp.set(n9);
                                                    } else {
                                                        this.bsBondsDn.set(n9);
                                                    }
                                                } else {
                                                    Logger.error("BOND STEREOCHEMISTRY ERROR");
                                                }
                                                if (Logger.debugging) {
                                                    Logger.debug(String.valueOf(this.getBondStereochemistry((Edge)object2, simpleNodeArray[0])) + " " + object.getIndex() + " " + simpleNode5.getIndex() + " " + this.getBondStereochemistry(edge2, simpleNodeArray[n7]));
                                                }
                                            }
                                        }
                                        ++n8;
                                    }
                                    ++n7;
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
    }

    private Node getSmilesAt(SB sB, SimpleNode simpleNode, boolean bl, boolean bl2, boolean bl3) {
        Object f;
        int n;
        int string;
        Object object;
        int n3;
        Object object3;
        int n4;
        Object object4;
        int n5;
        int n6;
        int n7 = simpleNode.getIndex();
        if (!this.bsToDo.get(n7)) {
            return null;
        }
        ++this.ptAtom;
        this.bsToDo.clear(n7);
        boolean bl4 = n7 == this.iHypervalent || this.explicitH;
        boolean bl5 = !this.bsSelected.get(n7);
        int n8 = this.prevAtom == null ? -1 : this.prevAtom.getIndex();
        boolean bl6 = this.bsAromatic.get(n7);
        SimpleNode[] simpleNodeArray = this.prevSp2Atoms;
        boolean bl7 = simpleNodeArray != null;
        int n9 = simpleNode.getElementNumber();
        int n10 = 0;
        SimpleNode[] simpleNodeArray2 = this.alleneStereo;
        this.alleneStereo = null;
        Lst<Edge> lst = new Lst<Edge>();
        SimpleEdge simpleEdge = null;
        Edge edge = null;
        Edge[] edgeArray = (Edge[])simpleNode.getEdges();
        if (this.polySmilesCenter != null) {
            bl2 = false;
            this.sortBonds(simpleNode, this.prevAtom, this.polySmilesCenter);
        }
        SimpleNode simpleNode2 = null;
        int n2 = n6 = bl6 ? 10 : 0;
        if (Logger.debugging) {
            Logger.debug(sB.toString());
        }
        if (edgeArray != null) {
            n5 = edgeArray.length;
            while (--n5 >= 0) {
                object4 = edgeArray[n5];
                if (!((Edge)object4).isCovalent()) continue;
                SimpleNode simpleNode3 = edgeArray[n5].getOtherNode(simpleNode);
                int n12 = simpleNode3.getIndex();
                if (n12 == n8) {
                    edge = edgeArray[n5];
                    continue;
                }
                int n11 = n4 = !bl4 && simpleNode3.getElementNumber() == 1 && simpleNode3.getIsotopeNumber() == 0 ? 1 : 0;
                if (!this.bsIncludingH.get(n12)) {
                    if (n4 != 0 || !bl || !this.bsSelected.get(n7)) continue;
                    this.bsToDo.set(n12);
                }
                if (n4 != 0) {
                    simpleNode2 = simpleNode3;
                    if (++n10 <= 1) continue;
                    n6 = 10;
                    continue;
                }
                lst.addLast(edgeArray[n5]);
            }
        }
        if (n10 > 1) {
            simpleNodeArray = null;
        }
        int n12 = n5 = simpleNodeArray != null ? 2 : 0;
        if (simpleNodeArray == null && !bl6 && n10 <= 1) {
            simpleNodeArray = new Node[5];
        }
        object4 = null;
        if (edge != null) {
            object4 = this.getBondOrder(edge, n7, n8, bl6);
            if (simpleNodeArray != null && !bl7) {
                simpleNodeArray[n5++] = this.prevAtom;
            }
        }
        if (simpleNodeArray != null && !bl7) {
            this.ptSp2Atom0 = this.ptAtom;
        }
        if (simpleNodeArray != null && n10 == 1) {
            simpleNodeArray[n5++] = simpleNode2;
        }
        int n15 = 0;
        BS bS = new BS();
        n4 = lst.size();
        if (bl2) {
            int n16 = 0;
            while (n16 < n4) {
                Edge edge2 = (Edge)lst.get(n16);
                object3 = edge2.getOtherNode(simpleNode);
                n3 = object3.getCovalentBondCount() - (bl4 ? 0 : ((Node)object3).getCovalentHydrogenCount());
                int c = edge2.getCovalentOrder();
                if (n3 == 1 && (simpleEdge != null || n16 < n4 - 1)) {
                    bS.set(edge2.index);
                } else if (!(c <= 1 && n3 <= n15 || this.htRings.containsKey(SmilesGenerator.getRingKey(object3.getIndex(), n7)))) {
                    n15 = c > 1 ? 1000 + c : n3;
                    simpleEdge = edge2;
                }
                ++n16;
            }
        }
        Node node = simpleEdge == null ? null : (Node)simpleEdge.getOtherNode(simpleNode);
        int n17 = simpleEdge == null ? 0 : ((Edge)simpleEdge).getCovalentOrder();
        object3 = new Node[7];
        if (n6 < 7 && edge != null) {
            if (bl7 && edge.getCovalentOrder() == 2 && n17 == 2 && simpleNodeArray[1] != null) {
                object3[n6++] = simpleNodeArray[0];
                object3[n6++] = simpleNodeArray[1];
            } else {
                object3[n6++] = this.prevAtom;
            }
        }
        if (n6 < 7 && n10 == 1) {
            object3[n6++] = simpleNode2;
        }
        n3 = n17 == 1 && simpleNodeArray == null ? 1 : 0;
        char c = this.getBondStereochemistry(edge, this.prevAtom);
        if (object4 != null || c != '\u0000') {
            if (c != '\u0000') {
                object4 = "" + c;
            }
            sB.append((String)object4);
        }
        int n13 = n6;
        int n14 = n5;
        SB sB2 = new SB();
        Lst<String> lst2 = new Lst<String>();
        int n16 = 0;
        while (n16 < lst.size()) {
            Edge edge2 = (Edge)lst.get(n16);
            if (bS.get(edge2.index)) {
                SimpleNode simpleNode3 = edge2.getOtherNode(simpleNode);
                object = new SB();
                this.prevAtom = simpleNode;
                this.alleneStereo = null;
                this.prevSp2Atoms = null;
                SimpleEdge simpleEdge2 = simpleEdge;
                string = this.ptSp2Atom0;
                n = this.ptAtom;
                this.getSmilesAt((SB)object, simpleNode3, bl, bl2, bl3);
                simpleEdge = simpleEdge2;
                this.ptAtom = n;
                this.ptSp2Atom0 = string;
                f = ((SB)object).toString();
                lst.removeItemAt(n16--);
                if (simpleEdge == null) {
                    lst2.addLast((String)f);
                } else {
                    sB2.append("(").append((String)f).append(")");
                }
                if (n6 < 7) {
                    object3[n6++] = simpleNode3;
                }
                if (simpleNodeArray != null && n5 < 5) {
                    simpleNodeArray[n5++] = simpleNode3;
                }
            }
            ++n16;
        }
        SB sB3 = new SB();
        int n18 = n6;
        int n19 = n5;
        object = null;
        if (!(bl2 || this.noStereo || this.polySmilesCenter != null || lst.size() != 5 && lst.size() != 6)) {
            object = this.sortInorganic(simpleNode, lst, this.vTemp);
        }
        int n20 = 0;
        while (n20 < lst.size()) {
            Edge n27 = (Edge)lst.get(n20);
            if (n27 != simpleEdge) {
                char c2;
                SimpleNode simpleNode4 = n27.getOtherNode(simpleNode);
                object4 = this.getBondOrder(n27, n7, simpleNode4.getIndex(), bl6);
                if (n3 == 0 && (c2 = this.getBondStereochemistry(n27, simpleNode)) != '\u0000') {
                    object4 = "" + c2;
                }
                sB3.append((String)object4);
                sB3.append(this.getRingCache(n7, simpleNode4.getIndex(), this.htRings));
                if (n6 < 7) {
                    object3[n6++] = simpleNode4;
                }
                if (simpleNodeArray != null && n5 < 5) {
                    simpleNodeArray[n5++] = simpleNode4;
                }
            }
            ++n20;
        }
        if (n13 != n18 && n18 != n6) {
            this.swapArray((SimpleNode[])object3, n13, n18, n6);
        }
        if (n14 != n19 && n19 != n5) {
            this.swapArray(simpleNodeArray, n14, n19, n5);
        }
        if (bl7 && n6 == 2 && n17 == 2) {
            n20 = this.ptAtom - this.ptSp2Atom0;
            string = node.getCovalentBondCount();
            int n21 = n = node.getElementNumber() == 7 ? 1 : 0;
            if (n20 % 2 == 0) {
                n6 = 8;
            } else if (string == 3 || string == 2 && n != 0) {
                edgeArray = node.getEdges();
                int n22 = 0;
                while (n22 < edgeArray.length) {
                    int n23 = node.getBondedAtomIndex(n22);
                    if (edgeArray[n22].isCovalent() && n23 != n7) {
                        object3[n6++] = this.atoms[n23];
                    }
                    ++n22;
                }
                if (string == 2) {
                    object3[n6++] = node;
                }
                if (n6 == 4) {
                    this.alleneStereo = object3;
                    if (((Node)object3[3]).getAtomicAndIsotopeNumber() == 1) {
                        f = object3[3];
                        object3[3] = object3[2];
                        object3[2] = f;
                    }
                }
            }
            n5 = 0;
        } else if (node != null && n6 < 7) {
            object3[n6++] = node;
        }
        if (simpleNodeArray2 != null) {
            if (simpleNodeArray2[3] != object3[2] && (n20 = sB.lastIndexOf("@]=")) > 0) {
                String string2 = sB.substring(n20);
                sB.setLength(sB.charAt(n20 - 1) == '@' ? n20 - 1 : n20 + 1);
                sB.append(string2);
            }
            simpleNodeArray2 = null;
        }
        n20 = simpleNode.getFormalCharge();
        int n24 = simpleNode.getIsotopeNumber();
        n = simpleNode.getValence();
        float f2 = this.openSMILES ? ((Node)simpleNode).getFloatProperty("property_atomclass") : Float.NaN;
        String string3 = simpleNode.getAtomName();
        String string4 = ((Node)simpleNode).getBioStructureTypeName();
        if (this.addAtomComment) {
            sB.append("\n//* " + simpleNode.toString() + " *//\t");
        }
        if (this.topologyOnly) {
            sB.append("*");
        } else if (bl5 && string4.length() != 0 && string3.length() != 0) {
            this.addBracketedBioName(sB, (Node)simpleNode, "." + string3, false);
        } else {
            sB.append(SmilesAtom.getAtomLabel(n9, n24, bl3 ? -1 : n, n20, f2, n10, bl6, (String)(object != null ? object : (this.noStereo ? null : this.checkStereoPairs(simpleNode, this.alleneStereo == null ? n7 : -1, (SimpleNode[])object3, n6)))));
        }
        sB.appendSB(sB3);
        if (simpleEdge == null) {
            int n25 = lst2.size() - 1;
            if (n25 >= 0) {
                int n26 = 0;
                while (n26 < n25) {
                    sB.append("(").append((String)lst2.get(n26)).append(")");
                    ++n26;
                }
                sB.append((String)lst2.get(n25));
            }
            return null;
        }
        sB.appendSB(sB2);
        if (simpleNodeArray != null && n17 == 2 && (n5 == 1 || n5 == 2)) {
            if (simpleNodeArray[0] == null) {
                simpleNodeArray[0] = simpleNode;
            }
            if (simpleNodeArray[1] == null) {
                simpleNodeArray[1] = simpleNode;
            }
        } else {
            simpleNodeArray = null;
            n5 = 0;
        }
        this.prevSp2Atoms = simpleNodeArray;
        this.prevAtom = simpleNode;
        return node;
    }

    private void swapArray(SimpleNode[] simpleNodeArray, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (this.atemp == null || this.atemp.length < n4) {
            this.atemp = new Node[n4];
        }
        int n5 = n4;
        int n6 = n2;
        while (n5 > 0) {
            this.atemp[--n5] = simpleNodeArray[--n6];
        }
        n5 = n2;
        while (n5 < n3) {
            simpleNodeArray[n5 - n4] = simpleNodeArray[n5];
            ++n5;
        }
        n5 = n4;
        n6 = n3;
        while (n5 > 0) {
            simpleNodeArray[--n6] = this.atemp[--n5];
        }
    }

    private String getBondOrder(Edge edge, int n, int n2, boolean bl) {
        if (this.topologyOnly) {
            return "";
        }
        if ((edge.order & 0x10001) == 65537) {
            return "^-";
        }
        int n3 = edge.getCovalentOrder();
        return !bl || !this.bsAromatic.get(n2) ? SmilesBond.getBondOrderString(n3) : (n3 == 1 && !this.isSameAromaticRing(n, n2) ? "-" : (this.aromaticDouble && (n3 == 2 || n3 == 514) ? "=" : ""));
    }

    private boolean isSameAromaticRing(int n, int n2) {
        int n3 = this.aromaticRings.size();
        while (--n3 >= 0) {
            BS bS = (BS)this.aromaticRings.get(n3);
            if (!bS.get(n) || !bS.get(n2)) continue;
            return true;
        }
        return false;
    }

    void sortBonds(SimpleNode simpleNode, SimpleNode simpleNode2, P3 p3) {
        if (this.smilesStereo == null) {
            try {
                this.smilesStereo = SmilesStereo.newStereo(null);
            }
            catch (InvalidSmilesException invalidSmilesException) {
                // empty catch block
            }
        }
        this.smilesStereo.sortBondsByStereo(simpleNode, simpleNode2, p3, simpleNode.getEdges(), this.vTemp.vA);
    }

    private String sortInorganic(SimpleNode simpleNode, Lst<Edge> lst, VTemp vTemp) {
        int n;
        Edge edge;
        int n2 = simpleNode.getIndex();
        int n3 = lst.size();
        Lst<Edge[]> lst2 = new Lst<Edge[]>();
        Lst<Edge> lst3 = new Lst<Edge>();
        SimpleNode simpleNode2 = null;
        SimpleNode simpleNode3 = null;
        BS bS = new BS();
        Edge[] edgeArray = null;
        SimpleNode[] simpleNodeArray = new Node[6];
        boolean bl = true;
        String string = "";
        int n4 = 0;
        int n5 = 0;
        while (n5 < n3) {
            edge = (Edge)lst.get(n5);
            SimpleNode simpleNode4 = edge.getOtherNode(simpleNode);
            simpleNodeArray[0] = simpleNode4;
            if (n5 == 0) {
                string = this.addStereoCheck(0, n2, simpleNode4, "", null);
            } else if (bl && this.addStereoCheck(0, n2, simpleNode4, string, null) != null) {
                bl = false;
            }
            if (!bS.get(n5)) {
                bS.set(n5);
                n = 0;
                int n6 = n5 + 1;
                while (n6 < n3) {
                    Edge edge2;
                    SimpleNode simpleNode5;
                    if (!bS.get(n6) && SmilesStereo.isDiaxial(simpleNode, simpleNode, simpleNode4, simpleNode5 = (edge2 = (Edge)lst.get(n6)).getOtherNode(simpleNode), vTemp, -0.95f)) {
                        switch (++n4) {
                            case 1: {
                                simpleNode2 = simpleNode4;
                                break;
                            }
                            case 2: {
                                simpleNode3 = simpleNode4;
                                break;
                            }
                            case 3: {
                                if (SmilesStereo.getHandedness(simpleNode3, simpleNode2, simpleNode4, simpleNode, vTemp) != 2) break;
                                Edge edge3 = edge;
                                edge = edge2;
                                edge2 = edge3;
                            }
                        }
                        lst2.addLast(new Edge[]{edge, edge2});
                        n = 1;
                        bS.set(n6);
                        break;
                    }
                    ++n6;
                }
                if (n == 0) {
                    lst3.addLast(edge);
                }
            }
            ++n5;
        }
        n5 = lst2.size();
        if (bl || n3 == 6 && n5 != 3 || n3 == 5 && n5 == 0) {
            return "";
        }
        edgeArray = (Edge[])lst2.get(0);
        edge = edgeArray[0];
        simpleNodeArray[0] = edge.getOtherNode(simpleNode);
        lst.clear();
        lst.addLast(edge);
        if (n5 > 1) {
            lst3.addLast(((Edge[])lst2.get(1))[0]);
        }
        if (n5 == 3) {
            lst3.addLast(((Edge[])lst2.get(2))[0]);
        }
        if (n5 > 1) {
            lst3.addLast(((Edge[])lst2.get(1))[1]);
        }
        if (n5 == 3) {
            lst3.addLast(((Edge[])lst2.get(2))[1]);
        }
        n = 0;
        while (n < lst3.size()) {
            edge = (Edge)lst3.get(n);
            lst.addLast(edge);
            simpleNodeArray[n + 1] = edge.getOtherNode(simpleNode);
            ++n;
        }
        lst.addLast(edgeArray[1]);
        simpleNodeArray[n3 - 1] = edgeArray[1].getOtherNode(simpleNode);
        return SmilesStereo.getStereoFlag(simpleNode, simpleNodeArray, n3, vTemp);
    }

    private String checkStereoPairs(SimpleNode simpleNode, int n, SimpleNode[] simpleNodeArray, int n2) {
        if (n2 < 4) {
            return "";
        }
        if (n >= 0 && n2 == 4 && simpleNode.getElementNumber() == 6) {
            String string = "";
            int n3 = 0;
            while (n3 < 4) {
                if ((string = this.addStereoCheck(0, n, simpleNodeArray[n3], string, BSUtil.newAndSetBit(n))) == null) {
                    n2 = 10;
                    break;
                }
                ++n3;
            }
        }
        return n2 > 6 ? "" : SmilesStereo.getStereoFlag(simpleNode, simpleNodeArray, n2, this.vTemp);
    }

    private String addStereoCheck(int n, int n2, SimpleNode simpleNode, String string, BS bS) {
        int n3;
        if (bS != null) {
            bS.set(n2);
        }
        int n4 = ((Node)simpleNode).getAtomicAndIsotopeNumber();
        int n5 = simpleNode.getCovalentBondCount();
        int n6 = n3 = n4 == 6 && !this.explicitH ? ((Node)simpleNode).getCovalentHydrogenCount() : 0;
        if (n4 == 6 ? n5 != 4 : n4 == 1 || n5 > 1) {
            return String.valueOf(string) + ++this.chainCheck;
        }
        String string2 = ";" + n + "/" + n4 + "/" + n3 + "/" + n5 + (n == 0 ? "," : "_");
        if (n4 == 6) {
            switch (n3) {
                case 1: {
                    return String.valueOf(string) + string2 + ++this.chainCheck;
                }
                case 0: 
                case 2: {
                    if (bS == null) {
                        return string;
                    }
                    Edge[] edgeArray = ((Node)simpleNode).getEdges();
                    String string3 = "";
                    String string4 = "";
                    int n7 = n3 == 2 ? 0 : 3;
                    int n8 = simpleNode.getBondCount();
                    while (--n8 >= 0) {
                        SimpleNode simpleNode2 = edgeArray[n8].getOtherNode(simpleNode);
                        int n9 = simpleNode2.getIndex();
                        if (bS.get(n9) || !edgeArray[n8].isCovalent() || simpleNode2.getElementNumber() == 1) continue;
                        bS.set(n9);
                        string4 = this.addStereoCheck(n + 1, simpleNode.getIndex(), simpleNode2, "", (BS)bS.clone());
                        if (string3.indexOf(string4) >= 0) {
                            --n7;
                        }
                        string3 = String.valueOf(string3) + string4;
                    }
                    if (n7 == 3) {
                        return String.valueOf(string) + string2 + ++this.chainCheck;
                    }
                    string2 = (String.valueOf(string2) + string3).replace(',', '_');
                    if (n <= 0) break;
                    return String.valueOf(string) + string2;
                }
            }
        }
        if (string.indexOf(string2) >= 0) {
            if (n3 == 3) {
                int n10 = 0;
                int n11 = 0;
                while (n11 < n5 && n10 < 3) {
                    int n12 = ((Node)simpleNode).getBondedAtomIndex(n11);
                    if (n12 != n2) {
                        n10 += this.atoms[n12].getAtomicAndIsotopeNumber();
                    }
                    ++n11;
                }
                if (n10 > 3) {
                    return string;
                }
            }
            return null;
        }
        return String.valueOf(string) + string2;
    }

    private String getRingCache(int n, int n2, Map<String, Object[]> map) {
        String string;
        String string2 = SmilesGenerator.getRingKey(n, n2);
        Object[] objectArray = map.get(string2);
        String string3 = string = objectArray == null ? null : (String)objectArray[0];
        if (string == null) {
            this.bsRingKeys.set(++this.nPairs);
            this.nPairsMax = Math.max(this.nPairs, this.nPairsMax);
            Object[] objectArray2 = new Object[3];
            string = this.getRingPointer(this.nPairs);
            objectArray2[0] = string;
            objectArray2[1] = n2;
            objectArray2[2] = this.nPairs;
            map.put(string2, objectArray2);
            if (Logger.debugging) {
                Logger.debug("adding for " + n + " ring key " + this.nPairs + ": " + string2);
            }
        } else {
            map.remove(string2);
            int n3 = (Integer)objectArray[2];
            this.bsRingKeys.clear(n3);
            if (this.bsRingKeys.nextSetBit(0) < 0 && (this.nPairsMax == 2 || this.nPairsMax == 99)) {
                this.nPairs = this.nPairsMax == 99 ? 10 : 0;
                this.nPairsMax = this.nPairs;
            }
            if (Logger.debugging) {
                Logger.debug("using ring key " + string2);
            }
        }
        return string;
    }

    private String getRingPointer(int n) {
        return n < 10 ? "" + n : (n < 100 ? "%" + n : "%(" + n + ")");
    }

    private void dumpRingKeys(SB sB, Map<String, Object[]> map) {
        Logger.info(String.valueOf(sB.toString()) + "\n\n");
        for (String string : map.keySet()) {
            Logger.info("unmatched connection: " + string);
        }
    }

    protected static String getRingKey(int n, int n2) {
        return String.valueOf(Math.min(n, n2)) + "_" + Math.max(n, n2);
    }
}

