/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.versionmapping;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.maven.internal.versionmapping.DefaultVariantVersionMappingStrategy;
import org.gradle.api.publish.maven.internal.versionmapping.PublishedVariant;
import org.gradle.api.publish.maven.internal.versionmapping.PublishedVariantVersionMapping;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;

public class DefaultVersionMappingStrategy
implements VersionMappingStrategyInternal {
    private final ObjectFactory objectFactory;
    private final ConfigurationContainer configurations;
    private final List<PublishedVariantVersionMapping> mappings = Lists.newArrayListWithExpectedSize((int)2);

    public DefaultVersionMappingStrategy(ObjectFactory objectFactory, ConfigurationContainer configurations) {
        this.objectFactory = objectFactory;
        this.configurations = configurations;
    }

    public void allVariants(Action<? super VariantVersionMappingStrategy> action) {
        PublishedVariantVersionMapping mapping = new PublishedVariantVersionMapping((Spec<? super PublishedVariant>)Specs.SATISFIES_ALL, action);
        this.mappings.add(mapping);
    }

    public <T> void variant(final Attribute<T> attribute, final T attributeValue, Action<? super VariantVersionMappingStrategy> action) {
        PublishedVariantVersionMapping mapping = new PublishedVariantVersionMapping((Spec<? super PublishedVariant>)new Spec<PublishedVariant>(){

            public boolean isSatisfiedBy(PublishedVariant element) {
                AttributeValue entry = element.attributes.findEntry(attribute);
                return entry.isPresent() && entry.get() == attributeValue;
            }
        }, action);
        this.mappings.add(mapping);
    }

    public void usage(String usage, Action<? super VariantVersionMappingStrategy> action) {
        this.variant(Usage.USAGE_ATTRIBUTE, (Usage)this.objectFactory.named(Usage.class, usage), action);
    }

    public VariantVersionMappingStrategyInternal findStrategyForVariant(String variantName, ImmutableAttributes variantAttributes) {
        PublishedVariant publishedVariant = new PublishedVariant(variantName, variantAttributes);
        DefaultVariantVersionMappingStrategy strategy = new DefaultVariantVersionMappingStrategy(this.configurations);
        for (PublishedVariantVersionMapping mapping : this.mappings) {
            mapping.applyTo(publishedVariant, (VariantVersionMappingStrategy)strategy);
        }
        return strategy;
    }
}

