/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.ProjectGenerator;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;

public class BasicProjectGenerator
implements ProjectGenerator {
    private final BuildScriptBuilderFactory scriptBuilderFactory;

    public BasicProjectGenerator(BuildScriptBuilderFactory scriptBuilderFactory) {
        this.scriptBuilderFactory = scriptBuilderFactory;
    }

    @Override
    public String getId() {
        return "basic";
    }

    @Override
    public void generate(InitSettings settings) {
        this.scriptBuilderFactory.script(settings.getDsl(), "build").fileComment("This is a general purpose Gradle build.\nLearn how to create Gradle builds at https://guides.gradle.org/creating-new-gradle-builds/").create().generate();
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return BuildInitDsl.GROOVY;
    }

    @Override
    public boolean supportsPackage() {
        return false;
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.NONE;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.NONE);
    }
}

