/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.awt.Color;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GameOptions;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.option.MapGeneratorOptions;
import net.sf.freecol.common.option.OptionGroup;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class PreGameInputHandler
extends InputHandler {
    private static final Logger logger = Logger.getLogger(PreGameInputHandler.class.getName());

    public PreGameInputHandler(FreeColClient freeColClient) {
        super(freeColClient);
    }

    @Override
    public synchronized Element handle(Connection connection, Element element) {
        String type;
        String string = type = element == null ? "(null)" : element.getTagName();
        return "addPlayer".equals(type) ? this.addPlayer(element) : ("chat".equals(type) ? this.chat(element) : ("disconnect".equals(type) ? this.disconnect(element) : ("error".equals(type) ? this.error(element) : ("logout".equals(type) ? this.logout(element) : ("multiple".equals(type) ? this.multiple(connection, element) : ("playerReady".equals(type) ? this.playerReady(element) : ("removePlayer".equals(type) ? this.removePlayer(element) : ("setAvailable".equals(type) ? this.setAvailable(element) : ("startGame".equals(type) ? this.startGame(element) : ("updateColor".equals(type) ? this.updateColor(element) : ("updateGame".equals(type) ? this.updateGame(element) : ("updateGameOptions".equals(type) ? this.updateGameOptions(element) : ("updateMapGeneratorOptions".equals(type) ? this.updateMapGeneratorOptions(element) : ("updateNation".equals(type) ? this.updateNation(element) : ("updateNationType".equals(type) ? this.updateNationType(element) : this.unknown(element))))))))))))))));
    }

    private Element addPlayer(Element element) {
        Element playerElement;
        String id;
        Game game = this.getFreeColClient().getGame();
        FreeColGameObject fcgo = game.getFreeColGameObject(id = FreeColObject.readId(playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0)));
        if (fcgo == null) {
            game.addPlayer(new Player(game, playerElement));
        } else {
            fcgo.readFromXMLElement(playerElement);
        }
        this.getGUI().refreshPlayersTable();
        return null;
    }

    private Element chat(Element element) {
        Game game = this.getGame();
        ChatMessage chatMessage = new ChatMessage(game, element);
        this.getGUI().displayChatMessage(chatMessage.getPlayer(game), chatMessage.getMessage(), chatMessage.isPrivate());
        return null;
    }

    private Element error(Element element) {
        this.getGUI().showErrorMessage(element.hasAttribute("messageID") ? element.getAttribute("messageID") : null, element.getAttribute("message"));
        return null;
    }

    private Element logout(Element element) {
        Game game = this.getFreeColClient().getGame();
        String playerId = element.getAttribute("player");
        String reason = element.getAttribute("reason");
        if (reason != null && !reason.isEmpty()) {
            logger.info("Client logging out: " + reason);
        }
        Player player = game.getFreeColGameObject(playerId, Player.class);
        game.removePlayer(player);
        this.getGUI().refreshPlayersTable();
        return null;
    }

    public Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        Element reply = null;
        for (int i = 0; i < nodes.getLength(); ++i) {
            reply = this.handle(connection, (Element)nodes.item(i));
        }
        return reply;
    }

    private Element playerReady(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = game.getFreeColGameObject(element.getAttribute("player"), Player.class);
        boolean ready = Boolean.parseBoolean(element.getAttribute("value"));
        player.setReady(ready);
        this.getGUI().refreshPlayersTable();
        return null;
    }

    private Element removePlayer(Element element) {
        Game game = this.getFreeColClient().getGame();
        Element playerElement = (Element)element.getElementsByTagName(Player.getXMLElementTagName()).item(0);
        Player player = new Player(game, playerElement);
        this.getFreeColClient().getGame().removePlayer(player);
        this.getGUI().refreshPlayersTable();
        return null;
    }

    private Element setAvailable(Element element) {
        Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("nation"));
        NationOptions.NationState state = Enum.valueOf(NationOptions.NationState.class, element.getAttribute("state"));
        this.getFreeColClient().getGame().getNationOptions().setNationState(nation, state);
        this.getGUI().refreshPlayersTable();
        return null;
    }

    private Element startGame(Element element) {
        new Thread("FreeColClient:Starting game"){

            @Override
            public void run() {
                while (PreGameInputHandler.this.getFreeColClient().getGame().getMap() == null) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
                SwingUtilities.invokeLater(() -> PreGameInputHandler.this.getFreeColClient().getPreGameController().startGame());
            }
        }.start();
        return null;
    }

    private Element updateColor(Element element) {
        Color color;
        String str;
        Game game = this.getFreeColClient().getGame();
        Specification spec = game.getSpecification();
        Nation nation = spec.getNation(str = element.getAttribute("nation"));
        if (nation == null) {
            logger.warning("Invalid nation: " + str);
            return null;
        }
        try {
            str = element.getAttribute("color");
            int rgb = Integer.parseInt(str);
            color = new Color(rgb);
        }
        catch (NumberFormatException nfe) {
            logger.warning("Invalid color: " + str);
            return null;
        }
        nation.setColor(color);
        this.getFreeColClient().getGUI().refreshPlayersTable();
        return null;
    }

    private Element updateGame(Element element) {
        NodeList children = element.getChildNodes();
        if (children.getLength() == 1) {
            FreeColClient fcc = this.getFreeColClient();
            Game game = fcc.getGame();
            game.readFromXMLElement((Element)children.item(0));
            fcc.addSpecificationActions(game.getSpecification());
        } else {
            logger.warning("Child node expected: " + element.getTagName());
        }
        return null;
    }

    private Element updateGameOptions(Element element) {
        Game game = this.getFreeColClient().getGame();
        Element mgoElement = (Element)element.getElementsByTagName(GameOptions.getXMLElementTagName()).item(0);
        Specification spec = game.getSpecification();
        OptionGroup gameOptions = spec.getGameOptions();
        gameOptions.readFromXMLElement(mgoElement);
        spec.clean("update game options (server initiated)");
        this.getGUI().updateGameOptions();
        return null;
    }

    private Element updateMapGeneratorOptions(Element element) {
        Element mgoElement = (Element)element.getElementsByTagName(MapGeneratorOptions.getXMLElementTagName()).item(0);
        this.getFreeColClient().getGame().getMapGeneratorOptions().readFromXMLElement(mgoElement);
        this.getGUI().updateMapGeneratorOptions();
        return null;
    }

    private Element updateNation(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = game.getFreeColGameObject(element.getAttribute("player"), Player.class);
        Nation nation = this.getGame().getSpecification().getNation(element.getAttribute("value"));
        player.setNation(nation);
        this.getGUI().refreshPlayersTable();
        return null;
    }

    private Element updateNationType(Element element) {
        Game game = this.getFreeColClient().getGame();
        Player player = game.getFreeColGameObject(element.getAttribute("player"), Player.class);
        NationType nationType = this.getGame().getSpecification().getNationType(element.getAttribute("value"));
        player.changeNationType(nationType);
        this.getGUI().refreshPlayersTable();
        return null;
    }
}

