/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.util;

import java.util.StringTokenizer;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.internal.ui.util.StringMatcher;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TypeFilter
implements IPropertyChangeListener {
    private IDLTKUILanguageToolkit fToolkit;
    private StringMatcher[] fStringMatchers;

    public TypeFilter(IDLTKUILanguageToolkit toolkit) {
        this.fToolkit = toolkit;
    }

    public boolean isFiltered(String fullTypeName) {
        return this.filter(fullTypeName);
    }

    public boolean isFiltered(char[] fullTypeName) {
        return this.filter(new String(fullTypeName));
    }

    protected String concatenate(char[] packageName, char[] typeName) {
        return String.valueOf(new String(packageName)) + " " + new String(typeName);
    }

    public boolean isFiltered(char[] packageName, char[] typeName) {
        return this.filter(this.concatenate(packageName, typeName));
    }

    public boolean isFiltered(IType type) {
        if (this.hasFilters()) {
            return this.filter(ScriptModelUtil.getFullyQualifiedName((IType)type));
        }
        return false;
    }

    public boolean isFiltered(TypeNameMatch match) {
        return this.filter(match.getFullyQualifiedName());
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fToolkit.getPreferenceStore();
    }

    public TypeFilter() {
        this.fStringMatchers = null;
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private synchronized StringMatcher[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String str = this.getPreferenceStore().getString("org.eclipse.dltk.ui.typefilter.enabled");
            StringTokenizer tok = new StringTokenizer(str, ";");
            int nTokens = tok.countTokens();
            this.fStringMatchers = new StringMatcher[nTokens];
            int i = 0;
            while (i < nTokens) {
                String curr = tok.nextToken();
                if (curr.length() > 0) {
                    this.fStringMatchers[i] = new StringMatcher(curr, false, false);
                }
                ++i;
            }
        }
        return this.fStringMatchers;
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStringMatchers = null;
    }

    public boolean hasFilters() {
        return this.getStringMatchers().length > 0;
    }

    public boolean filter(String fullTypeName) {
        StringMatcher[] matchers = this.getStringMatchers();
        int i = 0;
        while (i < matchers.length) {
            StringMatcher curr = matchers[i];
            if (curr.match(fullTypeName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.dltk.ui.typefilter.enabled".equals(event.getProperty())) {
            this.fStringMatchers = null;
        }
    }
}

