/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.ImportRootProjectException;
import org.eclipse.buildship.core.internal.UnsupportedConfigurationException;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.core.internal.workspace.WorkspaceOperations;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public final class ImportRootProjectOperation {
    private final BuildConfiguration buildConfiguration;
    private final NewProjectHandler newProjectHandler;

    public ImportRootProjectOperation(BuildConfiguration buildConfiguration, NewProjectHandler newProjectHandler) {
        this.buildConfiguration = (BuildConfiguration)Preconditions.checkNotNull((Object)buildConfiguration);
        this.newProjectHandler = (NewProjectHandler)Preconditions.checkNotNull((Object)newProjectHandler);
    }

    public void run(IProgressMonitor monitor) {
        try {
            this.runInWorkspace(monitor);
        }
        catch (Exception e) {
            throw e instanceof OperationCanceledException ? (OperationCanceledException)e : new ImportRootProjectException(e);
        }
    }

    private void runInWorkspace(IProgressMonitor monitor) throws CoreException {
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                progress.setTaskName("Importing root project");
                progress.setWorkRemaining(3);
                File rootDir = ImportRootProjectOperation.this.buildConfiguration.getRootProjectDirectory();
                ImportRootProjectOperation.this.verifyNoWorkspaceRootIsImported(rootDir, (IProgressMonitor)progress.newChild(1));
                ImportRootProjectOperation.this.saveProjectConfiguration(ImportRootProjectOperation.this.buildConfiguration, rootDir, (IProgressMonitor)progress.newChild(1));
                ImportRootProjectOperation.this.importRootProject(rootDir, (IProgressMonitor)progress.newChild(1));
            }
        }, monitor);
    }

    private void verifyNoWorkspaceRootIsImported(File rootDir, IProgressMonitor monitor) {
        File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        if (rootDir.equals(workspaceRoot)) {
            throw new UnsupportedConfigurationException(String.format("Project %s location matches workspace root %s", rootDir.getName(), workspaceRoot.getAbsolutePath()));
        }
    }

    private void saveProjectConfiguration(BuildConfiguration buildConfiguration, File rootDir, IProgressMonitor monitor) {
        ProjectConfiguration projectConfiguration = CorePlugin.configurationManager().createProjectConfiguration(buildConfiguration, rootDir);
        CorePlugin.configurationManager().saveProjectConfiguration(projectConfiguration);
    }

    private void importRootProject(File rootDir, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(3);
        WorkspaceOperations workspaceOperations = CorePlugin.workspaceOperations();
        Optional projectOrNull = workspaceOperations.findProjectByLocation(rootDir);
        if (!projectOrNull.isPresent() && this.newProjectHandler.shouldImportNewProjects()) {
            String projectName = this.findFreeProjectName(rootDir.getName());
            projectOrNull = Optional.of((Object)workspaceOperations.createProject(projectName, rootDir, (List<String>)ImmutableList.of(), (IProgressMonitor)progress.newChild(1)));
        }
        if (projectOrNull.isPresent()) {
            IProject project = (IProject)projectOrNull.get();
            project.refreshLocal(2, (IProgressMonitor)progress.newChild(1));
            CorePlugin.workspaceOperations().addNature(project, "org.eclipse.buildship.core.gradleprojectnature", (IProgressMonitor)progress.newChild(1));
            this.newProjectHandler.afterProjectImported(project);
            progress.worked(1);
        }
    }

    private String findFreeProjectName(String baseName) {
        Optional<IProject> workspaceProject = CorePlugin.workspaceOperations().findProjectByName(baseName);
        return workspaceProject.isPresent() ? this.findFreeProjectName(baseName + "_") : baseName;
    }
}

