/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class SystemClearPasswordAction
extends SystemBaseAction {
    public SystemClearPasswordAction(Shell shell) {
        super(SystemResources.ACTION_CLEARPASSWORD_LABEL, SystemResources.ACTION_CLEARPASSWORD_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
        this.setHelp("org.eclipse.rse.ui.actn0049");
    }

    public boolean checkObjectType(Object obj) {
        boolean result = false;
        if (obj instanceof ISubSystem) {
            ISubSystem subsystem = (ISubSystem)obj;
            IConnectorService cs = subsystem.getConnectorService();
            result = !cs.isConnected() && cs.hasPassword(true);
        }
        return result;
    }

    public void run() {
        ISubSystem ss = (ISubSystem)this.getFirstSelection();
        try {
            IConnectorService system = ss.getConnectorService();
            system.clearPassword(true, true);
            RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)ss, 86, (Object)ss.getHost()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

