/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.text.Collator;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.ToStringUtils;

public class RangeQuery
extends Query {
    private Term lowerTerm;
    private Term upperTerm;
    private boolean inclusive;
    private Collator collator;

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive) {
        if (lowerTerm == null && upperTerm == null) {
            throw new IllegalArgumentException("At least one term must be non-null");
        }
        if (lowerTerm != null && upperTerm != null && lowerTerm.field() != upperTerm.field()) {
            throw new IllegalArgumentException("Both terms must be for the same field");
        }
        this.lowerTerm = lowerTerm != null ? lowerTerm : new Term(upperTerm.field());
        this.upperTerm = upperTerm;
        this.inclusive = inclusive;
    }

    public RangeQuery(Term lowerTerm, Term upperTerm, boolean inclusive, Collator collator) {
        this(lowerTerm, upperTerm, inclusive);
        this.collator = collator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Query rewrite(IndexReader reader) throws IOException {
        query = new BooleanQuery(true);
        testField = this.getField();
        if (this.collator != null) {
            enumerator = reader.terms(new Term(testField, ""));
            lowerTermText = this.lowerTerm != null ? this.lowerTerm.text() : null;
            upperTermText = this.upperTerm != null ? this.upperTerm.text() : null;
            try {
                do {
                    if ((term = enumerator.term()) == null || term.field() != testField || lowerTermText != null && !(this.inclusive != false ? this.collator.compare(term.text(), lowerTermText) >= 0 : this.collator.compare(term.text(), lowerTermText) > 0) || upperTermText != null && !(this.inclusive != false ? this.collator.compare(term.text(), upperTermText) <= 0 : this.collator.compare(term.text(), upperTermText) < 0)) continue;
                    this.addTermToQuery(term, query);
                } while (enumerator.next());
                return query;
            }
            finally {
                enumerator.close();
            }
        }
        enumerator = reader.terms(this.lowerTerm);
        try {
            checkLower = false;
            if (!this.inclusive) {
                checkLower = true;
            }
            while ((term = enumerator.term()) != null && term.field() == testField) {
                if (checkLower && term.text().compareTo(this.lowerTerm.text()) <= 0) ** GOTO lbl30
                checkLower = false;
                if (this.upperTerm == null) ** GOTO lbl-1000
                compare = this.upperTerm.text().compareTo(term.text());
                if (compare < 0) return query;
                if (!this.inclusive && compare == 0) {
                    return query;
                } else lbl-1000:
                // 2 sources

                {
                    this.addTermToQuery(term, query);
lbl30:
                    // 2 sources

                    if (enumerator.next()) continue;
                }
                return query;
            }
            return query;
        }
        finally {
            enumerator.close();
        }
    }

    private void addTermToQuery(Term term, BooleanQuery query) {
        TermQuery tq = new TermQuery(term);
        tq.setBoost(this.getBoost());
        query.add(tq, BooleanClause.Occur.SHOULD);
    }

    public String getField() {
        return this.lowerTerm != null ? this.lowerTerm.field() : this.upperTerm.field();
    }

    public Term getLowerTerm() {
        return this.lowerTerm;
    }

    public Term getUpperTerm() {
        return this.upperTerm;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public Collator getCollator() {
        return this.collator;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.getField().equals(field)) {
            buffer.append(this.getField());
            buffer.append(":");
        }
        buffer.append(this.inclusive ? "[" : "{");
        buffer.append(this.lowerTerm != null ? this.lowerTerm.text() : "null");
        buffer.append(" TO ");
        buffer.append(this.upperTerm != null ? this.upperTerm.text() : "null");
        buffer.append(this.inclusive ? "]" : "}");
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RangeQuery)) {
            return false;
        }
        RangeQuery other = (RangeQuery)o;
        if (this.getBoost() != other.getBoost()) {
            return false;
        }
        if (this.inclusive != other.inclusive) {
            return false;
        }
        if (this.collator != null && !this.collator.equals(other.collator)) {
            return false;
        }
        if (this.lowerTerm != null ? !this.lowerTerm.equals(other.lowerTerm) : other.lowerTerm != null) {
            return false;
        }
        return !(this.upperTerm != null ? !this.upperTerm.equals(other.upperTerm) : other.upperTerm != null);
    }

    public int hashCode() {
        int h = Float.floatToIntBits(this.getBoost());
        h ^= this.lowerTerm != null ? this.lowerTerm.hashCode() : 0;
        h ^= h << 25 | h >>> 8;
        h ^= this.upperTerm != null ? this.upperTerm.hashCode() : 0;
        h ^= this.inclusive ? 658696010 : 0;
        return h ^= this.collator != null ? this.collator.hashCode() : 0;
    }
}

