/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.gis.panel;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.gis.DBGeometry;
import org.jkiss.dbeaver.model.gis.GisAttribute;
import org.jkiss.dbeaver.model.gis.GisTransformRequest;
import org.jkiss.dbeaver.model.gis.GisTransformUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.css.CSSUtils;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.gis.internal.GISViewerActivator;
import org.jkiss.dbeaver.ui.gis.panel.GISBrowserViewerConstants;
import org.jkiss.dbeaver.ui.gis.panel.SelectCRSDialog;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class GISLeafletViewer {
    private static final Log log = Log.getLog(GISLeafletViewer.class);
    private final IValueController valueController;
    private final Browser browser;
    private DBGeometry[] lastValue;
    private int sourceSRID;
    private int actualSourceSRID;
    private File scriptFile;
    private final ToolBarManager toolBarManager;
    private int defaultSRID;
    private boolean toolsVisible = true;
    private final Composite composite;

    public GISLeafletViewer(Composite parent, IValueController valueController) {
        this.valueController = valueController;
        this.composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        CSSUtils.setCSSClass((Widget)this.composite, (String)"coloredByConnectionType");
        this.browser = new Browser(this.composite, 0);
        this.browser.addDisposeListener(e -> this.cleanupFiles());
        this.browser.setLayoutData((Object)new GridData(1808));
        Composite bottomPanel = UIUtils.createPlaceholder((Composite)this.composite, (int)1);
        bottomPanel.setLayoutData((Object)new GridData(768));
        CSSUtils.setCSSClass((Widget)bottomPanel, (String)"coloredByConnectionType");
        ToolBar bottomToolbar = new ToolBar(bottomPanel, 8519936);
        this.toolBarManager = new ToolBarManager(bottomToolbar);
    }

    private void setSourceSRID(int srid) {
        if (srid == this.sourceSRID) {
            return;
        }
        int oldSRID = this.sourceSRID;
        this.sourceSRID = srid;
        try {
            this.reloadGeometryData(this.lastValue, true);
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Setting SRID", "Can't change source SRID to " + srid, (Throwable)e);
            this.sourceSRID = oldSRID;
        }
    }

    public void setGeometryData(@Nullable DBGeometry[] values) throws DBException {
        this.reloadGeometryData(values, false);
    }

    public void reloadGeometryData(@Nullable DBGeometry[] values, boolean force) throws DBException {
        if (!force && CommonUtils.equalObjects((Object)this.lastValue, (Object)values)) {
            return;
        }
        if (this.browser != null) {
            try {
                if (ArrayUtils.isEmpty((Object[])values)) {
                    this.browser.setUrl("about:blank");
                } else {
                    File file = this.generateViewScript(values);
                    this.browser.setUrl(file.toURI().toURL().toString());
                }
            }
            catch (IOException e) {
                throw new DBException("Error generating viewer script", (Throwable)e);
            }
        }
        this.lastValue = values;
        this.updateToolbar();
    }

    private File generateViewScript(DBGeometry[] values) throws IOException {
        if (this.scriptFile == null) {
            File tempDir = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "gis-viewer-files");
            this.checkIncludesExistence(tempDir);
            this.scriptFile = File.createTempFile("view", "gis.html", tempDir);
        }
        int baseSRID = 0;
        CharSequence[] geomValues = new String[values.length];
        CharSequence[] geomTipValues = new String[values.length];
        boolean showMap = false;
        int i = 0;
        while (i < values.length) {
            int srid;
            DBGeometry value = values[i];
            Object targetValue = value.getRawValue();
            int n = srid = this.sourceSRID == 0 ? value.getSRID() : this.sourceSRID;
            if (srid == 0) {
                srid = 4326;
            }
            if (srid == 4326) {
                showMap = true;
            } else {
                Geometry geometry = value.getGeometry();
                if (geometry != null) {
                    try {
                        GisTransformRequest request = new GisTransformRequest(geometry, srid, 4326);
                        GisTransformUtils.transformGisData((GisTransformRequest)request);
                        targetValue = request.getTargetValue();
                        srid = request.getTargetSRID();
                        this.actualSourceSRID = request.getSourceSRID();
                        showMap = request.isShowOnMap();
                    }
                    catch (DBException e) {
                        log.debug((Object)"Error transforming CRS", (Throwable)e);
                        showMap = false;
                    }
                }
            }
            if (this.actualSourceSRID == 0) {
                this.actualSourceSRID = 4326;
            }
            if (baseSRID == 0) {
                baseSRID = srid;
            }
            if (targetValue != null) {
                geomValues[i] = "'" + targetValue + "'";
                if (CommonUtils.isEmpty((Map)value.getProperties())) {
                    geomTipValues[i] = "null";
                } else {
                    StringBuilder geomProps = new StringBuilder("{");
                    boolean first = true;
                    for (Map.Entry prop : value.getProperties().entrySet()) {
                        if (!first) {
                            geomProps.append(",");
                        }
                        first = false;
                        geomProps.append('\"').append(((String)prop.getKey()).replace("\"", "\\\"")).append("\":\"").append(DBValueFormatting.getDefaultValueDisplayString(prop.getValue(), (DBDDisplayFormat)DBDDisplayFormat.UI).replace("\"", "\\\"")).append("\"");
                    }
                    geomProps.append("}");
                    geomTipValues[i] = geomProps.toString();
                }
            }
            ++i;
        }
        if (baseSRID == 0 && this.valueController != null && this.valueController.getValueType() instanceof GisAttribute) {
            try {
                baseSRID = ((GisAttribute)this.valueController.getValueType()).getAttributeGeometrySRID((DBRProgressMonitor)new VoidProgressMonitor());
            }
            catch (DBCException e) {
                log.error((Object)e);
            }
        }
        if (baseSRID == 0) {
            baseSRID = 4326;
        }
        this.defaultSRID = baseSRID;
        String geomValuesString = String.join((CharSequence)",", geomValues);
        String geomTipValuesString = String.join((CharSequence)",", geomTipValues);
        boolean isShowMap = showMap;
        InputStream fis = GISViewerActivator.getDefault().getResourceStream("web/view_template.html");
        if (fis == null) {
            throw new IOException("View template file not found (web/view_template.html)");
        }
        try {
            Throwable throwable = null;
            Object var11_20 = null;
            try (InputStreamReader isr = new InputStreamReader(fis);){
                String viewTemplate = IOUtils.readToString((Reader)isr);
                viewTemplate = GeneralUtils.replaceVariables((String)viewTemplate, name -> {
                    if (name.equals("geomValues")) {
                        return geomValuesString;
                    }
                    if (name.equals("geomTipValues")) {
                        return String.valueOf(geomTipValuesString);
                    }
                    if (name.equals("geomSRID")) {
                        return String.valueOf(this.defaultSRID);
                    }
                    if (name.equals("showMap")) {
                        return String.valueOf(isShowMap);
                    }
                    if (name.equals("showTools")) {
                        return String.valueOf(this.toolsVisible);
                    }
                    return null;
                });
                Throwable throwable2 = null;
                Object var15_26 = null;
                try (FileOutputStream fos = new FileOutputStream(this.scriptFile);){
                    fos.write(viewTemplate.getBytes(GeneralUtils.UTF8_CHARSET));
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        finally {
            ContentUtils.close((Closeable)fis);
        }
        return this.scriptFile;
    }

    private void checkIncludesExistence(File scriptDir) throws IOException {
        File incFolder = new File(scriptDir, "inc");
        if (!incFolder.exists()) {
            if (!incFolder.mkdirs()) {
                throw new IOException("Can't create inc folder '" + incFolder.getAbsolutePath() + "'");
            }
            String[] stringArray = GISBrowserViewerConstants.INC_FILES;
            int n = GISBrowserViewerConstants.INC_FILES.length;
            int n2 = 0;
            while (n2 < n) {
                block18: {
                    String fileName = stringArray[n2];
                    InputStream fis = GISViewerActivator.getDefault().getResourceStream("web/inc/" + fileName);
                    if (fis != null) {
                        Throwable throwable = null;
                        Object var9_10 = null;
                        try (FileOutputStream fos = new FileOutputStream(new File(incFolder, fileName));){
                            try {
                                try {
                                    IOUtils.copyStream((InputStream)fis, (OutputStream)fos);
                                }
                                catch (Exception e) {
                                    log.warn((Object)("Error copying inc file " + fileName), (Throwable)e);
                                    ContentUtils.close((Closeable)fis);
                                    break block18;
                                }
                            }
                            catch (Throwable throwable2) {
                                ContentUtils.close((Closeable)fis);
                                throw throwable2;
                            }
                            ContentUtils.close((Closeable)fis);
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void cleanupFiles() {
        if (this.scriptFile != null && !this.scriptFile.delete()) {
            log.debug((Object)("Can't delete temp script file '" + this.scriptFile.getAbsolutePath() + "'"));
        }
    }

    public Composite getBrowserComposite() {
        return this.composite;
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public DBGeometry[] getCurrentValue() {
        return this.lastValue;
    }

    private int getCurrentSourceSRID() {
        return this.actualSourceSRID != 0 ? this.actualSourceSRID : (this.defaultSRID != 0 ? this.defaultSRID : 4326);
    }

    private void updateToolbar() {
        this.toolBarManager.removeAll();
        this.toolBarManager.add((IAction)new Action("Open in browser", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.BROWSER)){

            public void run() {
                UIUtils.launchProgram((String)GISLeafletViewer.this.scriptFile.getAbsolutePath());
            }
        });
        this.toolBarManager.add((IAction)new Action("Copy as picture", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE)){

            public void run() {
                Image image = new Image((Device)Display.getDefault(), GISLeafletViewer.this.browser.getBounds());
                GC gc = new GC((Drawable)image);
                try {
                    GISLeafletViewer.this.browser.print(gc);
                }
                finally {
                    gc.dispose();
                }
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{imageTransfer});
            }
        });
        this.toolBarManager.add((IAction)new Action("Save as picture", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PICTURE_SAVE)){

            public void run() {
            }
        });
        this.toolBarManager.add((IAction)new Action("Print", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PRINT)){

            public void run() {
                GC gc = new GC((Drawable)GISLeafletViewer.this.browser.getDisplay());
                try {
                    GISLeafletViewer.this.browser.execute("javascript:window.print();");
                }
                finally {
                    gc.dispose();
                }
            }
        });
        ChangeCRSAction crsSelectorAction = new ChangeCRSAction();
        this.toolBarManager.add((IContributionItem)ActionUtils.makeActionContribution((IAction)crsSelectorAction, (boolean)true));
        this.toolBarManager.add((IContributionItem)new Separator());
        this.toolBarManager.add((IAction)new Action("Show/Hide controls", 2){
            {
                this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.PALETTE));
            }

            public boolean isChecked() {
                return GISLeafletViewer.this.toolsVisible;
            }

            public void run() {
                GISLeafletViewer.this.toolsVisible = !GISLeafletViewer.this.toolsVisible;
                GISLeafletViewer.this.updateControlsVisibility();
                GISLeafletViewer.this.updateToolbar();
            }
        });
        this.toolBarManager.update(true);
    }

    private void updateControlsVisibility() {
        GC gc = new GC((Drawable)this.browser.getDisplay());
        try {
            this.browser.execute("javascript:showTools(" + this.toolsVisible + ");");
        }
        finally {
            gc.dispose();
        }
    }

    private class ChangeCRSAction
    extends Action
    implements IMenuCreator {
        private MenuManager menuManager;

        public ChangeCRSAction() {
            super("EPSG:" + GISLeafletViewer.this.getCurrentSourceSRID(), 4);
            this.setImageDescriptor(DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.CHART_LINE));
        }

        public void run() {
            SelectCRSDialog selectCRSDialog = new SelectCRSDialog(UIUtils.getActiveWorkbenchShell(), GISLeafletViewer.this.getCurrentSourceSRID());
            if (selectCRSDialog.open() == 0) {
                GISLeafletViewer.this.setSourceSRID(selectCRSDialog.getSelectedSRID());
            }
        }

        public IMenuCreator getMenuCreator() {
            return super.getMenuCreator();
        }

        public void dispose() {
            if (this.menuManager != null) {
                this.menuManager.dispose();
                this.menuManager = null;
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menuManager == null) {
                this.menuManager = new MenuManager();
                this.menuManager.add((IAction)new SetCRSAction(4326));
                this.menuManager.add((IAction)new Action("Other ..."){

                    public void run() {
                        ChangeCRSAction.this.run();
                    }
                });
            }
            return this.menuManager.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }

    private class SetCRSAction
    extends Action {
        private final int srid;

        public SetCRSAction(int srid) {
            super("EPSG:" + srid);
            this.srid = srid;
        }

        public void run() {
            GISLeafletViewer.this.setSourceSRID(this.srid);
        }
    }
}

