/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.virtual;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVTransformSettings;
import org.jkiss.utils.CommonUtils;

public class DBVEntityAttribute
implements DBSEntityAttribute {
    private final DBVEntity entity;
    private final DBVEntityAttribute parent;
    private final List<DBVEntityAttribute> children = new ArrayList<DBVEntityAttribute>();
    private String name;
    private String defaultValue;
    private String description;
    private DBVTransformSettings transformSettings;

    public DBVEntityAttribute(DBVEntity entity, DBVEntityAttribute parent, String name) {
        this.entity = entity;
        this.parent = parent;
        this.name = name;
    }

    public DBVEntityAttribute(DBVEntity entity, DBVEntityAttribute parent, DBVEntityAttribute copy) {
        this.entity = entity;
        this.parent = parent;
        this.name = copy.name;
        for (DBVEntityAttribute child : copy.children) {
            this.children.add(new DBVEntityAttribute(entity, this, child));
        }
    }

    @Override
    @NotNull
    public DBVEntity getParentObject() {
        return this.entity;
    }

    @NotNull
    public DBVEntity getEntity() {
        return this.entity;
    }

    @Nullable
    public DBVEntityAttribute getParent() {
        return this.parent;
    }

    @Override
    @NotNull
    public DBPDataSource getDataSource() {
        return this.entity.getDataSource();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public String getTypeName() {
        return "void";
    }

    @Override
    public String getFullTypeName() {
        return this.getTypeName();
    }

    @Override
    public int getTypeID() {
        return -1;
    }

    @Override
    public DBPDataKind getDataKind() {
        return DBPDataKind.UNKNOWN;
    }

    @Override
    public Integer getScale() {
        return -1;
    }

    @Override
    public Integer getPrecision() {
        return -1;
    }

    @Override
    public long getMaxLength() {
        return -1L;
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public int getOrdinalPosition() {
        return 0;
    }

    @Override
    public boolean isRequired() {
        return false;
    }

    @Override
    public boolean isAutoGenerated() {
        return false;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<DBVEntityAttribute> getChildren() {
        return this.children;
    }

    public DBVEntityAttribute getChild(String name) {
        return DBUtils.findObject(this.children, name);
    }

    public void addChild(DBVEntityAttribute child) {
        this.children.add(child);
    }

    public DBVTransformSettings getTransformSettings() {
        return this.transformSettings;
    }

    public void setTransformSettings(DBVTransformSettings transformSettings) {
        this.transformSettings = transformSettings;
    }

    public boolean hasValuableData() {
        if (!CommonUtils.isEmpty((String)this.defaultValue) || !CommonUtils.isEmpty((String)this.description)) {
            return true;
        }
        if (!this.children.isEmpty()) {
            for (DBVEntityAttribute child : this.children) {
                if (!child.hasValuableData()) continue;
                return true;
            }
        }
        return this.transformSettings != null && this.transformSettings.hasValuableData();
    }
}

