/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerDatabase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerProcedure;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSchema;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerSynonym;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTable;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableBase;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableCheckConstraint;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableForeignKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableUniqueKey;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerView;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum SQLServerObjectType implements DBSObjectType
{
    AF("AF", null, "Aggregate function (CLR)"),
    C("C", SQLServerTableCheckConstraint.class, "CHECK constraint"),
    D("D", null, "DEFAULT (constraint or stand-alone)"),
    F("F", SQLServerTableForeignKey.class, "FOREIGN KEY constraint"),
    FN("FN", SQLServerProcedure.class, "SQL scalar function"),
    FS("FS", SQLServerProcedure.class, "Assembly (CLR) scalar-function"),
    FT("FT", SQLServerProcedure.class, "Assembly (CLR) table-valued function"),
    IF("IF", SQLServerProcedure.class, "SQL inline table-valued function"),
    IT("IT", SQLServerTable.class, "Internal table"),
    P("P", SQLServerProcedure.class, "SQL Stored Procedure"),
    PC("PC", SQLServerProcedure.class, "Assembly (CLR) stored-procedure"),
    PG("PG", null, "Plan guide"),
    PK("PK", SQLServerTableUniqueKey.class, "PRIMARY KEY constraint"),
    R("R", null, "Rule (old-style, stand-alone)"),
    RF("RF", null, "Replication-filter-procedure"),
    S("S", SQLServerTable.class, "System base table"),
    SN("SN", SQLServerSynonym.class, "Synonym"),
    SQ("SQ", null, "Service queue"),
    TA("TA", null, "Assembly (CLR) DML trigger"),
    TF("TF", SQLServerProcedure.class, "SQL table-valued-function"),
    TR("TR", SQLServerTableTrigger.class, "SQL DML trigger"),
    TT("TT", null, "Table type"),
    U("U", SQLServerTable.class, "Table (user-defined)"),
    UQ("UQ", SQLServerTableUniqueKey.class, "UNIQUE constraint"),
    V("V", SQLServerView.class, "View"),
    X("X", SQLServerProcedure.class, "Extended stored procedure");

    private final String type;
    private final String description;
    private final Class<? extends DBSObject> theClass;
    private static final Log log;

    static {
        log = Log.getLog(SQLServerObjectType.class);
    }

    private SQLServerObjectType(String type, Class<? extends DBSObject> theClass, String description) {
        this.type = type;
        this.theClass = theClass;
        this.description = description;
    }

    public String getTypeName() {
        return this.description;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getImage() {
        return null;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.theClass;
    }

    public String getTypeID() {
        return this.type;
    }

    public String toString() {
        return this.type;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, SQLServerDatabase database, SQLServerSchema schema, String objectName) throws DBException {
        if (schema == null) {
            log.debug((Object)("Null schema in table " + objectName + " search (" + this.name() + ")"));
            return null;
        }
        if (SQLServerTableBase.class.isAssignableFrom(this.theClass)) {
            return schema.getChild(monitor, objectName);
        }
        if (SQLServerProcedure.class.isAssignableFrom(this.theClass)) {
            return schema.getProcedure(monitor, objectName);
        }
        log.debug((Object)("Unsupported object for SQL Server search: " + this.name()));
        return null;
    }
}

