/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.convert.impl;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLSyntaxManager;
import org.jkiss.dbeaver.ui.editors.sql.convert.ISQLTextConverter;
import org.jkiss.dbeaver.ui.editors.sql.syntax.SQLRuleManager;
import org.jkiss.dbeaver.ui.editors.sql.syntax.tokens.SQLCommentToken;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.Pair;

public class UnformattedSQLConverter
implements ISQLTextConverter {
    private static final Log log = Log.getLog(UnformattedSQLConverter.class);

    @Override
    @NotNull
    public String convertText(@NotNull SQLDialect dialect, @NotNull SQLSyntaxManager syntaxManager, @NotNull SQLRuleManager ruleManager, @NotNull IDocument document, int startPos, int length, @NotNull Map<String, Object> options) {
        StringBuilder result = new StringBuilder();
        ruleManager.setRange(document, startPos, length);
        String[] singleLineComments = dialect.getSingleLineComments();
        Pair multiLineComments = dialect.getMultiLineComments();
        boolean lastWhitespace = false;
        try {
            IToken token;
            while (!(token = ruleManager.nextToken()).isEOF()) {
                int tokenOffset = ruleManager.getTokenOffset();
                int tokenLength = ruleManager.getTokenLength();
                if (token.isWhitespace()) {
                    if (!lastWhitespace) {
                        result.append(' ');
                    }
                    lastWhitespace = true;
                    continue;
                }
                if (token instanceof SQLCommentToken) {
                    String comment = document.get(tokenOffset, tokenLength);
                    String[] stringArray = singleLineComments;
                    int n = singleLineComments.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String slc = stringArray[n2];
                        if (comment.startsWith(slc)) {
                            if (multiLineComments == null) break;
                            comment = String.valueOf((String)multiLineComments.getFirst()) + comment.substring(slc.length()) + (String)multiLineComments.getSecond();
                            break;
                        }
                        ++n2;
                    }
                    comment = CommonUtils.compactWhiteSpaces((String)comment);
                    result.append(comment);
                    continue;
                }
                lastWhitespace = false;
                result.append(document.get(tokenOffset, tokenLength));
            }
        }
        catch (BadLocationException e) {
            log.error((Object)"Error unformatting SQL", (Throwable)e);
        }
        return result.toString().trim();
    }
}

