/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.truth.Correspondence;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.Ordered;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import com.google.common.truth.SubjectUtils;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

public class MapSubject
extends Subject<MapSubject, Map<?, ?>> {
    private static final ValueTester<Object, Object> EQUALITY = new ValueTester<Object, Object>(){

        @Override
        public boolean test(@NullableDecl Object actualValue, @NullableDecl Object expectedValue) {
            return Objects.equal((Object)actualValue, (Object)expectedValue);
        }
    };
    private static final Function<ValueDifference<Object, Object>, String> VALUE_DIFFERENCE_FORMAT = new Function<ValueDifference<Object, Object>, String>(){

        public String apply(ValueDifference<Object, Object> values) {
            boolean includeTypes = String.valueOf(((ValueDifference)values).actual).equals(String.valueOf(((ValueDifference)values).expected));
            return Strings.lenientFormat((String)"(expected %s but got %s)", (Object[])new Object[]{includeTypes ? new TypedToStringWrapper(((ValueDifference)values).expected) : ((ValueDifference)values).expected, includeTypes ? new TypedToStringWrapper(((ValueDifference)values).actual) : ((ValueDifference)values).actual});
        }
    };
    private static final Ordered IN_ORDER = new Ordered(){

        @Override
        public void inOrder() {
        }
    };
    private static final Ordered ALREADY_FAILED = new Ordered(){

        @Override
        public void inOrder() {
        }
    };

    MapSubject(FailureMetadata metadata, @NullableDecl Map<?, ?> map) {
        super(metadata, map);
    }

    @Override
    public void isEqualTo(@NullableDecl Object other) {
        if (Objects.equal(this.actual(), (Object)other)) {
            return;
        }
        if (!(other instanceof Map)) {
            super.isEqualTo(other);
            return;
        }
        boolean mapEquals = this.containsExactlyEntriesInAnyOrder((Map)other, "is equal to");
        if (mapEquals) {
            this.failWithRawMessage("Not true that %s is equal to <%s>. It is equal according to the contract of Map.equals(Object), but this implementation returned false", this.actualAsString(), other);
        }
    }

    public void isEmpty() {
        if (!((Map)this.actual()).isEmpty()) {
            this.failWithActual(Fact.simpleFact("expected to be empty"), new Fact[0]);
        }
    }

    public void isNotEmpty() {
        if (((Map)this.actual()).isEmpty()) {
            this.failWithoutActual(Fact.simpleFact("expected not to be empty"), new Fact[0]);
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize (%s) must be >= 0", (int)expectedSize);
        this.check("size()", new Object[0]).that(((Map)this.actual()).size()).isEqualTo(expectedSize);
    }

    public void containsKey(@NullableDecl Object key) {
        this.check("keySet()", new Object[0]).that(((Map)this.actual()).keySet()).contains(key);
    }

    public void doesNotContainKey(@NullableDecl Object key) {
        this.check("keySet()", new Object[0]).that(((Map)this.actual()).keySet()).doesNotContain(key);
    }

    public void containsEntry(@NullableDecl Object key, @NullableDecl Object value) {
        Map.Entry entry = Maps.immutableEntry((Object)key, (Object)value);
        if (!((Map)this.actual()).entrySet().contains(entry)) {
            ArrayList keyList = Lists.newArrayList((Object[])new Object[]{key});
            ArrayList valueList = Lists.newArrayList((Object[])new Object[]{value});
            if (SubjectUtils.hasMatchingToStringPair(((Map)this.actual()).keySet(), keyList)) {
                this.failWithRawMessage("Not true that %s contains entry <%s (%s)>. However, it does contain keys <%s>.", this.actualAsString(), entry, SubjectUtils.objectToTypeName(entry), SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(((Map)this.actual()).keySet(), keyList)));
            } else if (SubjectUtils.hasMatchingToStringPair(((Map)this.actual()).values(), valueList)) {
                this.failWithRawMessage("Not true that %s contains entry <%s (%s)>. However, it does contain values <%s>.", this.actualAsString(), entry, SubjectUtils.objectToTypeName(entry), SubjectUtils.countDuplicatesAndAddTypeInfo(SubjectUtils.retainMatchingToString(((Map)this.actual()).values(), valueList)));
            } else if (((Map)this.actual()).containsKey(key)) {
                Object actualValue = ((Map)this.actual()).get(key);
                StandardSubjectBuilder check = this.check("get(%s)", key);
                if (value == null || actualValue == null) {
                    check = check.withMessage("key is present but with a different value");
                }
                check.that(actualValue).failEqualityCheckForEqualsWithoutDescription(value);
            } else if (((Map)this.actual()).containsValue(value)) {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry actualEntry : ((Map)this.actual()).entrySet()) {
                    if (!Objects.equal(actualEntry.getValue(), (Object)value)) continue;
                    keys.add(actualEntry.getKey());
                }
                this.failWithRawMessage("Not true that %s contains entry <%s>. However, the following keys are mapped to <%s>: %s", this.actualAsString(), entry, value, keys);
            } else {
                this.fail("contains entry", (Object)entry);
            }
        }
    }

    public void doesNotContainEntry(@NullableDecl Object key, @NullableDecl Object value) {
        this.checkNoNeedToDisplayBothValues("entrySet()", new Object[0]).that(((Map)this.actual()).entrySet()).doesNotContain(Maps.immutableEntry((Object)key, (Object)value));
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly() {
        return this.containsExactlyEntriesIn((Map<?, ?>)ImmutableMap.of());
    }

    @CanIgnoreReturnValue
    public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        return this.containsExactlyEntriesIn(MapSubject.accumulateMap(k0, v0, rest));
    }

    private static Map<Object, Object> accumulateMap(@NullableDecl Object k0, @NullableDecl Object v0, Object ... rest) {
        Preconditions.checkArgument((rest.length % 2 == 0 ? 1 : 0) != 0, (String)"There must be an equal number of key/value pairs (i.e., the number of key/value parameters (%s) must be even).", (int)(rest.length + 2));
        LinkedHashMap expectedMap = Maps.newLinkedHashMap();
        expectedMap.put(k0, v0);
        LinkedHashMultiset keys = LinkedHashMultiset.create();
        keys.add(k0);
        for (int i = 0; i < rest.length; i += 2) {
            Object key = rest[i];
            expectedMap.put(key, rest[i + 1]);
            keys.add(key);
        }
        Preconditions.checkArgument((keys.size() == expectedMap.size() ? 1 : 0) != 0, (String)"Duplicate keys (%s) cannot be passed to containsExactly().", (Object)keys);
        return expectedMap;
    }

    @CanIgnoreReturnValue
    public Ordered containsExactlyEntriesIn(Map<?, ?> expectedMap) {
        if (expectedMap.isEmpty()) {
            if (((Map)this.actual()).isEmpty()) {
                return IN_ORDER;
            }
            this.isEmpty();
            return ALREADY_FAILED;
        }
        boolean containsAnyOrder = this.containsExactlyEntriesInAnyOrder(expectedMap, "contains exactly");
        if (containsAnyOrder) {
            return new MapInOrder(expectedMap, "contains exactly these entries in order");
        }
        return ALREADY_FAILED;
    }

    @CanIgnoreReturnValue
    private boolean containsExactlyEntriesInAnyOrder(Map<?, ?> expectedMap, String failVerb) {
        MapDifference<?, Object, Object> diff = MapDifference.create((Map)this.actual(), expectedMap, EQUALITY);
        if (diff.isEmpty()) {
            return true;
        }
        this.failWithRawMessage("Not true that %s %s <%s>. It %s", this.actualAsString(), failVerb, expectedMap, diff.describe(VALUE_DIFFERENCE_FORMAT));
        return false;
    }

    private static final Map<Object, Object> addKeyTypes(Map<?, ?> in) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        for (Map.Entry<?, ?> entry : in.entrySet()) {
            out.put(new TypedToStringWrapper(entry.getKey()), entry.getValue());
        }
        return out;
    }

    public <A, E> UsingCorrespondence<A, E> comparingValuesUsing(Correspondence<A, E> correspondence) {
        return new UsingCorrespondence(correspondence);
    }

    public final class UsingCorrespondence<A, E> {
        private final Correspondence<A, E> correspondence;

        private UsingCorrespondence(Correspondence<A, E> correspondence) {
            this.correspondence = (Correspondence)Preconditions.checkNotNull(correspondence);
        }

        public void containsEntry(@NullableDecl Object expectedKey, @NullableDecl E expectedValue) {
            if (((Map)MapSubject.this.actual()).containsKey(expectedKey)) {
                A actualValue = this.getCastSubject().get(expectedKey);
                if (this.correspondence.compare(actualValue, expectedValue)) {
                    return;
                }
                String diff = this.correspondence.formatDiff(actualValue, expectedValue);
                if (diff != null) {
                    MapSubject.this.failWithRawMessage("Not true that %s contains an entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s> (diff: %s)", MapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, actualValue, diff);
                } else {
                    MapSubject.this.failWithRawMessage("Not true that %s contains an entry with key <%s> and a value that %s <%s>. However, it has a mapping from that key to <%s>", MapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, actualValue);
                }
            } else {
                LinkedHashSet keys = new LinkedHashSet();
                for (Map.Entry<?, A> actualEntry : this.getCastSubject().entrySet()) {
                    if (!this.correspondence.compare(actualEntry.getValue(), expectedValue)) continue;
                    keys.add(actualEntry.getKey());
                }
                if (!keys.isEmpty()) {
                    MapSubject.this.failWithRawMessage("Not true that %s contains an entry with key <%s> and a value that %s <%s>. However, the following keys are mapped to such values: <%s>", MapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue, keys);
                } else {
                    MapSubject.this.failWithRawMessage("Not true that %s contains an entry with key <%s> and a value that %s <%s>", MapSubject.this.actualAsString(), expectedKey, this.correspondence, expectedValue);
                }
            }
        }

        public void doesNotContainEntry(@NullableDecl Object excludedKey, @NullableDecl E excludedValue) {
            A actualValue;
            if (((Map)MapSubject.this.actual()).containsKey(excludedKey) && this.correspondence.compare(actualValue = this.getCastSubject().get(excludedKey), excludedValue)) {
                MapSubject.this.failWithRawMessage("Not true that %s does not contain an entry with key <%s> and a value that %s <%s>. It maps that key to <%s>", MapSubject.this.actualAsString(), excludedKey, this.correspondence, excludedValue, actualValue);
            }
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(@NullableDecl Object k0, @NullableDecl E v0, Object ... rest) {
            Map expectedMap = MapSubject.accumulateMap(k0, v0, rest);
            return this.containsExactlyEntriesIn(expectedMap);
        }

        @CanIgnoreReturnValue
        public <K, V extends E> Ordered containsExactlyEntriesIn(Map<K, V> expectedMap) {
            if (expectedMap.isEmpty()) {
                if (((Map)MapSubject.this.actual()).isEmpty()) {
                    return IN_ORDER;
                }
                MapSubject.this.isEmpty();
                return ALREADY_FAILED;
            }
            MapDifference<?, A, V> diff = MapDifference.create(this.getCastSubject(), expectedMap, new ValueTester<A, E>(){

                @Override
                public boolean test(A actualValue, E expectedValue) {
                    return UsingCorrespondence.this.correspondence.compare(actualValue, expectedValue);
                }
            });
            if (diff.isEmpty()) {
                return new MapInOrder(expectedMap, Strings.lenientFormat((String)"contains, in order, exactly one entry that has a key that is equal to and a value that %s the key and value of each entry of", (Object[])new Object[]{this.correspondence}));
            }
            MapSubject.this.failWithRawMessage("Not true that %s contains exactly one entry that has a key that is equal to and a value that %s the key and value of each entry of <%s>. It %s", MapSubject.this.actualAsString(), this.correspondence, expectedMap, diff.describe(this.valueDiffFormat()));
            return ALREADY_FAILED;
        }

        private final <V extends E> Function<ValueDifference<A, V>, String> valueDiffFormat() {
            return new Function<ValueDifference<A, V>, String>(){

                public String apply(ValueDifference<A, V> values) {
                    String diffString = UsingCorrespondence.this.correspondence.formatDiff(values.actual, values.expected);
                    if (diffString != null) {
                        return Strings.lenientFormat((String)"(expected %s but got %s, diff: %s)", (Object[])new Object[]{values.expected, values.actual, diffString});
                    }
                    return Strings.lenientFormat((String)"(expected %s but got %s)", (Object[])new Object[]{values.expected, values.actual});
                }
            };
        }

        private Map<?, A> getCastSubject() {
            return (Map)MapSubject.this.actual();
        }
    }

    private class MapInOrder
    implements Ordered {
        private final Map<?, ?> expectedMap;
        private final String failVerb;

        MapInOrder(Map<?, ?> expectedMap, String failVerb) {
            this.expectedMap = expectedMap;
            this.failVerb = failVerb;
        }

        @Override
        public void inOrder() {
            ArrayList expectedKeyOrder = Lists.newArrayList(this.expectedMap.keySet());
            ArrayList actualKeyOrder = Lists.newArrayList(((Map)MapSubject.this.actual()).keySet());
            if (!actualKeyOrder.equals(expectedKeyOrder)) {
                MapSubject.this.failWithRawMessage("Not true that %s %s <%s>", MapSubject.this.actualAsString(), this.failVerb, this.expectedMap);
            }
        }
    }

    private static class TypedToStringWrapper {
        private final Object delegate;

        TypedToStringWrapper(Object delegate) {
            this.delegate = delegate;
        }

        public boolean equals(Object other) {
            return Objects.equal((Object)this.delegate, (Object)other);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.delegate});
        }

        public String toString() {
            return Strings.lenientFormat((String)"%s (%s)", (Object[])new Object[]{this.delegate, SubjectUtils.objectToTypeName(this.delegate)});
        }
    }

    private static class ValueDifference<A, E> {
        private final A actual;
        private final E expected;

        ValueDifference(@NullableDecl A actual, @NullableDecl E expected) {
            this.actual = actual;
            this.expected = expected;
        }
    }

    private static class MapDifference<K, A, E> {
        private final Map<K, E> missing;
        private final Map<K, A> unexpected;
        private final Map<K, ValueDifference<A, E>> wrongValues;

        static <K, A, E> MapDifference<K, A, E> create(Map<? extends K, ? extends A> actual, Map<? extends K, ? extends E> expected, ValueTester<? super A, ? super E> valueTester) {
            LinkedHashMap<K, A> unexpected = new LinkedHashMap<K, A>(actual);
            LinkedHashMap<K, E> missing = new LinkedHashMap<K, E>();
            LinkedHashMap wrongValues = new LinkedHashMap();
            for (Map.Entry<K, E> expectedEntry : expected.entrySet()) {
                K expectedKey = expectedEntry.getKey();
                E expectedValue = expectedEntry.getValue();
                if (actual.containsKey(expectedKey)) {
                    Object actualValue = unexpected.remove(expectedKey);
                    if (valueTester.test(actualValue, expectedValue)) continue;
                    wrongValues.put(expectedKey, new ValueDifference(actualValue, expectedValue));
                    continue;
                }
                missing.put(expectedKey, expectedValue);
            }
            return new MapDifference(missing, unexpected, wrongValues);
        }

        private MapDifference(Map<K, E> missing, Map<K, A> unexpected, Map<K, ValueDifference<A, E>> wrongValues) {
            this.missing = missing;
            this.unexpected = unexpected;
            this.wrongValues = wrongValues;
        }

        boolean isEmpty() {
            return this.missing.isEmpty() && this.unexpected.isEmpty() && this.wrongValues.isEmpty();
        }

        String describe(Function<ValueDifference<A, E>, String> valueDiffFormat) {
            boolean includeKeyTypes = this.includeKeyTypes();
            StringBuilder description = new StringBuilder();
            if (!this.missing.isEmpty()) {
                description.append("is missing keys for the following entries: ").append(includeKeyTypes ? MapSubject.addKeyTypes(this.missing) : this.missing);
            }
            if (!this.unexpected.isEmpty()) {
                if (description.length() > 0) {
                    description.append(" and ");
                }
                description.append("has the following entries with unexpected keys: ").append(includeKeyTypes ? MapSubject.addKeyTypes(this.unexpected) : this.unexpected);
            }
            if (!this.wrongValues.isEmpty()) {
                if (description.length() > 0) {
                    description.append(" and ");
                }
                Map wrongValuesFormatted = Maps.transformValues(this.wrongValues, valueDiffFormat);
                description.append("has the following entries with matching keys but different values: ").append(includeKeyTypes ? MapSubject.addKeyTypes(wrongValuesFormatted) : wrongValuesFormatted);
            }
            return description.toString();
        }

        private boolean includeKeyTypes() {
            HashSet keys = Sets.newHashSet();
            keys.addAll(this.missing.keySet());
            keys.addAll(this.unexpected.keySet());
            keys.addAll(this.wrongValues.keySet());
            return SubjectUtils.hasMatchingToStringPair(keys, keys);
        }
    }

    private static interface ValueTester<A, E> {
        public boolean test(@NullableDecl A var1, @NullableDecl E var2);
    }
}

