/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ContributionInstaller;
import cc.arduino.contributions.packages.ui.ContributedPlatformTableCellEditor;
import cc.arduino.contributions.packages.ui.ContributedPlatformTableCellRenderer;
import cc.arduino.contributions.packages.ui.ContributionIndexTableModel;
import cc.arduino.contributions.packages.ui.DropdownAllCoresItem;
import cc.arduino.contributions.packages.ui.DropdownCoreOfCategoryItem;
import cc.arduino.contributions.packages.ui.DropdownUpdatableCoresItem;
import cc.arduino.contributions.ui.DropdownItem;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import cc.arduino.contributions.ui.InstallerJDialog;
import cc.arduino.contributions.ui.InstallerJDialogUncaughtExceptionHandler;
import cc.arduino.contributions.ui.InstallerTableCell;
import cc.arduino.utils.Progress;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.TableCellRenderer;
import processing.app.BaseNoGui;
import processing.app.I18n;

public class ContributionManagerUI
extends InstallerJDialog {
    private final ContributionInstaller installer;
    private Thread installerThread = null;

    protected FilteredAbstractTableModel createContribModel() {
        return new ContributionIndexTableModel();
    }

    private ContributionIndexTableModel getContribModel() {
        return (ContributionIndexTableModel)this.contribModel;
    }

    @Override
    protected TableCellRenderer createCellRenderer() {
        return new ContributedPlatformTableCellRenderer();
    }

    @Override
    protected InstallerTableCell createCellEditor() {
        return new ContributedPlatformTableCellEditor(){

            @Override
            protected void onInstall(ContributedPlatform selected, ContributedPlatform installed) {
                if (selected.isBuiltIn()) {
                    ContributionManagerUI.this.onRemovePressed(installed, false);
                } else {
                    ContributionManagerUI.this.onInstallPressed(selected, installed);
                }
            }

            @Override
            protected void onRemove(ContributedPlatform installedPlatform) {
                ContributionManagerUI.this.onRemovePressed(installedPlatform, true);
            }
        };
    }

    public ContributionManagerUI(Frame parent, ContributionInstaller installer) {
        super(parent, I18n.tr((String)"Boards Manager"), Dialog.ModalityType.APPLICATION_MODAL, I18n.tr((String)"Unable to reach Arduino.cc due to possible network issues."));
        this.installer = installer;
    }

    public void updateUI() {
        DropdownItem previouslySelectedCategory = (DropdownItem)this.categoryChooser.getSelectedItem();
        this.categoryChooser.removeActionListener(this.categoryChooserActionListener);
        this.filterField.setEnabled(this.getContribModel().getRowCount() > 0);
        this.categoryChooser.addActionListener(this.categoryChooserActionListener);
        this.categoryFilter = x -> true;
        this.categoryChooser.removeAllItems();
        this.categoryChooser.addItem(new DropdownAllCoresItem());
        this.categoryChooser.addItem(new DropdownUpdatableCoresItem());
        List categories = BaseNoGui.indexer.getCategories();
        for (String s : categories) {
            this.categoryChooser.addItem(new DropdownCoreOfCategoryItem(s));
        }
        if (previouslySelectedCategory != null) {
            this.categoryChooser.setSelectedItem(previouslySelectedCategory);
        } else {
            this.categoryChooser.setSelectedIndex(0);
        }
    }

    public void setProgress(Progress progress) {
        this.progressBar.setValue(progress);
    }

    @Override
    public void onCancelPressed() {
        super.onCancelPressed();
        if (this.installerThread != null) {
            this.installerThread.interrupt();
        }
    }

    @Override
    public void onUpdatePressed() {
        super.onUpdatePressed();
        this.installerThread = new Thread(() -> {
            try {
                this.setProgressVisible(true, "");
                List downloadedPackageIndexFiles = this.installer.updateIndex(this::setProgress);
                this.installer.deleteUnknownFiles(downloadedPackageIndexFiles);
                this.onIndexesUpdated();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setProgressVisible(false, "");
            }
        });
        this.installerThread.setName("ContributionManager Update Thread");
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onInstallPressed(ContributedPlatform platformToInstall, ContributedPlatform platformToRemove) {
        this.clearErrorMessage();
        this.installerThread = new Thread(() -> {
            LinkedList errors = new LinkedList();
            try {
                this.setProgressVisible(true, I18n.tr((String)"Installing..."));
                if (platformToRemove != null && !platformToRemove.isBuiltIn()) {
                    errors.addAll(this.installer.remove(platformToRemove));
                }
                errors.addAll(this.installer.install(platformToInstall, this::setProgress));
                this.onIndexesUpdated();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setProgressVisible(false, "");
                if (!errors.isEmpty()) {
                    this.setErrorMessage((String)errors.get(0));
                }
            }
        });
        this.installerThread.setName("ContributionManager Install Thread");
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    public void onRemovePressed(ContributedPlatform platform, boolean showWarning) {
        int chosenOption;
        this.clearErrorMessage();
        if (showWarning && (chosenOption = JOptionPane.showConfirmDialog(this, I18n.format((String)I18n.tr((String)"Do you want to remove {0}?\nIf you do so you won't be able to use {0} any more."), (Object[])new Object[]{platform.getName()}), I18n.tr((String)"Please confirm boards deletion"), 0, 3)) != 0) {
            return;
        }
        this.installerThread = new Thread(() -> {
            try {
                this.setProgressVisible(true, I18n.tr((String)"Removing..."));
                this.installer.remove(platform);
                this.onIndexesUpdated();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.setProgressVisible(false, "");
            }
        });
        this.installerThread.setName("ContributionManager Remove Thread");
        this.installerThread.setUncaughtExceptionHandler(new InstallerJDialogUncaughtExceptionHandler(this, this.noConnectionErrorMessage));
        this.installerThread.start();
    }

    protected void onIndexesUpdated() throws Exception {
    }
}

