/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac;

import com.sun.tools.sjavac.BuildState;
import com.sun.tools.sjavac.CompileJavaPackages;
import com.sun.tools.sjavac.CopyFile;
import com.sun.tools.sjavac.Log;
import com.sun.tools.sjavac.Module;
import com.sun.tools.sjavac.Package;
import com.sun.tools.sjavac.ProblemException;
import com.sun.tools.sjavac.PubApiExtractor;
import com.sun.tools.sjavac.Source;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.Util;
import com.sun.tools.sjavac.comp.CompilationService;
import com.sun.tools.sjavac.options.Options;
import com.sun.tools.sjavac.pubapi.PubApi;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.NoSuchFileException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class JavacState {
    String theArgs;
    int numCores;
    private File javacState;
    private BuildState prev;
    private BuildState now;
    private boolean needsSaving;
    private boolean newJavacState;
    private Set<String> taintedPackages;
    private Set<String> packagesWithChangedPublicApis;
    private Set<String> taintedModules;
    private Set<String> recompiledPackages;
    private File binDir;
    private File gensrcDir;
    private File headerDir;
    private File stateDir;
    private Set<File> binArtifacts;
    private Set<File> gensrcArtifacts;
    private Set<File> headerArtifacts;
    Set<Source> removedSources = null;
    Set<Source> addedSources = null;
    Set<Source> modifiedSources = null;
    Set<URI> visibleSrcs;
    private CompileJavaPackages compileJavaPackages = new CompileJavaPackages();
    private Options options;

    JavacState(Options op, boolean removeJavacState) {
        this.options = op;
        this.numCores = this.options.getNumCores();
        this.theArgs = this.options.getStateArgsString();
        this.binDir = Util.pathToFile(this.options.getDestDir());
        this.gensrcDir = Util.pathToFile(this.options.getGenSrcDir());
        this.headerDir = Util.pathToFile(this.options.getHeaderDir());
        this.stateDir = Util.pathToFile(this.options.getStateDir());
        this.javacState = new File(this.stateDir, "javac_state");
        if (removeJavacState && this.javacState.exists()) {
            this.javacState.delete();
        }
        this.newJavacState = false;
        if (!this.javacState.exists()) {
            this.newJavacState = true;
            if (!this.options.areUnidentifiedArtifactsPermitted()) {
                this.deleteContents(this.binDir);
                this.deleteContents(this.gensrcDir);
                this.deleteContents(this.headerDir);
            }
            this.needsSaving = true;
        }
        this.prev = new BuildState();
        this.now = new BuildState();
        this.taintedPackages = new HashSet<String>();
        this.recompiledPackages = new HashSet<String>();
        this.packagesWithChangedPublicApis = new HashSet<String>();
    }

    public BuildState prev() {
        return this.prev;
    }

    public BuildState now() {
        return this.now;
    }

    static String[] removeArgsNotAffectingState(String[] args) {
        String[] out = new String[args.length];
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-j")) {
                ++i;
                continue;
            }
            if (args[i].startsWith("--server:") || args[i].startsWith("--log=")) continue;
            if (args[i].equals("--compare-found-sources")) {
                ++i;
                continue;
            }
            out[j] = args[i];
            ++j;
        }
        String[] ret = new String[j];
        System.arraycopy(out, 0, ret, 0, j);
        return ret;
    }

    public void setVisibleSources(Map<String, Source> vs) {
        this.visibleSrcs = new HashSet<URI>();
        for (String s : vs.keySet()) {
            Source src = vs.get(s);
            this.visibleSrcs.add(src.file().toURI());
        }
    }

    public boolean isIncremental() {
        return !this.prev.sources().isEmpty();
    }

    public void findAllArtifacts() {
        this.binArtifacts = JavacState.findAllFiles(this.binDir);
        this.gensrcArtifacts = JavacState.findAllFiles(this.gensrcDir);
        this.headerArtifacts = JavacState.findAllFiles(this.headerDir);
    }

    private Map<String, File> fetchPrevArtifacts(String pkg) {
        Package p = this.prev.packages().get(pkg);
        if (p != null) {
            return p.artifacts();
        }
        return new HashMap<String, File>();
    }

    public void deleteClassArtifactsInTaintedPackages() {
        for (String pkg : this.taintedPackages) {
            Map<String, File> arts = this.fetchPrevArtifacts(pkg);
            for (File f : arts.values()) {
                if (!f.exists() || !f.getName().endsWith(".class")) continue;
                f.delete();
            }
        }
    }

    private void needsSaving() {
        this.needsSaving = true;
    }

    public void save() throws IOException {
        if (!this.needsSaving) {
            return;
        }
        try (FileWriter out = new FileWriter(this.javacState);){
            StringBuilder b = new StringBuilder();
            long millisNow = System.currentTimeMillis();
            Date d = new Date(millisNow);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS");
            b.append("# javac_state ver 0.4 generated " + millisNow + " " + df.format(d) + "\n");
            b.append("# This format might change at any time. Please do not depend on it.\n");
            b.append("# R arguments\n");
            b.append("# M module\n");
            b.append("# P package\n");
            b.append("# S C source_tobe_compiled timestamp\n");
            b.append("# S L link_only_source timestamp\n");
            b.append("# G C generated_source timestamp\n");
            b.append("# A artifact timestamp\n");
            b.append("# D S dependant -> source dependency\n");
            b.append("# D C dependant -> classpath dependency\n");
            b.append("# I pubapi\n");
            b.append("R ").append(this.theArgs).append("\n");
            this.now.copyPackagesExcept(this.prev, this.recompiledPackages, new HashSet<String>());
            Module.saveModules(this.now.modules(), b);
            String s = b.toString();
            out.write(s, 0, s.length());
        }
    }

    public static JavacState load(Options options) {
        JavacState db = new JavacState(options, false);
        Module lastModule = null;
        Package lastPackage = null;
        Source lastSource = null;
        boolean noFileFound = false;
        boolean foundCorrectVerNr = false;
        boolean newCommandLine = false;
        boolean syntaxError = false;
        Log.debug("Loading javac state file: " + db.javacState);
        try (BufferedReader in = new BufferedReader(new FileReader(db.javacState));){
            String l;
            while ((l = in.readLine()) != null) {
                int sp;
                if (l.length() < 3 || l.charAt(1) != ' ') continue;
                char c = l.charAt(0);
                if (c == 'M') {
                    lastModule = db.prev.loadModule(l);
                    continue;
                }
                if (c == 'P') {
                    if (lastModule == null) {
                        syntaxError = true;
                        break;
                    }
                    lastPackage = db.prev.loadPackage(lastModule, l);
                    continue;
                }
                if (c == 'D') {
                    if (lastModule == null || lastPackage == null) {
                        syntaxError = true;
                        break;
                    }
                    char depType = l.charAt(2);
                    if (depType != 'S' && depType != 'C') {
                        throw new RuntimeException("Bad dependency string: " + l);
                    }
                    lastPackage.parseAndAddDependency(l.substring(4), depType == 'C');
                    continue;
                }
                if (c == 'I') {
                    if (lastModule == null || lastPackage == null) {
                        syntaxError = true;
                        break;
                    }
                    lastPackage.getPubApi().appendItem(l.substring(2));
                    continue;
                }
                if (c == 'A') {
                    if (lastModule == null || lastPackage == null) {
                        syntaxError = true;
                        break;
                    }
                    lastPackage.loadArtifact(l);
                    continue;
                }
                if (c == 'S') {
                    if (lastModule == null || lastPackage == null) {
                        syntaxError = true;
                        break;
                    }
                    lastSource = db.prev.loadSource(lastPackage, l, false);
                    continue;
                }
                if (c == 'G') {
                    if (lastModule == null || lastPackage == null) {
                        syntaxError = true;
                        break;
                    }
                    lastSource = db.prev.loadSource(lastPackage, l, true);
                    continue;
                }
                if (c == 'R') {
                    String ncmdl = "R " + db.theArgs;
                    if (l.equals(ncmdl)) continue;
                    newCommandLine = true;
                    continue;
                }
                if (c != '#' || !l.startsWith("# javac_state ver ") || (sp = l.indexOf(" ", 18)) == -1) continue;
                String ver = l.substring(18, sp);
                if (!ver.equals("0.4")) {
                    break;
                }
                foundCorrectVerNr = true;
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            noFileFound = true;
        }
        catch (IOException e) {
            Log.warn("Dropping old javac_state because of errors when reading it.");
            db = new JavacState(options, true);
            foundCorrectVerNr = true;
            newCommandLine = false;
            syntaxError = false;
        }
        if (!foundCorrectVerNr && !noFileFound) {
            Log.debug("Dropping old javac_state since it is of an old version.");
            db = new JavacState(options, true);
        } else if (newCommandLine && !noFileFound) {
            Log.debug("Dropping old javac_state since a new command line is used!");
            db = new JavacState(options, true);
        } else if (syntaxError) {
            Log.warn("Dropping old javac_state since it contains syntax errors.");
            db = new JavacState(options, true);
        }
        db.prev.calculateDependents();
        return db;
    }

    public void taintPackage(String name, String because) {
        if (!this.taintedPackages.contains(name)) {
            if (because != null) {
                Log.debug("Tainting " + Util.justPackageName(name) + " because " + because);
            }
            this.taintedPackages.add(name);
            this.needsSaving();
            Package nowp = this.now.packages().get(name);
            if (nowp != null) {
                for (String d : nowp.dependents()) {
                    this.taintPackage(d, because);
                }
            }
        }
    }

    public Set<String> taintedPackages() {
        return this.taintedPackages;
    }

    public void clearTaintedPackages() {
        this.taintedPackages = new HashSet<String>();
    }

    public void checkSourceStatus(boolean check_gensrc) {
        this.removedSources = this.calculateRemovedSources();
        for (Source s : this.removedSources) {
            if (s.isGenerated() && !check_gensrc) continue;
            this.taintPackage(s.pkg().name(), "source " + s.name() + " was removed");
        }
        this.addedSources = this.calculateAddedSources();
        for (Source s : this.addedSources) {
            String msg = null;
            if (this.isIncremental()) {
                msg = "source " + s.name() + " was added";
            }
            if (s.isGenerated() && !check_gensrc) continue;
            this.taintPackage(s.pkg().name(), msg);
        }
        this.modifiedSources = this.calculateModifiedSources();
        for (Source s : this.modifiedSources) {
            if (s.isGenerated() && !check_gensrc) continue;
            this.taintPackage(s.pkg().name(), "source " + s.name() + " was modified");
        }
    }

    public Map<String, Transformer> getJavaSuffixRule() {
        HashMap<String, Transformer> sr = new HashMap<String, Transformer>();
        sr.put(".java", this.compileJavaPackages);
        return sr;
    }

    public void taintPackagesThatMissArtifacts() {
        for (Package pkg : this.prev.packages().values()) {
            for (File f : pkg.artifacts().values()) {
                if (f.exists()) continue;
                this.taintPackage(pkg.name(), f + " is missing.");
            }
        }
    }

    public void taintPackagesDependingOnChangedPackages(Set<String> pkgsWithChangedPubApi, Set<String> recentlyCompiled) {
        for (Package pkg : new HashSet<Package>(this.prev.packages().values())) {
            Set deps = pkg.typeDependencies().values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
            for (String dep : deps) {
                String depPkg = ":" + dep.substring(0, dep.lastIndexOf(46));
                if (depPkg.equals(pkg.name()) || !pkgsWithChangedPubApi.contains(depPkg) || recentlyCompiled.contains(pkg.name())) continue;
                this.taintPackage(pkg.name(), "its depending on " + depPkg);
            }
        }
    }

    public void taintPackagesDependingOnChangedClasspathPackages() throws IOException {
        HashSet fqDependencies = new HashSet();
        for (Package pkg : this.prev.packages().values()) {
            if (pkg.sources().isEmpty()) continue;
            pkg.typeClasspathDependencies().values().forEach(fqDependencies::addAll);
        }
        PubApiExtractor pubApiExtractor = new PubApiExtractor(this.options);
        HashMap<String, PubApi> onDiskPubApi = new HashMap<String, PubApi>();
        for (String cpDep : fqDependencies) {
            onDiskPubApi.put(cpDep, pubApiExtractor.getPubApi(cpDep));
        }
        pubApiExtractor.close();
        block2: for (Package pkg : this.prev.packages().values()) {
            if (pkg.sources().isEmpty()) continue;
            HashSet<String> cpDepsOfThisPkg = new HashSet<String>();
            for (Set<String> cpDeps : pkg.typeClasspathDependencies().values()) {
                cpDepsOfThisPkg.addAll(cpDeps);
            }
            for (String fqDep : cpDepsOfThisPkg) {
                String depPkg = ":" + fqDep.substring(0, fqDep.lastIndexOf(46));
                PubApi prevPkgApi = this.prev.packages().get(depPkg).getPubApi();
                PubApi currentDepApi = ((PubApi)onDiskPubApi.get((Object)fqDep)).types.get((Object)fqDep).pubApi;
                PubApi prevDepApi = prevPkgApi.types.get((Object)fqDep).pubApi;
                if (currentDepApi.isBackwardCompatibleWith(prevDepApi)) continue;
                List<String> apiDiff = currentDepApi.diff(prevDepApi);
                this.taintPackage(pkg.name(), "depends on classpath package which has an updated package api: " + String.join((CharSequence)"\n", apiDiff));
                continue block2;
            }
        }
    }

    public void removeUnidentifiedArtifacts() {
        HashSet<File> allKnownArtifacts = new HashSet<File>();
        for (Package pkg : this.prev.packages().values()) {
            for (File f : pkg.artifacts().values()) {
                allKnownArtifacts.add(f);
            }
        }
        allKnownArtifacts.add(this.javacState);
        for (File f : this.binArtifacts) {
            if (allKnownArtifacts.contains(f) || this.options.isUnidentifiedArtifactPermitted(f.getAbsolutePath())) continue;
            Log.debug("Removing " + f.getPath() + " since it is unknown to the javac_state.");
            f.delete();
        }
        for (File f : this.headerArtifacts) {
            if (allKnownArtifacts.contains(f)) continue;
            Log.debug("Removing " + f.getPath() + " since it is unknown to the javac_state.");
            f.delete();
        }
        for (File f : this.gensrcArtifacts) {
            if (allKnownArtifacts.contains(f)) continue;
            Log.debug("Removing " + f.getPath() + " since it is unknown to the javac_state.");
            f.delete();
        }
    }

    public void removeSuperfluousArtifacts(Set<String> recentlyCompiled) {
        if (recentlyCompiled.size() == 0) {
            return;
        }
        for (String pkg : this.now.packages().keySet()) {
            if (!recentlyCompiled.contains(pkg)) continue;
            Collection<File> arts = this.now.artifacts().values();
            for (File f : this.fetchPrevArtifacts(pkg).values()) {
                if (arts.contains(f)) continue;
                Log.debug("Removing " + f.getPath() + " since it is now superfluous!");
                if (!f.exists()) continue;
                f.delete();
            }
        }
    }

    private Set<Source> calculateRemovedSources() {
        HashSet<Source> removed = new HashSet<Source>();
        for (String src : this.prev.sources().keySet()) {
            if (this.now.sources().get(src) != null) continue;
            removed.add(this.prev.sources().get(src));
        }
        return removed;
    }

    private Set<Source> calculateAddedSources() {
        HashSet<Source> added = new HashSet<Source>();
        for (String src : this.now.sources().keySet()) {
            if (this.prev.sources().get(src) != null) continue;
            added.add(this.now.sources().get(src));
        }
        return added;
    }

    private Set<Source> calculateModifiedSources() {
        HashSet<Source> modified = new HashSet<Source>();
        for (String src : this.now.sources().keySet()) {
            Source n = this.now.sources().get(src);
            Source t = this.prev.sources().get(src);
            if (this.prev.sources().get(src) == null || t == null) continue;
            if (n.lastModified() > t.lastModified()) {
                modified.add(n);
                continue;
            }
            if (n.lastModified() >= t.lastModified()) continue;
            modified.add(n);
            Log.warn("The source file " + n.name() + " timestamp has moved backwards in time.");
        }
        return modified;
    }

    private void deleteContents(File dir) {
        if (dir != null && dir.exists()) {
            for (File f : dir.listFiles()) {
                if (f.isDirectory()) {
                    this.deleteContents(f);
                }
                if (this.options.isUnidentifiedArtifactPermitted(f.getAbsolutePath())) continue;
                Log.debug("Removing " + f.getAbsolutePath());
                f.delete();
            }
        }
    }

    public void performCopying(File binDir, Map<String, Transformer> suffixRules) {
        HashMap<String, Transformer> sr = new HashMap<String, Transformer>();
        for (Map.Entry<String, Transformer> e : suffixRules.entrySet()) {
            if (!e.getValue().getClass().equals(CopyFile.class)) continue;
            sr.put(e.getKey(), e.getValue());
        }
        this.perform(null, binDir, sr);
    }

    public void performTranslation(File gensrcDir, Map<String, Transformer> suffixRules) {
        HashMap<String, Transformer> sr = new HashMap<String, Transformer>();
        for (Map.Entry<String, Transformer> e : suffixRules.entrySet()) {
            Class<?> trClass = e.getValue().getClass();
            if (trClass == CompileJavaPackages.class || trClass == CopyFile.class) continue;
            sr.put(e.getKey(), e.getValue());
        }
        this.perform(null, gensrcDir, sr);
    }

    public boolean performJavaCompilations(CompilationService sjavac, Options args, Set<String> recentlyCompiled, boolean[] rcValue) {
        HashMap<String, Transformer> suffixRules = new HashMap<String, Transformer>();
        suffixRules.put(".java", this.compileJavaPackages);
        this.compileJavaPackages.setExtra(args);
        rcValue[0] = this.perform(sjavac, this.binDir, suffixRules);
        recentlyCompiled.addAll(this.taintedPackages());
        this.clearTaintedPackages();
        boolean again = !this.packagesWithChangedPublicApis.isEmpty();
        this.taintPackagesDependingOnChangedPackages(this.packagesWithChangedPublicApis, recentlyCompiled);
        this.packagesWithChangedPublicApis = new HashSet<String>();
        return again && rcValue[0];
    }

    private void addFileToTransform(Map<Transformer, Map<String, Set<URI>>> gs, Transformer t, Source s) {
        Set<URI> ss;
        Map<String, Set<URI>> fs = gs.get(t);
        if (fs == null) {
            fs = new HashMap<String, Set<URI>>();
            gs.put(t, fs);
        }
        if ((ss = fs.get(s.pkg().name())) == null) {
            ss = new HashSet<URI>();
            fs.put(s.pkg().name(), ss);
        }
        ss.add(s.file().toURI());
    }

    private boolean perform(CompilationService sjavac, File outputDir, Map<String, Transformer> suffixRules) {
        Transformer t;
        boolean rc = true;
        HashMap<Transformer, Map<String, Set<URI>>> groupedSources = new HashMap<Transformer, Map<String, Set<URI>>>();
        for (Source source : this.now.sources().values()) {
            t = suffixRules.get(source.suffix());
            if (t == null || !this.taintedPackages.contains(source.pkg().name()) || source.isLinkedOnly()) continue;
            this.addFileToTransform(groupedSources, t, source);
        }
        for (Map.Entry entry : groupedSources.entrySet()) {
            String pkg;
            Module mnow;
            Map deps;
            t = (Transformer)entry.getKey();
            Map srcs = (Map)entry.getValue();
            Map<String, Set<URI>> packageArtifacts = Collections.synchronizedMap(new HashMap());
            Map<String, Map<String, Set<String>>> packageDependencies = Collections.synchronizedMap(new HashMap());
            Map<String, Map<String, Set<String>>> packageCpDependencies = Collections.synchronizedMap(new HashMap());
            Map<String, PubApi> packagePublicApis = Collections.synchronizedMap(new HashMap());
            Map<String, PubApi> dependencyPublicApis = Collections.synchronizedMap(new HashMap());
            boolean r = t.transform(sjavac, srcs, this.visibleSrcs, this.prev.dependents(), outputDir.toURI(), packageArtifacts, packageDependencies, packageCpDependencies, packagePublicApis, dependencyPublicApis, 0, this.isIncremental(), this.numCores);
            if (!r) {
                rc = false;
            }
            for (String string : srcs.keySet()) {
                this.recompiledPackages.add(string);
            }
            for (Map.Entry entry2 : packageArtifacts.entrySet()) {
                Module mnow2 = this.now.findModuleFromPackageName((String)entry2.getKey());
                mnow2.addArtifacts((String)entry2.getKey(), (Set)entry2.getValue());
            }
            for (Map.Entry entry3 : packageDependencies.entrySet()) {
                deps = (Map)entry3.getValue();
                mnow = this.now.findModuleFromPackageName((String)entry3.getKey());
                mnow.setDependencies((String)entry3.getKey(), deps, false);
            }
            for (Map.Entry entry4 : packageCpDependencies.entrySet()) {
                deps = (Map)entry4.getValue();
                mnow = this.now.findModuleFromPackageName((String)entry4.getKey());
                mnow.setDependencies((String)entry4.getKey(), deps, true);
            }
            for (Map.Entry entry5 : dependencyPublicApis.entrySet()) {
                pkg = (String)entry5.getKey();
                PubApi packagePartialPubApi = (PubApi)entry5.getValue();
                Package pkgNow = this.now.findModuleFromPackageName(pkg).lookupPackage(pkg);
                PubApi currentPubApi = pkgNow.getPubApi();
                PubApi newPubApi = PubApi.mergeTypes(currentPubApi, packagePartialPubApi);
                pkgNow.setPubapi(newPubApi);
                if (this.now.packages().containsKey(pkg)) {
                    this.now.packages().get(pkg).setPubapi(newPubApi);
                    continue;
                }
                this.now.packages().put(pkg, pkgNow);
            }
            for (Map.Entry entry6 : packagePublicApis.entrySet()) {
                pkg = (String)entry6.getKey();
                PubApi newPubApi = (PubApi)entry6.getValue();
                Module mprev = this.prev.findModuleFromPackageName(pkg);
                Module mnow3 = this.now.findModuleFromPackageName(pkg);
                mnow3.setPubapi(pkg, newPubApi);
                if (!mprev.hasPubapiChanged(pkg, newPubApi) || !mprev.lookupPackage(pkg).existsInJavacState()) continue;
                this.packagesWithChangedPublicApis.add(pkg);
                Log.debug("The API of " + Util.justPackageName(pkg) + " has changed!");
            }
        }
        return rc;
    }

    private static Set<File> findAllFiles(File dir) {
        HashSet<File> foundFiles = new HashSet<File>();
        if (dir == null) {
            return foundFiles;
        }
        JavacState.recurse(dir, foundFiles);
        return foundFiles;
    }

    private static void recurse(File dir, Set<File> foundFiles) {
        for (File f : dir.listFiles()) {
            if (f.isFile()) {
                foundFiles.add(f);
                continue;
            }
            if (!f.isDirectory()) continue;
            JavacState.recurse(f, foundFiles);
        }
    }

    public void compareWithMakefileList(File makefileSourceList) throws ProblemException {
        boolean mightNeedRewriting;
        boolean bl = mightNeedRewriting = File.pathSeparatorChar == ';';
        if (makefileSourceList == null) {
            return;
        }
        HashSet<String> calculatedSources = new HashSet<String>();
        HashSet<String> listedSources = new HashSet<String>();
        for (Source source : this.now.sources().values()) {
            if (source.isLinkedOnly()) continue;
            String path = source.file().getPath();
            if (mightNeedRewriting) {
                path = Util.normalizeDriveLetter(path);
            }
            calculatedSources.add(path);
        }
        try {
            Throwable throwable = null;
            try (BufferedReader in = new BufferedReader(new FileReader(makefileSourceList));){
                Object l;
                while ((l = in.readLine()) != null) {
                    l = ((String)l).trim();
                    if (mightNeedRewriting) {
                        if (((String)l).indexOf(":") != 1 || ((String)l).indexOf("\\") != 2) {
                            if (((String)l).indexOf(":") == 1 && ((String)l).indexOf("/") == 2) {
                                l = ((String)l).replaceAll("/", "\\\\");
                            } else if (((String)l).charAt(0) == '/' && ((String)l).indexOf("/", 1) != -1) {
                                int slash = ((String)l).indexOf("/", 1);
                                l = ((String)l).replaceAll("/", "\\\\");
                                l = ((String)l).charAt(slash + 1) + ":" + ((String)l).substring(slash + 2);
                            }
                        }
                        if (Character.isLowerCase(((String)l).charAt(0))) {
                            l = Character.toUpperCase(((String)l).charAt(0)) + ((String)l).substring(1);
                        }
                    }
                    listedSources.add((String)l);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new ProblemException("Could not open " + makefileSourceList.getPath() + " since it does not exist!");
        }
        catch (IOException e) {
            throw new ProblemException("Could not read " + makefileSourceList.getPath());
        }
        for (String string : listedSources) {
            if (calculatedSources.contains(string)) continue;
            throw new ProblemException("The makefile listed source " + string + " was not calculated by the smart javac wrapper!");
        }
        for (String string : calculatedSources) {
            if (listedSources.contains(string)) continue;
            throw new ProblemException("The smart javac wrapper calculated source " + string + " was not listed by the makefiles!");
        }
    }
}

