/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.snapshot;

import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptor;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.snapshot.SnapshotCategory;
import java.awt.Image;
import java.io.File;
import org.openide.util.NbBundle;

public abstract class SnapshotDescriptor<X extends Snapshot>
extends DataSourceDescriptor<X> {
    public SnapshotDescriptor(X snapshot, Image icon) {
        this(snapshot, null, icon);
    }

    public SnapshotDescriptor(X snapshot, String description, Image icon) {
        super(snapshot, SnapshotDescriptor.resolveSnapshotName(snapshot), description, icon, SnapshotDescriptor.resolvePosition(snapshot, 0x7FFFFFFE, ((Snapshot)snapshot).isInSnapshot()), 0);
    }

    public SnapshotDescriptor(X snapshot, String name, String description, Image icon, int position, int autoExpansionPolicy) {
        super(snapshot, name, description, icon, position, autoExpansionPolicy);
    }

    protected static String resolveSnapshotName(Snapshot snapshot) {
        String timeStamp;
        String persistedName = SnapshotDescriptor.resolveName(snapshot, null);
        if (persistedName != null) {
            return persistedName;
        }
        File file = snapshot.getFile();
        String fileName = file != null ? file.getName() : NbBundle.getMessage(SnapshotDescriptor.class, (String)"LBL_NoFile");
        SnapshotCategory category = snapshot.getCategory();
        String name = "[" + category.getPrefix() + "] " + fileName;
        if (file != null && category.isSnapshot(file) && (timeStamp = category.getTimeStamp(fileName)) != null) {
            name = "[" + category.getPrefix() + "] " + timeStamp;
        }
        return name;
    }

    @Override
    public boolean supportsRename() {
        return true;
    }

    @Override
    public boolean providesProperties() {
        return true;
    }
}

