/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts.xy.synchronous;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemChange;
import org.netbeans.lib.profiler.charts.xy.XYItemPainter;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;

public class SynchronousXYItemMarker
extends XYItemPainter.Abstract {
    protected final int markRadius;
    protected final int line1Width;
    protected final Color line1Color;
    protected final int line2Width;
    protected final Color line2Color;
    protected final Color fillColor;
    protected final Stroke line1Stroke;
    protected final Stroke line2Stroke;
    protected final int decorationRadius;
    protected final int type;
    protected final int maxValueOffset;

    public static SynchronousXYItemMarker absolutePainter(int n, float f, Color color, float f2, Color color2, Color color3) {
        return new SynchronousXYItemMarker(n, f, color, f2, color2, color3, 0, 0);
    }

    public static SynchronousXYItemMarker relativePainter(int n, float f, Color color, float f2, Color color2, Color color3, int n2) {
        return new SynchronousXYItemMarker(n, f, color, f2, color2, color3, 1, n2);
    }

    public SynchronousXYItemMarker(int n, float f, Color color, float f2, Color color2, Color color3, int n2, int n3) {
        if (color == null && color2 == null && color3 == null) {
            throw new IllegalArgumentException("No parameters defined");
        }
        this.markRadius = n;
        this.line1Width = (int)Math.ceil(f);
        this.line1Color = Utils.checkedColor(color);
        this.line2Width = (int)Math.ceil(f2);
        this.line2Color = Utils.checkedColor(color2);
        this.fillColor = Utils.checkedColor(color3);
        this.line1Stroke = color == null ? null : new BasicStroke(f, 1, 1);
        this.line2Stroke = color2 == null ? null : new BasicStroke(f2, 1, 1);
        this.decorationRadius = n + this.line1Width + this.line2Width;
        this.type = n2;
        this.maxValueOffset = n3;
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem) {
        SynchronousXYItem synchronousXYItem = (SynchronousXYItem)chartItem;
        if (this.type == 0) {
            return synchronousXYItem.getBounds();
        }
        LongRect longRect = new LongRect(synchronousXYItem.getBounds());
        longRect.y = 0L;
        longRect.height = 0L;
        return longRect;
    }

    @Override
    public LongRect getItemBounds(ChartItem chartItem, ChartContext chartContext) {
        SynchronousXYItem synchronousXYItem = (SynchronousXYItem)chartItem;
        return this.getViewBounds(synchronousXYItem, null, chartContext);
    }

    @Override
    public boolean isBoundsChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        return !LongRect.equals(xYItemChange.getOldValuesBounds(), xYItemChange.getNewValuesBounds());
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange chartItemChange) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        LongRect longRect = xYItemChange.getDirtyValuesBounds();
        return longRect.width != 0L || longRect.height != 0L;
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange chartItemChange, ChartContext chartContext) {
        XYItemChange xYItemChange = (XYItemChange)chartItemChange;
        return this.getViewBounds(xYItemChange.getItem(), xYItemChange.getValuesIndexes(), chartContext);
    }

    @Override
    public boolean supportsHovering(ChartItem chartItem) {
        return true;
    }

    @Override
    public boolean supportsSelecting(ChartItem chartItem) {
        return true;
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection itemSelection, ChartContext chartContext) {
        XYItemSelection xYItemSelection = (XYItemSelection)itemSelection;
        XYItem xYItem = xYItemSelection.getItem();
        int n = xYItemSelection.getValueIndex();
        if (n == -1 || n >= xYItem.getValuesCount()) {
            return new LongRect(0L, 0L, chartContext.getViewportWidth(), chartContext.getViewportHeight());
        }
        return this.getViewBounds(xYItem, new int[]{xYItemSelection.getValueIndex()}, chartContext);
    }

    @Override
    public XYItemSelection getClosestSelection(ChartItem chartItem, int n, int n2, ChartContext chartContext) {
        SynchronousXYChartContext synchronousXYChartContext = (SynchronousXYChartContext)chartContext;
        int n3 = synchronousXYChartContext.getNearestTimestampIndex(n, n2);
        if (n3 == -1) {
            return null;
        }
        SynchronousXYItem synchronousXYItem = (SynchronousXYItem)chartItem;
        return new XYItemSelection.Default(synchronousXYItem, n3);
    }

    @Override
    public void paintItem(ChartItem chartItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, ChartContext chartContext) {
        this.paint((SynchronousXYItem)chartItem, list, list2, graphics2D, rectangle, (SynchronousXYChartContext)chartContext);
    }

    private LongRect getViewBoundsRelative(LongRect longRect, XYItem xYItem, ChartContext chartContext) {
        long l;
        LongRect longRect2 = xYItem.getBounds();
        double d = SynchronousXYItemMarker.getItemValueFactor(chartContext, this.maxValueOffset, longRect2.height);
        double d2 = (double)chartContext.getDataOffsetY() + d * (double)(longRect.y - longRect2.y);
        double d3 = (double)chartContext.getDataOffsetY() + d * (double)(longRect.y + longRect.height - longRect2.y);
        long l2 = (long)Math.ceil(chartContext.getViewX(longRect.x));
        long l3 = (long)Math.ceil(chartContext.getViewWidth(longRect.width));
        if (chartContext.isRightBased()) {
            l2 -= l3;
        }
        long l4 = (long)Math.ceil(chartContext.getViewY(d2));
        long l5 = (long)Math.ceil(chartContext.getViewY(d3));
        long l6 = l = chartContext.isBottomBased() ? l4 - l5 : l5 - l4;
        if (!chartContext.isBottomBased()) {
            l5 -= l;
        }
        LongRect longRect3 = new LongRect(l2, l5, l3, l);
        LongRect.addBorder(longRect3, this.decorationRadius);
        return longRect3;
    }

    private LongRect getViewBounds(XYItem xYItem, int[] nArray, ChartContext chartContext) {
        LongRect longRect = new LongRect();
        if (nArray == null) {
            LongRect.set(longRect, xYItem.getBounds());
        } else {
            boolean bl = true;
            for (int n : nArray) {
                if (n == -1) continue;
                long l = xYItem.getXValue(n);
                long l2 = xYItem.getYValue(n);
                if (bl) {
                    LongRect.set(longRect, l, l2, 0L, 0L);
                    bl = false;
                    continue;
                }
                LongRect.add(longRect, l, l2);
            }
        }
        if (this.type == 1) {
            return this.getViewBoundsRelative(longRect, xYItem, chartContext);
        }
        LongRect longRect2 = chartContext.getViewRect(longRect);
        LongRect.addBorder(longRect2, this.decorationRadius);
        return longRect2;
    }

    private void paint(SynchronousXYItem synchronousXYItem, List<ItemSelection> list, List<ItemSelection> list2, Graphics2D graphics2D, Rectangle rectangle, SynchronousXYChartContext synchronousXYChartContext) {
        if (list.isEmpty()) {
            return;
        }
        if (synchronousXYItem.getValuesCount() < 1) {
            return;
        }
        if (synchronousXYChartContext.getViewWidth() == 0L || synchronousXYChartContext.getViewHeight() == 0L) {
            return;
        }
        double d = this.type == 1 ? SynchronousXYItemMarker.getItemValueFactor(synchronousXYChartContext, this.maxValueOffset, synchronousXYItem.getBounds().height) : 0.0;
        for (ItemSelection itemSelection : list) {
            XYItemSelection xYItemSelection = (XYItemSelection)itemSelection;
            int n = xYItemSelection.getValueIndex();
            if (n == -1) continue;
            int n2 = Utils.checkedInt(synchronousXYChartContext.getViewX(synchronousXYItem.getXValue(n)));
            int n3 = Utils.checkedInt(SynchronousXYItemMarker.getYValue(synchronousXYItem, n, this.type, synchronousXYChartContext, d));
            if (this.fillColor != null) {
                graphics2D.setPaint(this.fillColor);
                graphics2D.fillOval(n2 - this.markRadius, n3 - this.markRadius, this.markRadius * 2, this.markRadius * 2);
            }
            if (this.line2Color != null) {
                graphics2D.setPaint(this.line2Color);
                graphics2D.setStroke(this.line2Stroke);
                graphics2D.drawOval(n2 - this.markRadius, n3 - this.markRadius, this.markRadius * 2, this.markRadius * 2);
            }
            if (this.line1Color == null) continue;
            int n4 = this.markRadius + this.line2Width / 2;
            graphics2D.setPaint(this.line1Color);
            graphics2D.setStroke(this.line1Stroke);
            graphics2D.drawOval(n2 - n4, n3 - n4, n4 * 2, n4 * 2);
        }
    }

    private static double getYValue(XYItem xYItem, int n, int n2, ChartContext chartContext, double d) {
        if (n2 == 0) {
            return chartContext.getViewY(xYItem.getYValue(n));
        }
        return chartContext.getViewY((double)chartContext.getDataOffsetY() + d * (double)(xYItem.getYValue(n) - xYItem.getBounds().y));
    }

    private static double getItemValueFactor(ChartContext chartContext, double d, double d2) {
        return ((double)chartContext.getDataHeight() - chartContext.getDataHeight(d)) / d2;
    }
}

