/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.beans.IDProperty;
import com.sun.javafx.event.EventHandlerManager;
import com.sun.javafx.scene.control.ControlAcceleratorSupport;
import com.sun.javafx.scene.control.skin.Utils;
import java.lang.ref.WeakReference;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;

@IDProperty(value="id")
public abstract class TableColumnBase<S, T>
implements EventTarget,
Styleable {
    static final double DEFAULT_WIDTH = 80.0;
    static final double DEFAULT_MIN_WIDTH = 10.0;
    static final double DEFAULT_MAX_WIDTH = 5000.0;
    public static final Comparator DEFAULT_COMPARATOR = (obj1, obj2) -> {
        if (obj1 == null && obj2 == null) {
            return 0;
        }
        if (obj1 == null) {
            return -1;
        }
        if (obj2 == null) {
            return 1;
        }
        if (obj1 instanceof Comparable && (obj1.getClass() == obj2.getClass() || obj1.getClass().isAssignableFrom(obj2.getClass()))) {
            return obj1 instanceof String ? Collator.getInstance().compare(obj1, obj2) : ((Comparable)obj1).compareTo(obj2);
        }
        return Collator.getInstance().compare(obj1.toString(), obj2.toString());
    };
    final EventHandlerManager eventHandlerManager = new EventHandlerManager(this);
    private StringProperty text = new SimpleStringProperty(this, "text", "");
    private BooleanProperty visible = new SimpleBooleanProperty(this, "visible", true){

        @Override
        protected void invalidated() {
            for (TableColumnBase tableColumnBase : TableColumnBase.this.getColumns()) {
                tableColumnBase.setVisible(TableColumnBase.this.isVisible());
            }
        }
    };
    private ReadOnlyObjectWrapper<TableColumnBase<S, ?>> parentColumn;
    private ObjectProperty<ContextMenu> contextMenu;
    private StringProperty id;
    private StringProperty style;
    private final ObservableList<String> styleClass = FXCollections.observableArrayList();
    private ObjectProperty<Node> graphic;
    private ObjectProperty<Node> sortNode = new SimpleObjectProperty<Node>(this, "sortNode");
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper(this, "width", 80.0);
    private DoubleProperty minWidth;
    private final DoubleProperty prefWidth = new SimpleDoubleProperty(this, "prefWidth", 80.0){

        @Override
        protected void invalidated() {
            TableColumnBase.this.impl_setWidth(TableColumnBase.this.getPrefWidth());
        }
    };
    private DoubleProperty maxWidth = new SimpleDoubleProperty(this, "maxWidth", 5000.0){

        @Override
        protected void invalidated() {
            TableColumnBase.this.impl_setWidth(TableColumnBase.this.getWidth());
        }
    };
    private BooleanProperty resizable;
    private BooleanProperty sortable;
    private BooleanProperty reorderable;
    private BooleanProperty fixed;
    private ObjectProperty<Comparator<T>> comparator;
    private BooleanProperty editable;
    private static final Object USER_DATA_KEY = new Object();
    private ObservableMap<Object, Object> properties;

    protected TableColumnBase() {
        this("");
    }

    protected TableColumnBase(String text) {
        this.setText(text);
    }

    public final StringProperty textProperty() {
        return this.text;
    }

    public final void setText(String value) {
        this.text.set(value);
    }

    public final String getText() {
        return (String)this.text.get();
    }

    public final void setVisible(boolean value) {
        this.visibleProperty().set(value);
    }

    public final boolean isVisible() {
        return this.visible.get();
    }

    public final BooleanProperty visibleProperty() {
        return this.visible;
    }

    void setParentColumn(TableColumnBase<S, ?> value) {
        this.parentColumnPropertyImpl().set(value);
    }

    public final TableColumnBase<S, ?> getParentColumn() {
        return this.parentColumn == null ? null : (TableColumnBase)this.parentColumn.get();
    }

    public final ReadOnlyObjectProperty<TableColumnBase<S, ?>> parentColumnProperty() {
        return this.parentColumnPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<TableColumnBase<S, ?>> parentColumnPropertyImpl() {
        if (this.parentColumn == null) {
            this.parentColumn = new ReadOnlyObjectWrapper(this, "parentColumn");
        }
        return this.parentColumn;
    }

    public final void setContextMenu(ContextMenu value) {
        this.contextMenuProperty().set(value);
    }

    public final ContextMenu getContextMenu() {
        return this.contextMenu == null ? null : (ContextMenu)this.contextMenu.get();
    }

    public final ObjectProperty<ContextMenu> contextMenuProperty() {
        if (this.contextMenu == null) {
            this.contextMenu = new SimpleObjectProperty<ContextMenu>((Object)this, "contextMenu"){
                private WeakReference<ContextMenu> contextMenuRef;

                @Override
                protected void invalidated() {
                    ContextMenu oldMenu;
                    ContextMenu contextMenu = oldMenu = this.contextMenuRef == null ? null : (ContextMenu)this.contextMenuRef.get();
                    if (oldMenu != null) {
                        ControlAcceleratorSupport.removeAcceleratorsFromScene(oldMenu.getItems(), TableColumnBase.this);
                    }
                    ContextMenu ctx = (ContextMenu)this.get();
                    this.contextMenuRef = new WeakReference<ContextMenu>(ctx);
                    if (ctx != null) {
                        ControlAcceleratorSupport.addAcceleratorsIntoScene(ctx.getItems(), TableColumnBase.this);
                    }
                }
            };
        }
        return this.contextMenu;
    }

    public final void setId(String value) {
        this.idProperty().set(value);
    }

    @Override
    public final String getId() {
        return this.id == null ? null : (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new SimpleStringProperty(this, "id");
        }
        return this.id;
    }

    public final void setStyle(String value) {
        this.styleProperty().set(value);
    }

    @Override
    public final String getStyle() {
        return this.style == null ? "" : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new SimpleStringProperty(this, "style");
        }
        return this.style;
    }

    @Override
    public ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setGraphic(Node value) {
        this.graphicProperty().set(value);
    }

    public final Node getGraphic() {
        return this.graphic == null ? null : (Node)this.graphic.get();
    }

    public final ObjectProperty<Node> graphicProperty() {
        if (this.graphic == null) {
            this.graphic = new SimpleObjectProperty<Node>(this, "graphic");
        }
        return this.graphic;
    }

    public final void setSortNode(Node value) {
        this.sortNodeProperty().set(value);
    }

    public final Node getSortNode() {
        return (Node)this.sortNode.get();
    }

    public final ObjectProperty<Node> sortNodeProperty() {
        return this.sortNode;
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final double getWidth() {
        return this.width.get();
    }

    void setWidth(double value) {
        this.width.set(value);
    }

    public final void setMinWidth(double value) {
        this.minWidthProperty().set(value);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? 10.0 : this.minWidth.get();
    }

    public final DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new SimpleDoubleProperty(this, "minWidth", 10.0){

                @Override
                protected void invalidated() {
                    if (TableColumnBase.this.getMinWidth() < 0.0) {
                        TableColumnBase.this.setMinWidth(0.0);
                    }
                    TableColumnBase.this.impl_setWidth(TableColumnBase.this.getWidth());
                }
            };
        }
        return this.minWidth;
    }

    public final DoubleProperty prefWidthProperty() {
        return this.prefWidth;
    }

    public final void setPrefWidth(double value) {
        this.prefWidthProperty().set(value);
    }

    public final double getPrefWidth() {
        return this.prefWidth.get();
    }

    public final DoubleProperty maxWidthProperty() {
        return this.maxWidth;
    }

    public final void setMaxWidth(double value) {
        this.maxWidthProperty().set(value);
    }

    public final double getMaxWidth() {
        return this.maxWidth.get();
    }

    public final BooleanProperty resizableProperty() {
        if (this.resizable == null) {
            this.resizable = new SimpleBooleanProperty(this, "resizable", true);
        }
        return this.resizable;
    }

    public final void setResizable(boolean value) {
        this.resizableProperty().set(value);
    }

    public final boolean isResizable() {
        return this.resizable == null ? true : this.resizable.get();
    }

    public final BooleanProperty sortableProperty() {
        if (this.sortable == null) {
            this.sortable = new SimpleBooleanProperty(this, "sortable", true);
        }
        return this.sortable;
    }

    public final void setSortable(boolean value) {
        this.sortableProperty().set(value);
    }

    public final boolean isSortable() {
        return this.sortable == null ? true : this.sortable.get();
    }

    @Deprecated
    public final BooleanProperty impl_reorderableProperty() {
        if (this.reorderable == null) {
            this.reorderable = new SimpleBooleanProperty(this, "reorderable", true);
        }
        return this.reorderable;
    }

    @Deprecated
    public final void impl_setReorderable(boolean value) {
        this.impl_reorderableProperty().set(value);
    }

    @Deprecated
    public final boolean impl_isReorderable() {
        return this.reorderable == null ? true : this.reorderable.get();
    }

    @Deprecated
    public final BooleanProperty impl_fixedProperty() {
        if (this.fixed == null) {
            this.fixed = new SimpleBooleanProperty(this, "fixed", false);
        }
        return this.fixed;
    }

    @Deprecated
    public final void impl_setFixed(boolean value) {
        this.impl_fixedProperty().set(value);
    }

    @Deprecated
    public final boolean impl_isFixed() {
        return this.fixed == null ? false : this.fixed.get();
    }

    public final ObjectProperty<Comparator<T>> comparatorProperty() {
        if (this.comparator == null) {
            this.comparator = new SimpleObjectProperty<Comparator>(this, "comparator", DEFAULT_COMPARATOR);
        }
        return this.comparator;
    }

    public final void setComparator(Comparator<T> value) {
        this.comparatorProperty().set(value);
    }

    public final Comparator<T> getComparator() {
        return this.comparator == null ? DEFAULT_COMPARATOR : (Comparator)this.comparator.get();
    }

    public final void setEditable(boolean value) {
        this.editableProperty().set(value);
    }

    public final boolean isEditable() {
        return this.editable == null ? true : this.editable.get();
    }

    public final BooleanProperty editableProperty() {
        if (this.editable == null) {
            this.editable = new SimpleBooleanProperty(this, "editable", true);
        }
        return this.editable;
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null && !this.properties.isEmpty();
    }

    public void setUserData(Object value) {
        this.getProperties().put(USER_DATA_KEY, value);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    public abstract ObservableList<? extends TableColumnBase<S, ?>> getColumns();

    public final T getCellData(int index) {
        ObservableValue<T> result = this.getCellObservableValue((S)index);
        return result == null ? null : (T)result.getValue();
    }

    public final T getCellData(S item) {
        ObservableValue<T> result = this.getCellObservableValue(item);
        return result == null ? null : (T)result.getValue();
    }

    public abstract ObservableValue<T> getCellObservableValue(int var1);

    public abstract ObservableValue<T> getCellObservableValue(S var1);

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain tail) {
        return tail.prepend(this.eventHandlerManager);
    }

    public <E extends Event> void addEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.addEventHandler(eventType, eventHandler);
    }

    public <E extends Event> void removeEventHandler(EventType<E> eventType, EventHandler<E> eventHandler) {
        this.eventHandlerManager.removeEventHandler(eventType, eventHandler);
    }

    @Deprecated
    public void impl_setWidth(double width) {
        this.setWidth(Utils.boundedSize(width, this.getMinWidth(), this.getMaxWidth()));
    }

    void updateColumnWidths() {
        if (!this.getColumns().isEmpty()) {
            double _minWidth = 0.0;
            double _prefWidth = 0.0;
            double _maxWidth = 0.0;
            for (TableColumnBase tableColumnBase : this.getColumns()) {
                tableColumnBase.setParentColumn(this);
                _minWidth += tableColumnBase.getMinWidth();
                _prefWidth += tableColumnBase.getPrefWidth();
                _maxWidth += tableColumnBase.getMaxWidth();
            }
            this.setMinWidth(_minWidth);
            this.setPrefWidth(_prefWidth);
            this.setMaxWidth(_maxWidth);
        }
    }

    @Override
    public final ObservableSet<PseudoClass> getPseudoClassStates() {
        return FXCollections.emptyObservableSet();
    }
}

