/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.shape;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.Graphics;
import com.sun.prism.impl.shape.BasicShapeRep;

public class BasicRoundRectRep
extends BasicShapeRep {
    private static final float[] TMP_ARR = new float[4];

    @Override
    public void fill(Graphics g, Shape shape, BaseBounds bounds) {
        BasicRoundRectRep.fillRoundRect(g, (RoundRectangle2D)shape);
    }

    public static void fillRoundRect(Graphics g, RoundRectangle2D r) {
        if (r.width <= 0.0f || r.height <= 0.0f) {
            return;
        }
        float arcw = r.arcWidth;
        float arch = r.arcHeight;
        if (arcw > 0.0f && arch > 0.0f) {
            g.fillRoundRect(r.x, r.y, r.width, r.height, arcw, arch);
        } else if (BasicRoundRectRep.isAARequiredForFill(g, r)) {
            g.fillRect(r.x, r.y, r.width, r.height);
        } else {
            g.fillQuad(r.x, r.y, r.x + r.width, r.y + r.height);
        }
    }

    @Override
    public void draw(Graphics g, Shape shape, BaseBounds bounds) {
        BasicRoundRectRep.drawRoundRect(g, (RoundRectangle2D)shape);
    }

    public static void drawRoundRect(Graphics g, RoundRectangle2D r) {
        float arcw = r.arcWidth;
        float arch = r.arcHeight;
        if (arcw > 0.0f && arch > 0.0f) {
            g.drawRoundRect(r.x, r.y, r.width, r.height, arcw, arch);
        } else {
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    private static boolean notIntEnough(float f) {
        return (double)Math.abs(f - (float)Math.round(f)) > 0.06;
    }

    private static boolean notOnIntGrid(float x1, float y1, float x2, float y2) {
        return BasicRoundRectRep.notIntEnough(x1) || BasicRoundRectRep.notIntEnough(y1) || BasicRoundRectRep.notIntEnough(x2) || BasicRoundRectRep.notIntEnough(y2);
    }

    protected static boolean isAARequiredForFill(Graphics g, RoundRectangle2D rrect) {
        boolean aaRequiredForSure;
        BaseTransform xform = g.getTransformNoClone();
        long t = xform.getType();
        boolean bl = aaRequiredForSure = (t & 0xFFFFFFFFFFFFFFF0L) != 0L;
        if (aaRequiredForSure) {
            return true;
        }
        if (xform == null || xform.isIdentity()) {
            return BasicRoundRectRep.notOnIntGrid(rrect.x, rrect.y, rrect.x + rrect.width, rrect.y + rrect.height);
        }
        BasicRoundRectRep.TMP_ARR[0] = rrect.x;
        BasicRoundRectRep.TMP_ARR[1] = rrect.y;
        BasicRoundRectRep.TMP_ARR[2] = rrect.x + rrect.width;
        BasicRoundRectRep.TMP_ARR[3] = rrect.y + rrect.height;
        xform.transform(TMP_ARR, 0, TMP_ARR, 0, 2);
        return BasicRoundRectRep.notOnIntGrid(TMP_ARR[0], TMP_ARR[1], TMP_ARR[2], TMP_ARR[3]);
    }
}

