/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.CellBehaviorBase;
import com.sun.javafx.scene.control.behavior.TableRowBehavior;
import com.sun.javafx.scene.control.skin.TableRowSkinBase;
import com.sun.javafx.scene.control.skin.TableViewSkin;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.AccessibleAttribute;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;

public class TableRowSkin<T>
extends TableRowSkinBase<T, TableRow<T>, CellBehaviorBase<TableRow<T>>, TableCell<T, ?>> {
    private TableView<T> tableView;
    private TableViewSkin<T> tableViewSkin;

    public TableRowSkin(TableRow<T> tableRow) {
        super(tableRow, new TableRowBehavior<T>(tableRow));
        this.tableView = tableRow.getTableView();
        this.updateTableViewSkin();
        super.init(tableRow);
        this.registerChangeListener(tableRow.tableViewProperty(), "TABLE_VIEW");
    }

    @Override
    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("TABLE_VIEW".equals(p)) {
            this.updateTableViewSkin();
            int max = this.cells.size();
            for (int i = 0; i < max; ++i) {
                Node n = (Node)this.cells.get(i);
                if (!(n instanceof TableCell)) continue;
                ((TableCell)n).updateTableView(((TableRow)this.getSkinnable()).getTableView());
            }
            this.tableView = ((TableRow)this.getSkinnable()).getTableView();
        }
    }

    @Override
    protected TableCell<T, ?> getCell(TableColumnBase tcb) {
        TableColumn tableColumn = (TableColumn)tcb;
        TableCell cell = tableColumn.getCellFactory().call(tableColumn);
        cell.updateTableColumn(tableColumn);
        cell.updateTableView(tableColumn.getTableView());
        cell.updateTableRow((TableRow)this.getSkinnable());
        return cell;
    }

    @Override
    protected ObservableList<TableColumn<T, ?>> getVisibleLeafColumns() {
        return this.tableView.getVisibleLeafColumns();
    }

    @Override
    protected void updateCell(TableCell<T, ?> cell, TableRow<T> row) {
        cell.updateTableRow(row);
    }

    @Override
    protected DoubleProperty fixedCellSizeProperty() {
        return this.tableView.fixedCellSizeProperty();
    }

    @Override
    protected boolean isColumnPartiallyOrFullyVisible(TableColumnBase tc) {
        return this.tableViewSkin == null ? false : this.tableViewSkin.isColumnPartiallyOrFullyVisible((TableColumn)tc);
    }

    @Override
    protected TableColumn<T, ?> getTableColumnBase(TableCell<T, ?> cell) {
        return cell.getTableColumn();
    }

    @Override
    protected ObjectProperty<Node> graphicProperty() {
        return null;
    }

    @Override
    protected Control getVirtualFlowOwner() {
        return ((TableRow)this.getSkinnable()).getTableView();
    }

    private void updateTableViewSkin() {
        TableView tableView = ((TableRow)this.getSkinnable()).getTableView();
        if (tableView.getSkin() instanceof TableViewSkin) {
            this.tableViewSkin = (TableViewSkin)tableView.getSkin();
        }
    }

    @Override
    protected Object queryAccessibleAttribute(AccessibleAttribute attribute, Object ... parameters) {
        switch (attribute) {
            case SELECTED_ITEMS: {
                ArrayList<TableCell> selection = new ArrayList<TableCell>();
                int index = ((TableRow)this.getSkinnable()).getIndex();
                Iterator iterator = this.tableView.getSelectionModel().getSelectedCells().iterator();
                if (iterator.hasNext()) {
                    TablePosition pos = (TablePosition)iterator.next();
                    if (pos.getRow() == index) {
                        TableCell cell;
                        TableColumn<T, ?> column = pos.getTableColumn();
                        if (column == null) {
                            column = this.tableView.getVisibleLeafColumn(0);
                        }
                        if ((cell = (TableCell)((Reference)this.cellsMap.get(column)).get()) != null) {
                            selection.add(cell);
                        }
                    }
                    return FXCollections.observableArrayList(selection);
                }
            }
            case CELL_AT_ROW_COLUMN: {
                int colIndex = (Integer)parameters[1];
                TableColumn<T, ?> column = this.tableView.getVisibleLeafColumn(colIndex);
                if (this.cellsMap.containsKey(column)) {
                    return ((Reference)this.cellsMap.get(column)).get();
                }
                return null;
            }
            case FOCUS_ITEM: {
                TableView.TableViewFocusModel<T> fm = this.tableView.getFocusModel();
                TablePosition focusedCell = fm.getFocusedCell();
                TableColumn<T, ?> column = focusedCell.getTableColumn();
                if (column == null) {
                    column = this.tableView.getVisibleLeafColumn(0);
                }
                if (this.cellsMap.containsKey(column)) {
                    return ((Reference)this.cellsMap.get(column)).get();
                }
                return null;
            }
        }
        return super.queryAccessibleAttribute(attribute, parameters);
    }
}

