/*
 * Decompiled with CFR 0.152.
 */
package hughai.unitdata;

import com.springrts.ai.oo.clb.OOAICallback;
import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.CSAI;
import hughai.GameAdapter;
import hughai.GiveOrderWrapper;
import hughai.PlayerObjects;
import hughai.VoiceCommandHandler;
import hughai.basictypes.TerrainPos;
import hughai.ui.MainUI;
import hughai.unitdata.UnitDefHelp;
import hughai.utils.DrawingUtils;
import hughai.utils.LogFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UnitController {
    HashSet<UnitListener> unitListeners = new HashSet();
    CSAI csai;
    OOAICallback aicallback;
    LogFile logfile;
    UnitDefHelp unitdefhelp;
    GiveOrderWrapper giveOrderWrapper;
    DrawingUtils drawingUtils;
    public HashMap<String, List<Unit>> UnitsByName = new HashMap();
    public List<Unit> units = new ArrayList<Unit>();
    HashMap<Unit, UnitDef> unitdefbyunit = new HashMap();
    HashMap<Unit, TerrainPos> posbyunit = new HashMap();
    List<Map<?, ?>> mapstowipeeachframe = Arrays.asList(this.posbyunit);

    public void registerListener(UnitListener unitListener) {
        this.unitListeners.add(unitListener);
    }

    public UnitDef getUnitDef(Unit unit) {
        return this.unitdefbyunit.get(unit);
    }

    public TerrainPos getPos(Unit unit) {
        if (this.posbyunit.containsKey(unit)) {
            return this.posbyunit.get(unit);
        }
        TerrainPos terrainPos = TerrainPos.fromAIFloat3(unit.getPos());
        if (terrainPos.equals(new TerrainPos())) {
            terrainPos = null;
        }
        this.posbyunit.put(unit, terrainPos);
        return terrainPos;
    }

    public UnitController(PlayerObjects playerObjects) {
        this.csai = playerObjects.getCSAI();
        this.aicallback = this.csai.aicallback;
        this.logfile = playerObjects.getLogFile();
        this.unitdefhelp = new UnitDefHelp(playerObjects);
        this.giveOrderWrapper = playerObjects.getGiveOrderWrapper();
        this.drawingUtils = playerObjects.getDrawingUtils();
        this.csai.registerGameListener(new GameListenerHandler());
        this.csai.RegisterVoiceCommand("countunits", new VoiceCommandCountUnits());
        playerObjects.getMainUI().registerButton("Label units", new ButtonLabelUnits());
        playerObjects.getMainUI().registerButton("Kill all friendly", new ButtonKillAllFriendly());
        this.logfile.WriteLine("*UnitController initialized*");
    }

    public void labelUnits() {
        for (Unit unit : this.units) {
            this.drawingUtils.drawText(this.getPos(unit), "" + unit.getUnitId());
        }
    }

    public void LoadExistingUnits() {
        List list = this.aicallback.getFriendlyUnits();
        for (Unit object : list) {
            this.logfile.WriteLine("friendly unit existing: " + object.getUnitId() + " " + object.getDef().getHumanName() + " " + object.getDef().getName() + " " + object.getDef().getHumanName());
            this.AddUnit(object);
            for (UnitListener unitListener : this.unitListeners) {
                unitListener.ExistingUnit(object);
            }
        }
        for (UnitListener unitListener : this.unitListeners) {
            unitListener.AllUnitsLoaded();
        }
    }

    public void RefreshMyMemory(UnitListener unitListener) {
        this.units = this.aicallback.getTeamUnits();
        for (Unit unit : this.units) {
            unitListener.UnitAdded(unit);
        }
    }

    public void AddUnit(Unit unit) {
        UnitDef unitDef = unit.getDef();
        if (!this.units.contains(unit)) {
            this.logfile.WriteLine("UnitController.AddUnit: unit id " + unit.getDef().getName() + " " + unitDef.getHumanName());
            String string = unitDef.getName().toLowerCase();
            if (!this.UnitsByName.containsKey(string)) {
                this.UnitsByName.put(string, new ArrayList());
            }
            this.UnitsByName.get(string).add(unit);
            this.units.add(unit);
            this.unitdefbyunit.put(unit, unit.getDef());
            for (UnitListener unitListener : this.unitListeners) {
                unitListener.UnitAdded(unit);
            }
            this.logfile.WriteLine("UnitController.AddUnit finished");
        } else {
            this.logfile.WriteLine("UnitController.AddUnit: unit id " + unit.getUnitId() + " " + unitDef.getHumanName() + " already exists");
        }
    }

    void RemoveUnit(Unit unit) {
        if (this.units.contains(unit)) {
            UnitDef unitDef = unit.getDef();
            String object = unitDef.getName().toLowerCase();
            this.UnitsByName.get(object).remove(unit);
            this.units.remove(unit);
            this.unitdefbyunit.remove(unit);
        }
        for (UnitListener unitListener : this.unitListeners) {
            unitListener.UnitRemoved(unit);
        }
    }

    public void killAllFriendly() {
        for (Unit unit : this.units) {
            if (unit.getDef().isCommander()) continue;
            this.giveOrderWrapper.SelfDestruct(unit);
        }
    }

    public class VoiceCommandKillAllFriendlyHandler
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            UnitController.this.killAllFriendly();
        }
    }

    class GameListenerHandler
    extends GameAdapter {
        GameListenerHandler() {
        }

        @Override
        public void Tick(int n) {
            for (Map<?, ?> map : UnitController.this.mapstowipeeachframe) {
                map.clear();
            }
        }

        @Override
        public void UnitFinished(Unit unit) {
            UnitController.this.logfile.WriteLine("UnitController.NewUnitFinished " + unit.getDef().getHumanName() + " " + unit.getUnitId());
            UnitController.this.AddUnit(unit);
        }

        @Override
        public void UnitDestroyed(Unit unit, Unit unit2) {
            UnitController.this.logfile.WriteLine("UnitController.UnitDestroyed " + unit.getUnitId());
            UnitController.this.RemoveUnit(unit);
        }
    }

    public class VoiceLabelUnits
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            UnitController.this.labelUnits();
        }
    }

    public class VoiceCommandCountUnits
    implements VoiceCommandHandler {
        @Override
        public void commandReceived(String string, String[] stringArray, int n) {
            UnitController.this.csai.SendTextMsg("friendly unit count: " + UnitController.this.units.size());
        }
    }

    class ButtonKillAllFriendly
    implements MainUI.ButtonHandler {
        ButtonKillAllFriendly() {
        }

        @Override
        public void go() {
            UnitController.this.killAllFriendly();
        }
    }

    class ButtonLabelUnits
    implements MainUI.ButtonHandler {
        ButtonLabelUnits() {
        }

        @Override
        public void go() {
            UnitController.this.labelUnits();
        }
    }

    public static class UnitAdapter
    implements UnitListener {
        @Override
        public void ExistingUnit(Unit unit) {
        }

        @Override
        public void UnitAdded(Unit unit) {
        }

        @Override
        public void UnitRemoved(Unit unit) {
        }

        @Override
        public void AllUnitsLoaded() {
        }
    }

    public static interface UnitListener {
        public void ExistingUnit(Unit var1);

        public void UnitAdded(Unit var1);

        public void UnitRemoved(Unit var1);

        public void AllUnitsLoaded();
    }
}

