/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java;

import java.util.Arrays;
import java.util.EnumSet;
import org.jetbrains.jps.model.java.JpsJavaClasspathKind;

public enum JpsJavaDependencyScope {
    COMPILE(JpsJavaClasspathKind.PRODUCTION_COMPILE, JpsJavaClasspathKind.PRODUCTION_RUNTIME, JpsJavaClasspathKind.TEST_COMPILE, JpsJavaClasspathKind.TEST_RUNTIME),
    TEST(JpsJavaClasspathKind.TEST_COMPILE, JpsJavaClasspathKind.TEST_RUNTIME),
    RUNTIME(JpsJavaClasspathKind.PRODUCTION_RUNTIME, JpsJavaClasspathKind.TEST_RUNTIME),
    PROVIDED(JpsJavaClasspathKind.PRODUCTION_COMPILE, JpsJavaClasspathKind.TEST_COMPILE, JpsJavaClasspathKind.TEST_RUNTIME);

    private final EnumSet<JpsJavaClasspathKind> myAffectedClasspath;

    private JpsJavaDependencyScope(JpsJavaClasspathKind ... classpath) {
        this.myAffectedClasspath = EnumSet.copyOf(Arrays.asList(classpath));
    }

    public boolean isIncludedIn(JpsJavaClasspathKind kind) {
        return this.myAffectedClasspath.contains((Object)kind);
    }
}

