/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import icons.PythonIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructureViewElement
implements StructureViewTreeElement {
    private final PyElement myElement;
    private final Visibility myVisibility;
    private Icon myIcon;
    private final boolean myInherited;
    private final boolean myField;

    protected PyStructureViewElement(PyElement element, Visibility visibility, boolean inherited, boolean field) {
        this.myElement = element;
        this.myVisibility = visibility;
        this.myInherited = inherited;
        this.myField = field;
    }

    public PyStructureViewElement(PyElement element) {
        this(element, Visibility.NORMAL, false, false);
    }

    protected StructureViewTreeElement createChild(PyElement element, Visibility visibility, boolean inherited, boolean field) {
        return new PyStructureViewElement(element, visibility, inherited, field);
    }

    @Nullable
    public PyElement getValue() {
        return this.myElement.isValid() ? this.myElement : null;
    }

    public boolean isInherited() {
        return this.myInherited;
    }

    public boolean isField() {
        return this.myField;
    }

    public void navigate(boolean requestFocus) {
        PyElement element = this.getValue();
        if (element != null) {
            this.myElement.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return this.myElement.isValid() && this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.isValid() && this.myElement.canNavigateToSource();
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public boolean equals(Object o) {
        if (o instanceof StructureViewTreeElement) {
            Object value = ((StructureViewTreeElement)o).getValue();
            String name = this.myElement.getName();
            if (value instanceof PyElement && name != null) {
                return name.equals(((PyElement)value).getName());
            }
        }
        return false;
    }

    public int hashCode() {
        String name = this.myElement.getName();
        return name != null ? name.hashCode() : 0;
    }

    @NotNull
    public StructureViewTreeElement[] getChildren() {
        PyElement element = this.getValue();
        if (element == null) {
            if (EMPTY_ARRAY == null) {
                PyStructureViewElement.$$$reportNull$$$0(0);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<StructureViewTreeElement> children = new ArrayList<StructureViewTreeElement>();
        for (PyElement e : this.getElementChildren(element)) {
            children.add(this.createChild(e, PyStructureViewElement.getElementVisibility(e), false, this.elementIsField(e)));
        }
        PyPsiUtils.assertValid((PsiElement)element);
        if (element instanceof PyClass) {
            TypeEvalContext context = TypeEvalContext.codeAnalysis(element.getProject(), element.getContainingFile());
            for (PyClass c : ((PyClass)element).getAncestorClasses(context)) {
                for (PyElement e : this.getElementChildren(c)) {
                    StructureViewTreeElement inherited = this.createChild(e, PyStructureViewElement.getElementVisibility(e), true, this.elementIsField(e));
                    if (children.contains(inherited)) continue;
                    children.add(inherited);
                }
            }
        }
        StructureViewTreeElement[] structureViewTreeElementArray = children.toArray(StructureViewTreeElement.EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            PyStructureViewElement.$$$reportNull$$$0(1);
        }
        return structureViewTreeElementArray;
    }

    protected boolean elementIsField(PyElement element) {
        return element instanceof PyTargetExpression && PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class) != null;
    }

    private static Visibility getElementVisibility(PyElement element) {
        if (!(element instanceof PyTargetExpression) && PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class) != null) {
            return Visibility.INVISIBLE;
        }
        return PyStructureViewElement.getVisibilityByName(element.getName());
    }

    private Collection<PyElement> getElementChildren(final PyElement element) {
        final LinkedHashSet children = ContainerUtil.newLinkedHashSet();
        PyPsiUtils.assertValid((PsiElement)element);
        element.acceptChildren(new PyElementVisitor(){

            public void visitElement(PsiElement e) {
                if (PyStructureViewElement.this.isWorthyItem(e, (PsiElement)element)) {
                    children.add((PyElement)e);
                } else {
                    e.acceptChildren((PsiElementVisitor)this);
                }
            }
        });
        if (element instanceof PyClass) {
            List<PyElement> attrs = this.getClassAttributes((PyClass)element);
            ArrayList<PyElement> filtered = new ArrayList<PyElement>();
            HashSet<String> names = new HashSet<String>();
            for (PyElement attr : attrs) {
                String name = attr.getName();
                PyPsiUtils.assertValid((PsiElement)attr);
                if (!names.contains(name)) {
                    filtered.add(attr);
                }
                names.add(name);
            }
            Comparator comparator = (e1, e2) -> {
                String n1 = e1.getName();
                String n2 = e2.getName();
                return n1 != null && n2 != null ? n1.compareTo(n2) : 0;
            };
            Collections.sort(filtered, comparator);
            children.addAll(filtered);
        }
        return children;
    }

    protected List<PyElement> getClassAttributes(PyClass cls) {
        ArrayList<PyElement> results = new ArrayList<PyElement>();
        results.addAll(cls.getInstanceAttributes());
        results.addAll(cls.getClassAttributes());
        return results;
    }

    private static Visibility getVisibilityByName(@Nullable String name) {
        if (name != null) {
            if (name.startsWith("__")) {
                if (PyNames.UNDERSCORED_ATTRIBUTES.contains((Object)name)) {
                    return Visibility.PREDEFINED;
                }
                return Visibility.PRIVATE;
            }
            if (name.startsWith("_")) {
                return Visibility.PROTECTED;
            }
        }
        return Visibility.NORMAL;
    }

    protected boolean isWorthyItem(@Nullable PsiElement element, @Nullable PsiElement parent) {
        PsiElement e;
        if (element instanceof PyClass || element instanceof PyFunction) {
            return true;
        }
        return !(parent instanceof PyClass) && element instanceof PyTargetExpression && !((PyTargetExpression)element).isQualified() && (e = element.getParent()) instanceof PyAssignmentStatement && (e = e.getParent()) instanceof PyFile;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        final PyElement element = this.getValue();
        final ItemPresentation presentation = element != null ? element.getPresentation() : null;
        ColoredItemPresentation coloredItemPresentation = new ColoredItemPresentation(){

            @Nullable
            public String getPresentableText() {
                if (element instanceof PyFile) {
                    return element.getName();
                }
                return presentation != null ? presentation.getPresentableText() : "<unnamed>";
            }

            @Nullable
            public TextAttributesKey getTextAttributesKey() {
                if (PyStructureViewElement.this.isInherited()) {
                    return CodeInsightColors.NOT_USED_ELEMENT_ATTRIBUTES;
                }
                return null;
            }

            @Nullable
            public String getLocationString() {
                return null;
            }

            @Nullable
            public Icon getIcon(boolean open2) {
                if (element == null) {
                    return null;
                }
                Icon normal_icon = element.getIcon(0);
                if (PyStructureViewElement.this.myIcon != null) {
                    normal_icon = PyStructureViewElement.this.myIcon;
                }
                if (PyStructureViewElement.this.myVisibility == Visibility.NORMAL) {
                    return normal_icon;
                }
                LayeredIcon icon = new LayeredIcon(2);
                icon.setIcon(normal_icon, 0);
                Icon overlay = null;
                if (PyStructureViewElement.this.myVisibility == Visibility.PRIVATE || PyStructureViewElement.this.myVisibility == Visibility.PROTECTED) {
                    overlay = PythonIcons.Python.Nodes.Lock;
                } else if (PyStructureViewElement.this.myVisibility == Visibility.PREDEFINED) {
                    overlay = PythonIcons.Python.Nodes.Cyan_dot;
                } else if (PyStructureViewElement.this.myVisibility == Visibility.INVISIBLE) {
                    overlay = PythonIcons.Python.Nodes.Red_inv_triangle;
                }
                if (overlay != null) {
                    icon.setIcon(overlay, 1);
                }
                return icon;
            }
        };
        if (coloredItemPresentation == null) {
            PyStructureViewElement.$$$reportNull$$$0(2);
        }
        return coloredItemPresentation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/structureView/PyStructureViewElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    protected static enum Visibility {
        NORMAL,
        INVISIBLE,
        PRIVATE,
        PROTECTED,
        PREDEFINED;

    }
}

