/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.graphics.shading;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.common.PDRange;
import org.sejda.sambox.pdmodel.graphics.shading.PDShadingType6;
import org.sejda.sambox.pdmodel.graphics.shading.Patch;
import org.sejda.sambox.pdmodel.graphics.shading.TriangleBasedShadingContext;
import org.sejda.sambox.util.Matrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PatchMeshesShadingContext
extends TriangleBasedShadingContext {
    private static final Logger LOG = LoggerFactory.getLogger(PatchMeshesShadingContext.class);
    private List<Patch> patchList = new ArrayList<Patch>();

    protected PatchMeshesShadingContext(PDShadingType6 shading, ColorModel colorModel, AffineTransform xform, Matrix matrix, Rectangle deviceBounds, int controlPoints) throws IOException {
        super(shading, colorModel, xform, matrix);
        this.patchList = this.collectPatches(shading, xform, matrix, controlPoints);
        this.createPixelTable(deviceBounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Patch> collectPatches(PDShadingType6 shadingType, AffineTransform xform, Matrix matrix, int controlPoints) throws IOException {
        COSDictionary dict = shadingType.getCOSObject();
        if (!(dict instanceof COSStream)) {
            return Collections.emptyList();
        }
        int bitsPerFlag = shadingType.getBitsPerFlag();
        PDRange rangeX = shadingType.getDecodeForParameter(0);
        PDRange rangeY = shadingType.getDecodeForParameter(1);
        if (Float.compare(rangeX.getMin(), rangeX.getMax()) == 0 || Float.compare(rangeY.getMin(), rangeY.getMax()) == 0) {
            return Collections.emptyList();
        }
        PDRange[] colRange = new PDRange[this.numberOfColorComponents];
        for (int i = 0; i < this.numberOfColorComponents; ++i) {
            colRange[i] = shadingType.getDecodeForParameter(2 + i);
            if (!Objects.isNull(colRange[i])) continue;
            throw new IOException("Range missing in shading /Decode entry");
        }
        ArrayList<Patch> list = new ArrayList<Patch>();
        long maxSrcCoord = (long)Math.pow(2.0, this.bitsPerCoordinate) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.bitsPerColorComponent) - 1L;
        COSStream cosStream = (COSStream)dict;
        try (MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.getUnfilteredStream());){
            Point2D[] implicitEdge = new Point2D[4];
            float[][] implicitCornerColor = new float[2][this.numberOfColorComponents];
            byte flag = 0;
            try {
                flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
            }
            catch (EOFException ex) {
                LOG.error(ex.getMessage());
            }
            boolean eof = false;
            block14: while (!eof) {
                try {
                    boolean isFree = flag == 0;
                    Patch current = this.readPatch(mciis, isFree, implicitEdge, implicitCornerColor, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, matrix, xform, controlPoints);
                    if (current == null) {
                        break;
                    }
                    list.add(current);
                    flag = (byte)(mciis.readBits(bitsPerFlag) & 3L);
                    switch (flag) {
                        case 0: {
                            continue block14;
                        }
                        case 1: {
                            implicitEdge = current.getFlag1Edge();
                            implicitCornerColor = current.getFlag1Color();
                            continue block14;
                        }
                        case 2: {
                            implicitEdge = current.getFlag2Edge();
                            implicitCornerColor = current.getFlag2Color();
                            continue block14;
                        }
                        case 3: {
                            implicitEdge = current.getFlag3Edge();
                            implicitCornerColor = current.getFlag3Color();
                            continue block14;
                        }
                    }
                    LOG.warn("bad flag: " + flag);
                }
                catch (EOFException ex) {
                    eof = true;
                }
            }
        }
        return list;
    }

    protected Patch readPatch(ImageInputStream input, boolean isFree, Point2D[] implicitEdge, float[][] implicitCornerColor, long maxSrcCoord, long maxSrcColor, PDRange rangeX, PDRange rangeY, PDRange[] colRange, Matrix matrix, AffineTransform xform, int controlPoints) throws IOException {
        int i;
        float[][] color = new float[4][this.numberOfColorComponents];
        Point2D[] points = new Point2D[controlPoints];
        int pStart = 4;
        int cStart = 2;
        if (isFree) {
            pStart = 0;
            cStart = 0;
        } else {
            points[0] = implicitEdge[0];
            points[1] = implicitEdge[1];
            points[2] = implicitEdge[2];
            points[3] = implicitEdge[3];
            for (i = 0; i < this.numberOfColorComponents; ++i) {
                color[0][i] = implicitCornerColor[0][i];
                color[1][i] = implicitCornerColor[1][i];
            }
        }
        try {
            for (i = pStart; i < controlPoints; ++i) {
                long x = input.readBits(this.bitsPerCoordinate);
                long y = input.readBits(this.bitsPerCoordinate);
                float px = this.interpolate(x, maxSrcCoord, rangeX.getMin(), rangeX.getMax());
                float py = this.interpolate(y, maxSrcCoord, rangeY.getMin(), rangeY.getMax());
                Point2D.Float p = matrix.transformPoint(px, py);
                xform.transform(p, p);
                points[i] = p;
            }
            for (i = cStart; i < 4; ++i) {
                for (int j = 0; j < this.numberOfColorComponents; ++j) {
                    long c = input.readBits(this.bitsPerColorComponent);
                    color[i][j] = this.interpolate(c, maxSrcColor, colRange[j].getMin(), colRange[j].getMax());
                }
            }
        }
        catch (EOFException ex) {
            LOG.debug("EOF");
            return null;
        }
        return this.generatePatch(points, color);
    }

    abstract Patch generatePatch(Point2D[] var1, float[][] var2);

    private float interpolate(float x, long maxValue, float rangeMin, float rangeMax) {
        return rangeMin + x / (float)maxValue * (rangeMax - rangeMin);
    }

    @Override
    protected Map<Point, Integer> calcPixelTable(Rectangle deviceBounds) throws IOException {
        HashMap<Point, Integer> map = new HashMap<Point, Integer>();
        for (Patch it : this.patchList) {
            super.calcPixelTable(it.listOfTriangles, map, deviceBounds);
        }
        return map;
    }

    @Override
    public void dispose() {
        this.patchList = null;
        super.dispose();
    }

    @Override
    protected boolean isDataEmpty() {
        return this.patchList.isEmpty();
    }
}

