/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.completion.model.XmlTreeNode;
import org.openide.util.Enumerations;

public class NodeInfo
implements XmlTreeNode,
TextPositions {
    private int type;
    private int start;
    private int end = -1;
    private int contentStart = -1;
    private int contentEnd = -1;
    private Object resolvedInfo;
    private String tagName;
    private List<FxNode> attributes = Collections.emptyList();
    private List<FxNode> children = Collections.emptyList();
    private boolean includeEnd;

    public static NodeInfo newNode() {
        return new NodeInfo(-1);
    }

    static NodeInfo syntheticNode() {
        return new NodeInfo(-1);
    }

    public NodeInfo(int start) {
        this.start = start;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public NodeInfo startAt(int start) {
        this.start = start;
        return this;
    }

    public NodeInfo makeAttribute() {
        this.type = 1;
        return this;
    }

    public NodeInfo makePI() {
        this.type = 2;
        return this;
    }

    @Override
    public boolean isAttribute() {
        return this.type == 1;
    }

    public boolean isElement() {
        return this.type == 0;
    }

    @Override
    public int getStart() {
        return this.offset(this.start);
    }

    @Override
    public int getEnd() {
        return this.offset(this.end);
    }

    @Override
    public int getContentStart() {
        return this.offset(this.contentStart);
    }

    @Override
    public int getContentEnd() {
        return this.offset(this.contentEnd);
    }

    public NodeInfo endsAt(int e, boolean includeEnd) {
        this.end = e;
        this.includeEnd = includeEnd;
        return this;
    }

    public void markIncludeEnd() {
        this.includeEnd = true;
    }

    public NodeInfo endsAt(int e) {
        this.end = e;
        return this;
    }

    public NodeInfo endContent(int pos) {
        this.contentEnd = pos;
        return this;
    }

    public NodeInfo startContent(int pos) {
        this.contentStart = pos;
        return this;
    }

    public void addChild(FxNode n) {
        if (this.children.isEmpty()) {
            this.children = new ArrayList<FxNode>();
        }
        this.children.add(n);
    }

    @Override
    public List<FxNode> getAttributes() {
        return this.getImmutable(this.attributes);
    }

    @Override
    public List<FxNode> getChildren() {
        return this.getImmutable(this.children);
    }

    private List<FxNode> getImmutable(List<FxNode> nodes) {
        return nodes.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(nodes);
    }

    @Override
    public Enumeration<FxNode> getEnclosedNodes() {
        return Enumerations.concat(Collections.enumeration(this.attributes), Collections.enumeration(this.children));
    }

    int makeFuzzy(int pos) {
        return -pos - 1;
    }

    int offset(int o) {
        return o >= -1 ? o : -o - 1;
    }

    @Override
    public boolean contentContains(int position, boolean caret) {
        if (this.contentStart == -1) {
            return false;
        }
        int s = this.offset(this.contentStart);
        if (this.contentEnd == -1) {
            if (this.end == -1) {
                return false;
            }
            if (s == this.offset(this.end) && position == s && caret) {
                return true;
            }
            return s <= position && (this.offset(this.end) > position || this.includeEnd && this.offset(this.end) == position);
        }
        int e = this.offset(this.contentEnd);
        if (s == e && position == s && caret) {
            return true;
        }
        return s <= position && (e > position || caret && e == position);
    }

    @Override
    public boolean contains(int position, boolean caret) {
        if (this.start == this.end && position == this.start && caret) {
            return true;
        }
        if (position < this.start || position == this.start && caret) {
            return false;
        }
        int e = this.end;
        boolean incEnd = this.includeEnd;
        if (this.end == -1) {
            return false;
        }
        if (this.end < 0) {
            e = -this.end - 1;
            incEnd = true;
        }
        return position < e || incEnd && e == position;
    }

    @Override
    public boolean isDefined(TextPositions.Position pos) {
        int p;
        switch (pos) {
            case ContentEnd: {
                p = this.contentEnd;
                break;
            }
            case ContentStart: {
                p = this.contentStart;
                break;
            }
            case End: {
                p = this.end;
                break;
            }
            case Start: {
                p = this.start;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return p >= 0;
    }
}

