/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.support;

import java.io.IOException;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.io.Resource;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptEvaluator;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.support.ResourceScriptSource;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class StandardScriptEvaluator
implements ScriptEvaluator,
BeanClassLoaderAware {
    private volatile ScriptEngineManager scriptEngineManager;
    private String language;

    public StandardScriptEvaluator() {
    }

    public StandardScriptEvaluator(ClassLoader classLoader) {
        this.scriptEngineManager = new ScriptEngineManager(classLoader);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.scriptEngineManager = new ScriptEngineManager(classLoader);
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Override
    public Object evaluate(ScriptSource script) {
        return this.evaluate(script, null);
    }

    @Override
    public Object evaluate(ScriptSource script, Map<String, Object> arguments) {
        ScriptEngine engine = this.getScriptEngine(script);
        SimpleBindings bindings = !CollectionUtils.isEmpty(arguments) ? new SimpleBindings(arguments) : null;
        try {
            return bindings != null ? engine.eval(script.getScriptAsString(), (Bindings)bindings) : engine.eval(script.getScriptAsString());
        }
        catch (IOException ex) {
            throw new ScriptCompilationException(script, "Cannot access script", ex);
        }
        catch (ScriptException ex) {
            throw new ScriptCompilationException(script, "Evaluation failure", ex);
        }
    }

    protected ScriptEngine getScriptEngine(ScriptSource script) {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
        }
        if (StringUtils.hasText((String)this.language)) {
            ScriptEngine engine = this.scriptEngineManager.getEngineByName(this.language);
            if (engine == null) {
                throw new IllegalStateException("No matching engine found for language '" + this.language + "'");
            }
            return engine;
        }
        if (script instanceof ResourceScriptSource) {
            Resource resource = ((ResourceScriptSource)script).getResource();
            String extension = StringUtils.getFilenameExtension((String)resource.getFilename());
            if (extension == null) {
                throw new IllegalStateException("No script language defined, and no file extension defined for resource: " + resource);
            }
            ScriptEngine engine = this.scriptEngineManager.getEngineByExtension(extension);
            if (engine == null) {
                throw new IllegalStateException("No matching engine found for file extension '" + extension + "'");
            }
            return engine;
        }
        throw new IllegalStateException("No script language defined, and no resource associated with script: " + script);
    }
}

