/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.anttasks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class CopyTemplatePageTask
extends Task {
    private static final String JNLP_FILE = "${JNLP.FILE}";
    private static final String JNLP_APPLET_WIDTH = "${JNLP.APPLET.WIDTH}";
    private static final String JNLP_APPLET_HEIGHT = "${JNLP.APPLET.HEIGHT}";
    private static final String JNLP_RESOURCES_MAIN_JAR = "${JNLP.RESOURCES.MAIN.JAR}";
    private static final String JNLP_APPLET_CLASS = "${JNLP.APPLET.CLASS}";
    private static final String JNLP_VM_VERSION = "${JNLP_VM_VERSION}";
    private static final String JNLP_APPLET_PARAMS = "${JNLP.APPLET.PARAMS}";
    private final Map<String, Callable<String>> toReplace = new HashMap<String, Callable<String>>(){
        {
            this.put(CopyTemplatePageTask.JNLP_FILE, new BaseNamePropertyValue("jnlp.file", "launch.jnlp"));
            this.put(CopyTemplatePageTask.JNLP_APPLET_WIDTH, new PropertyValue("jnlp.applet.width", "300"));
            this.put(CopyTemplatePageTask.JNLP_APPLET_HEIGHT, new PropertyValue("jnlp.applet.height", "300"));
            this.put(CopyTemplatePageTask.JNLP_RESOURCES_MAIN_JAR, new DistJarExecValue("dist.jar", "lib", ", ", ""));
            this.put(CopyTemplatePageTask.JNLP_APPLET_CLASS, new PropertyValue("jnlp.applet.class", ""));
            this.put(CopyTemplatePageTask.JNLP_VM_VERSION, new PropertyValue("javac.target", "1.6"));
            this.put(CopyTemplatePageTask.JNLP_VM_VERSION, new PropertyValue("javac.target", "1.6"));
            this.put(CopyTemplatePageTask.JNLP_APPLET_PARAMS, new PropertyMap("jnlp.applet.param", "name", "value", (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("jnlp_href", "jnlp.file");
                }
            }));
        }
    };
    private File destFile;
    private File destDir;
    private File template;

    public void setDestfile(File file) {
        this.destFile = file;
    }

    public void setDestDir(File dir) {
        this.destDir = dir;
    }

    public void setTemplate(File file) {
        this.template = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        this.checkParameters();
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.template));
            try {
                PrintWriter out = new PrintWriter(new FileWriter(this.destFile));
                try {
                    this.copy(in, out);
                }
                finally {
                    out.close();
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe, this.getLocation());
        }
    }

    private void checkParameters() {
        if (this.destFile == null) {
            throw new BuildException("Destination file is not set, template page cannot be copied.");
        }
        if (this.destDir == null) {
            throw new BuildException("Destination directory is not set, template page cannot be copied.");
        }
        if (this.template == null) {
            throw new BuildException("Template file is not set, template page cannot be copied.");
        }
    }

    private void copy(BufferedReader in, PrintWriter out) throws IOException {
        String line;
        while ((line = in.readLine()) != null) {
            out.println(this.map(line));
        }
    }

    private String getProperty(String propName, String defaultVal) {
        String propVal = this.getProject().getProperty(propName);
        if (propVal == null) {
            this.log("Property " + propName + " is not defined, using default value: " + defaultVal, 3);
            return defaultVal;
        }
        return propVal.trim();
    }

    private String map(String line) {
        for (Map.Entry<String, Callable<String>> mapper : this.toReplace.entrySet()) {
            try {
                if (!line.contains(mapper.getKey())) continue;
                line = line.replaceAll(Pattern.quote(mapper.getKey()), mapper.getValue().call());
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex, this.getLocation());
            }
        }
        return line;
    }

    private static String stripFilename(String path) {
        int sepIndex = path.lastIndexOf(47) == -1 ? path.lastIndexOf(92) : path.lastIndexOf(47);
        return path.substring(sepIndex + 1);
    }

    private class PropertyMap
    implements Callable<String> {
        private final String prefix;
        private final String key;
        private final String value;
        private final Map<String, String> additionalProps;

        public PropertyMap(String prefix, String key, String value, Map<String, String> additionalProps) {
            this.prefix = prefix;
            this.key = key;
            this.value = value;
            this.additionalProps = additionalProps;
        }

        @Override
        public String call() throws Exception {
            StringBuilder sb = new StringBuilder();
            Pattern p = Pattern.compile(Pattern.quote(this.prefix) + "\\.(\\d+)\\." + Pattern.quote(this.key));
            Hashtable props = CopyTemplatePageTask.this.getProject().getProperties();
            for (Map.Entry entry : props.entrySet()) {
                Matcher m = p.matcher((CharSequence)entry.getKey());
                if (!m.matches()) continue;
                String kv = (String)entry.getValue();
                String valueKey = this.prefix + '.' + m.group(1) + '.' + this.value;
                String vv = CopyTemplatePageTask.this.getProperty(valueKey, "");
                this.addProperty(sb, kv, vv);
            }
            for (Map.Entry<Object, Object> entry : this.additionalProps.entrySet()) {
                this.addProperty(sb, (String)entry.getKey(), CopyTemplatePageTask.this.getProperty((String)entry.getValue(), ""));
            }
            return sb.toString();
        }

        private void addProperty(StringBuilder sb, String kv, String vv) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(kv);
            sb.append(':');
            sb.append('\"');
            sb.append(vv);
            sb.append('\"');
        }
    }

    private class DistJarExecValue
    extends PropertyValue {
        private final String libFolderName;
        private final String separator;

        public DistJarExecValue(String mainJarPropName, String libFolderName, String separator, String defaultValue) {
            super(mainJarPropName, defaultValue);
            assert (libFolderName != null);
            assert (separator != null);
            this.libFolderName = libFolderName;
            this.separator = separator;
        }

        @Override
        public String call() throws Exception {
            StringBuilder sb = new StringBuilder();
            sb.append(CopyTemplatePageTask.stripFilename(super.call()));
            File libFolder = new File(CopyTemplatePageTask.this.destDir, this.libFolderName);
            File[] libs = libFolder.listFiles();
            if (libs != null) {
                URI destDirURI = CopyTemplatePageTask.this.destDir.toURI();
                for (File lib : libs) {
                    URI libURI = lib.toURI();
                    String relativePath = destDirURI.relativize(libURI).toString();
                    if (sb.length() > 0) {
                        sb.append(this.separator);
                    }
                    sb.append(relativePath);
                }
            }
            return sb.toString();
        }
    }

    private class BaseNamePropertyValue
    extends PropertyValue {
        public BaseNamePropertyValue(String propName, String defaultValue) {
            super(propName, defaultValue);
        }

        @Override
        public String call() throws Exception {
            return CopyTemplatePageTask.stripFilename(super.call());
        }
    }

    private class PropertyValue
    implements Callable<String> {
        private final String propName;
        private final String defaultValue;

        public PropertyValue(String propName, String defaultValue) {
            this.propName = propName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String call() throws Exception {
            return CopyTemplatePageTask.this.getProperty(this.propName, this.defaultValue);
        }
    }
}

