/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webkit.debugging;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.webkit.debugging.Bundle;
import org.netbeans.modules.web.webkit.debugging.api.TransportStateException;
import org.netbeans.modules.web.webkit.debugging.spi.Command;
import org.netbeans.modules.web.webkit.debugging.spi.Response;
import org.netbeans.modules.web.webkit.debugging.spi.ResponseCallback;
import org.netbeans.modules.web.webkit.debugging.spi.TransportImplementation;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class TransportHelper {
    private TransportImplementation impl;
    private Callback callback;
    private Map<Integer, Handle> map = new HashMap<Integer, Handle>();
    private List<ResponseCallback> listeners = new CopyOnWriteArrayList<ResponseCallback>();
    public static final String OBJECT_GROUP_NAME = "netbeans-debugger-objects";
    static final boolean SHOW_WEBKIT_PROTOCOL = Boolean.getBoolean("show.webkit.protocol");
    private final RequestProcessor RP = new RequestProcessor();
    private boolean reset = false;

    public TransportHelper(TransportImplementation impl) {
        this.impl = impl;
        this.callback = new Callback();
        impl.registerResponseCallback(this.callback);
    }

    public String getConnectionName() {
        return this.impl.getConnectionName();
    }

    public URL getConnectionURL() {
        return this.impl.getConnectionURL();
    }

    public void sendCommand(Command command) {
        assert (!EventQueue.isDispatchThread());
        this.log("send " + command.toString());
        try {
            this.impl.sendCommand(command);
        }
        catch (TransportStateException tsex) {
            this.log("transport failed for " + command.toString());
        }
    }

    public void reset() {
        if (SHOW_WEBKIT_PROTOCOL) {
            this.getOutputLogger().getOut().close();
            this.getOutputLogger().getErr().close();
        }
        this.reset = true;
    }

    public boolean isVersionUnknownBeforeRequestChildNodes() {
        return "version without requestChildNodes".equals(this.impl.getVersion());
    }

    public boolean isVersion1() {
        return "version 1.0".equals(this.impl.getVersion());
    }

    public Response sendBlockingCommand(Command command) {
        assert (!EventQueue.isDispatchThread());
        this.log("blocking send " + command.toString());
        Handle handle = this.createSynchronizationHandle(command);
        try {
            this.impl.sendCommand(command);
        }
        catch (TransportStateException tsex) {
            return new Response(tsex);
        }
        boolean res = handle.waitForResponse();
        if (res) {
            return handle.getResponse();
        }
        this.logError("no response for " + command.toString());
        return null;
    }

    public void sendCallbackCommand(Command command, ResponseCallback callback) {
        assert (!EventQueue.isDispatchThread());
        this.log("callback send " + command.toString());
        this.createCallbackHandle(command, callback);
        try {
            this.impl.sendCommand(command);
        }
        catch (TransportStateException tsex) {
            callback.handleResponse(new Response(tsex));
        }
    }

    public void addListener(ResponseCallback l) {
        this.listeners.add(l);
    }

    public void removeListener(ResponseCallback l) {
        this.listeners.remove(l);
    }

    private void notifyListeners(Response response) {
        for (ResponseCallback l : this.listeners) {
            l.handleResponse(response);
        }
    }

    private synchronized Handle createSynchronizationHandle(Command command) {
        Handle handle = new Handle();
        this.map.put(command.getID(), handle);
        return handle;
    }

    private synchronized void createCallbackHandle(Command command, ResponseCallback callback) {
        this.map.put(command.getID(), new Handle(callback));
    }

    private synchronized Handle removeHandle(int id) {
        return this.map.remove(id);
    }

    public RequestProcessor getRequestProcessor() {
        return this.RP;
    }

    private InputOutput getOutputLogger() {
        return IOProvider.getDefault().getIO(Bundle.WebKitDebuggingProtocolPane(), false);
    }

    public static String getCurrentTime() {
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss:SSS");
        return formatter.format(new Date(System.currentTimeMillis()));
    }

    private void log(String s) {
        this.checkReset();
        if (SHOW_WEBKIT_PROTOCOL) {
            this.getOutputLogger().getOut().println(TransportHelper.getCurrentTime() + " " + s);
        }
    }

    private void logError(String s) {
        this.checkReset();
        if (SHOW_WEBKIT_PROTOCOL) {
            this.getOutputLogger().getErr().println(TransportHelper.getCurrentTime() + " " + s);
        }
    }

    private void checkReset() {
        if (this.reset) {
            this.reset = false;
            if (SHOW_WEBKIT_PROTOCOL) {
                try {
                    this.getOutputLogger().getOut().reset();
                    this.getOutputLogger().getErr().reset();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private class Callback
    implements ResponseCallback {
        @Override
        public void handleResponse(Response response) {
            int id = response.getID();
            if (id != -1) {
                Handle handle = TransportHelper.this.removeHandle(id);
                if (handle == null) {
                    TransportHelper.this.log("ignoring response " + response.toString());
                    return;
                }
                TransportHelper.this.log("response " + response.toString());
                handle.setResponse(response, TransportHelper.this);
            } else {
                TransportHelper.this.log("event " + response.toString());
                TransportHelper.this.notifyListeners(response);
            }
        }
    }

    private static class Handle {
        private Response response;
        private Semaphore semaphore;
        private ResponseCallback callback;

        public Handle() {
            this.semaphore = new Semaphore(0);
        }

        public Handle(ResponseCallback callback) {
            this.callback = callback;
        }

        public void setResponse(Response response, TransportHelper transport) {
            this.response = response;
            if (this.semaphore != null) {
                this.semaphore.release();
            }
            if (this.callback != null) {
                TransportStateException transportException = response.getException();
                if (transportException != null) {
                    transport.log("response " + transportException.toString());
                } else {
                    transport.log("response " + response.getResponse().toJSONString());
                }
                this.callback.handleResponse(response);
            }
        }

        public Response getResponse() {
            return this.response;
        }

        public boolean waitForResponse() {
            assert (this.semaphore != null);
            try {
                return this.semaphore.tryAcquire(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(TransportHelper.class.getName()).log(Level.INFO, null, ex);
                return false;
            }
        }
    }
}

