/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.diff;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import org.netbeans.api.diff.Difference;
import org.netbeans.modules.versioning.ui.diff.DiffActionTooltipWindow;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class DiffTooltipActionsPanel
extends JToolBar
implements ActionListener {
    private final Icon iconPrevious = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/versioning/ui/diff/diff-prev.png", (boolean)false);
    private final Icon iconNext = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/versioning/ui/diff/diff-next.png", (boolean)false);
    private final Icon iconDiff = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/versioning/ui/diff/diff.png", (boolean)false);
    private final Icon iconRollback = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/versioning/ui/diff/rollback.png", (boolean)false);
    private final DiffActionTooltipWindow master;
    private final Difference diff;
    private final JButton prevButton;
    private final JButton nextButton;
    private final JButton rollButton;
    private final JButton diffButton;

    public DiffTooltipActionsPanel(DiffActionTooltipWindow master, Difference diff) {
        this.master = master;
        this.diff = diff;
        Color tooltipBackround = UIManager.getColor("ToolTip.background");
        if (tooltipBackround == null) {
            tooltipBackround = Color.WHITE;
        }
        this.setRollover(true);
        this.setFloatable(false);
        this.setBackground(tooltipBackround);
        this.prevButton = new JButton(this.iconPrevious);
        this.nextButton = new JButton(this.iconNext);
        this.rollButton = new JButton(this.iconRollback);
        this.diffButton = new JButton(this.iconDiff);
        this.prevButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_GoToPreviousDifference"));
        this.nextButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_GoToNextDifference"));
        this.diffButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Open_Diff_Window"));
        if (diff.getType() == 1) {
            this.rollButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Delete_Added_Text"));
        } else if (diff.getType() == 2) {
            this.rollButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Replace_With_Original_Text"));
        } else {
            this.rollButton.setToolTipText(NbBundle.getMessage(DiffTooltipActionsPanel.class, (String)"TT_Restore_Original_Text"));
        }
        this.prevButton.addActionListener(this);
        this.nextButton.addActionListener(this);
        this.rollButton.addActionListener(this);
        this.diffButton.addActionListener(this);
        this.prevButton.setBackground(tooltipBackround);
        this.nextButton.setBackground(tooltipBackround);
        this.rollButton.setBackground(tooltipBackround);
        this.diffButton.setBackground(tooltipBackround);
        this.add(this.prevButton);
        this.add(this.nextButton);
        this.add(this.rollButton);
        this.add(this.diffButton);
        Difference[] diffs = master.getMaster().getCurrentDiff();
        this.prevButton.setEnabled(diffs[0] != diff);
        this.nextButton.setEnabled(diffs[diffs.length - 1] != diff);
        this.rollButton.setEnabled(master.getMaster().canRollback(diff));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.BLACK), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.prevButton) {
            this.master.shutdown();
            this.master.getMaster().onPrevious(this.diff);
        } else if (e.getSource() == this.nextButton) {
            this.master.shutdown();
            this.master.getMaster().onNext(this.diff);
        }
        if (e.getSource() == this.rollButton) {
            this.master.shutdown();
            this.master.getMaster().onRollback(this.diff);
        } else if (e.getSource() == this.diffButton) {
            this.master.shutdown();
            this.master.getMaster().onDiff(this.diff);
        }
    }

    void focusButton() {
        super.requestFocus();
        for (JButton b : new JButton[]{this.prevButton, this.nextButton, this.rollButton, this.diffButton}) {
            if (!b.isEnabled()) continue;
            b.requestFocusInWindow();
            break;
        }
    }
}

