/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image.navigation;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.image.ImageDataObject;
import org.netbeans.modules.image.navigation.ImagePreviewPanel;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImageNavigatorPanel
implements NavigatorPanel {
    private ImagePreviewPanel panelUI;
    private static final Lookup.Template MY_DATA = new Lookup.Template(ImageDataObject.class);
    private Lookup.Result currentContext;
    private LookupListener contextListener;
    private FileChangeListener fileChangeListener;
    private long lastSaveTime = -1L;
    private DataObject currentDataObject;
    private static final RequestProcessor WORKER = new RequestProcessor(ImageNavigatorPanel.class.getName());

    public String getDisplayName() {
        return NbBundle.getMessage(ImageNavigatorPanel.class, (String)"Navigator_DisplayName");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(ImageNavigatorPanel.class, (String)"Navigator_DisplayHint");
    }

    public JComponent getComponent() {
        if (this.lastSaveTime == -1L) {
            this.lastSaveTime = System.currentTimeMillis();
        }
        if (this.panelUI == null) {
            this.panelUI = new ImagePreviewPanel();
        }
        return this.panelUI;
    }

    public void panelActivated(Lookup context) {
        this.currentContext = context.lookup(MY_DATA);
        this.currentContext.addLookupListener(this.getContextListener());
        Collection data = this.currentContext.allInstances();
        this.currentDataObject = this.getDataObject(data);
        if (this.currentDataObject == null) {
            return;
        }
        if (this.fileChangeListener == null) {
            this.fileChangeListener = new ImageFileChangeAdapter();
        }
        this.currentDataObject.getPrimaryFile().addFileChangeListener(this.fileChangeListener);
        this.setNewContent(this.currentDataObject);
    }

    public void panelDeactivated() {
        this.currentContext.removeLookupListener(this.getContextListener());
        this.currentContext = null;
        if (this.currentDataObject != null) {
            this.currentDataObject.getPrimaryFile().removeFileChangeListener(this.fileChangeListener);
        }
        this.currentDataObject = null;
    }

    public Lookup getLookup() {
        return null;
    }

    private void setNewContent(final DataObject dataObject) {
        if (dataObject == null) {
            return;
        }
        WORKER.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedImage fImage;
                BufferedImage image;
                InputStream inputStream;
                block10: {
                    FileObject fileObject;
                    block9: {
                        inputStream = null;
                        image = null;
                        fileObject = dataObject.getPrimaryFile();
                        if (fileObject != null) break block9;
                        BufferedImage fImage2 = image;
                        SwingUtilities.invokeLater(new Runnable(fImage2){
                            final /* synthetic */ BufferedImage val$fImage;
                            {
                                this.val$fImage = bufferedImage;
                            }

                            @Override
                            public void run() {
                                ImageNavigatorPanel.this.panelUI.setImage(this.val$fImage);
                            }
                        });
                        return;
                    }
                    inputStream = fileObject.getInputStream();
                    if (inputStream != null) break block10;
                    BufferedImage fImage3 = image;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                try {
                    if (ImageNavigatorPanel.this.panelUI == null) {
                        ImageNavigatorPanel.this.getComponent();
                    }
                    try {
                        image = ImageIO.read(inputStream);
                    }
                    catch (IllegalArgumentException iaex) {
                        Logger.getLogger(ImageNavigatorPanel.class.getName()).info(NbBundle.getMessage(ImageNavigatorPanel.class, (String)"ERR_IOFile"));
                        inputStream.close();
                    }
                    inputStream.close();
                    fImage = image;
                }
                catch (IOException ex) {
                    BufferedImage fImage4;
                    try {
                        Logger.getLogger(ImageNavigatorPanel.class.getName()).info(NbBundle.getMessage(ImageNavigatorPanel.class, (String)"ERR_IOFile"));
                        fImage4 = image;
                    }
                    catch (Throwable throwable) {
                        BufferedImage fImage5 = image;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    private DataObject getDataObject(Collection data) {
        DataObject dataObject = null;
        for (Object o : data) {
            if (!(o instanceof DataObject)) continue;
            dataObject = (DataObject)o;
            break;
        }
        return dataObject;
    }

    private LookupListener getContextListener() {
        if (this.contextListener == null) {
            this.contextListener = new ContextListener();
        }
        return this.contextListener;
    }

    private class ImageFileChangeAdapter
    extends FileChangeAdapter {
        private ImageFileChangeAdapter() {
        }

        public void fileChanged(final FileEvent fe) {
            if (fe.getTime() > ImageNavigatorPanel.this.lastSaveTime) {
                ImageNavigatorPanel.this.lastSaveTime = System.currentTimeMillis();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ImageNavigatorPanel.this.currentDataObject = DataObject.find((FileObject)fe.getFile());
                            ImageNavigatorPanel.this.setNewContent(ImageNavigatorPanel.this.currentDataObject);
                        }
                        catch (DataObjectNotFoundException ex) {
                            Logger.getLogger(ImageNavigatorPanel.class.getName()).info(NbBundle.getMessage(ImageNavigatorPanel.class, (String)"ERR_DataObject"));
                        }
                    }
                });
            }
        }
    }

    private class ContextListener
    implements LookupListener {
        private ContextListener() {
        }

        public void resultChanged(LookupEvent ev) {
            Collection data = ((Lookup.Result)ev.getSource()).allInstances();
            ImageNavigatorPanel.this.currentDataObject = ImageNavigatorPanel.this.getDataObject(data);
            ImageNavigatorPanel.this.setNewContent(ImageNavigatorPanel.this.currentDataObject);
        }
    }
}

