/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.queriesimpl;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.source.queries.api.QueryException;
import org.netbeans.modules.java.source.queries.spi.QueriesController;
import org.netbeans.modules.java.source.queriesimpl.JavaOperationsImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class QueriesControllerImpl
implements QueriesController {
    public <R> R runQuery(@NonNull QueriesController.Context<R> ctx) throws QueryException {
        URL url = ctx.getURL();
        assert (url != null);
        FileObject file = URLMapper.findFileObject((URL)url);
        if (file == null) {
            throw new QueryException("Cannot map URL: " + url.toExternalForm() + " to FileObject");
        }
        JavaSource src = JavaSource.forFileObject((FileObject)file);
        assert (src != null);
        QueryTask qt = new QueryTask(ctx);
        try {
            src.runUserActionTask(qt, true);
        }
        catch (IOException ioe) {
            throw new QueryException((Throwable)ioe);
        }
        return qt.getResult();
    }

    public boolean runUpdate(@NonNull QueriesController.Context<Boolean> ctx) throws QueryException {
        URL url = ctx.getURL();
        assert (url != null);
        FileObject file = URLMapper.findFileObject((URL)url);
        if (file == null) {
            throw new QueryException("Cannot map URL: " + url.toExternalForm() + " to FileObject");
        }
        JavaSource src = JavaSource.forFileObject((FileObject)file);
        assert (src != null);
        QueryTask qt = new QueryTask(ctx);
        try {
            ModificationResult result = src.runModificationTask(qt);
            if (qt.getResult() == Boolean.TRUE) {
                List diffs = result.getDifferences(file);
                if (diffs != null) {
                    for (ModificationResult.Difference diff : diffs) {
                        diff.setCommitToGuards(true);
                    }
                }
                result.commit();
                return true;
            }
            return false;
        }
        catch (IOException ioe) {
            throw new QueryException((Throwable)ioe);
        }
    }

    private static class QueryTask<C extends CompilationController, R>
    implements Task<C> {
        private final QueriesController.Context<R> ctx;
        private R result;

        private QueryTask(@NonNull QueriesController.Context<R> ctx) {
            assert (ctx != null);
            this.ctx = ctx;
        }

        public void run(C parameter) throws Exception {
            this.result = this.ctx.execute(new JavaOperationsImpl((CompilationController)parameter));
        }

        public R getResult() {
            return this.result;
        }
    }
}

