/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class SearchButton {
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final MouseListener sharedMouseListener = new MouseUtils.PopupMouseAdapter(){

        public void mouseEntered(MouseEvent evt) {
            AbstractButton button;
            Object src = evt.getSource();
            if (src instanceof AbstractButton && (button = (AbstractButton)evt.getSource()).isEnabled()) {
                button.setContentAreaFilled(true);
                button.setBorderPainted(true);
            }
        }

        public void mouseExited(MouseEvent evt) {
            Object src = evt.getSource();
            if (src instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)evt.getSource();
                SearchButton.removeButtonContentAreaAndBorder(button);
            }
        }

        protected void showPopup(MouseEvent evt) {
        }
    };

    public static JButton createButton(String imageIcon, String resName) {
        JButton button = new JButton(ImageUtilities.loadImageIcon((String)imageIcon, (boolean)false));
        if (resName != null) {
            Mnemonics.setLocalizedText((AbstractButton)button, (String)NbBundle.getMessage(SearchButton.class, (String)resName));
        }
        SearchButton.processButton(button);
        return button;
    }

    public static JToggleButton createToggleButton(String imageIcon) {
        JToggleButton button = new JToggleButton(ImageUtilities.loadImageIcon((String)imageIcon, (boolean)false)){

            @Override
            public void setSelected(boolean b) {
                this.setContentAreaFilled(b);
                this.setBorderPainted(b);
                super.setSelected(b);
            }
        };
        SearchButton.processButton(button);
        return button;
    }

    private static void processButton(AbstractButton button) {
        SearchButton.removeButtonContentAreaAndBorder(button);
        button.setMargin(BUTTON_INSETS);
        button.addMouseListener(sharedMouseListener);
        button.setFocusable(false);
    }

    private static void removeButtonContentAreaAndBorder(AbstractButton button) {
        boolean canRemove = true;
        if (button instanceof JToggleButton) {
            boolean bl = canRemove = !button.isSelected();
        }
        if (canRemove) {
            button.setContentAreaFilled(false);
            button.setBorderPainted(false);
        }
    }
}

