/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionCandidateKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SmartCastDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.UnsafeCallError;
import org.jetbrains.kotlin.resolve.calls.model.UnstableSmartCast;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J,\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014J4\u0010\u0016\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J.\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/AdditionalDiagnosticReporter;", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "createSmartCastDiagnostic", "Lorg/jetbrains/kotlin/resolve/calls/model/SmartCastDiagnostic;", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedResultType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "reportAdditionalDiagnostics", "", "resultingDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "kotlinDiagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "diagnostics", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "reportSmartCastOnReceiver", "receiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "parameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "reportSmartCasts", "resolution"})
public final class AdditionalDiagnosticReporter {
    private final LanguageVersionSettings languageVersionSettings;

    public final void reportAdditionalDiagnostics(@NotNull ResolvedCallAtom candidate2, @NotNull CallableDescriptor resultingDescriptor, @NotNull KotlinDiagnosticsHolder kotlinDiagnosticsHolder, @NotNull Collection<? extends KotlinCallDiagnostic> diagnostics2) {
        Intrinsics.checkParameterIsNotNull(candidate2, "candidate");
        Intrinsics.checkParameterIsNotNull(resultingDescriptor, "resultingDescriptor");
        Intrinsics.checkParameterIsNotNull(kotlinDiagnosticsHolder, "kotlinDiagnosticsHolder");
        Intrinsics.checkParameterIsNotNull(diagnostics2, "diagnostics");
        this.reportSmartCasts(candidate2, resultingDescriptor, kotlinDiagnosticsHolder, diagnostics2);
    }

    private final SmartCastDiagnostic createSmartCastDiagnostic(ResolvedCallAtom candidate2, KotlinCallArgument argument, UnwrappedType expectedResultType) {
        if (!(argument instanceof ExpressionKotlinCallArgument)) {
            return null;
        }
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(((ExpressionKotlinCallArgument)argument).getReceiver().getReceiverValue().getType(), expectedResultType)) {
            return new SmartCastDiagnostic((ExpressionKotlinCallArgument)argument, expectedResultType.unwrap(), candidate2.getAtom());
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final SmartCastDiagnostic reportSmartCastOnReceiver(ResolvedCallAtom candidate2, SimpleKotlinCallArgument receiver2, ReceiverParameterDescriptor parameter, Collection<? extends KotlinCallDiagnostic> diagnostics2) {
        boolean bl;
        boolean bl2;
        Object element$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        SmartCastDiagnostic smartCastDiagnostic;
        if (receiver2 == null) return null;
        if (parameter == null) {
            return null;
        }
        UnwrappedType unwrappedType = parameter.getType().unwrap();
        boolean bl3 = false;
        boolean bl4 = false;
        UnwrappedType it = unwrappedType;
        boolean bl5 = false;
        UnwrappedType expectedType = receiver2.isSafeCall() ? it.makeNullableAsSpecified(true) : it;
        SmartCastDiagnostic smartCastDiagnostic2 = this.createSmartCastDiagnostic(candidate2, receiver2, expectedType);
        if (smartCastDiagnostic2 == null) return null;
        SmartCastDiagnostic smartCastDiagnostic3 = smartCastDiagnostic = smartCastDiagnostic2;
        bl4 = false;
        boolean bl6 = false;
        SmartCastDiagnostic it2 = smartCastDiagnostic3;
        boolean bl7 = false;
        Iterable $this$filterIsInstance$iv = diagnostics2;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection collection = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv$iv = iterator2.next();
            if (!(element$iv$iv instanceof UnsafeCallError)) continue;
            collection.add(element$iv$iv);
        }
        Iterable $this$none$iv = (List)collection;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl2 = true;
        } else {
            for (Object t : $this$none$iv) {
                UnsafeCallError it3 = (UnsafeCallError)t;
                boolean bl8 = false;
                if (!Intrinsics.areEqual(it3.getReceiver(), receiver2)) continue;
                return null;
            }
            bl2 = true;
        }
        if (!bl2) return null;
        $this$filterIsInstance$iv = diagnostics2;
        $i$f$filterIsInstance = false;
        $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
        Collection collection2 = new ArrayList();
        $i$f$filterIsInstanceTo = false;
        Iterator bl8 = $this$filterIsInstanceTo$iv$iv.iterator();
        while (bl8.hasNext()) {
            element$iv$iv = bl8.next();
            if (!(element$iv$iv instanceof UnstableSmartCast)) continue;
            collection2.add(element$iv$iv);
        }
        $this$none$iv = (List)collection2;
        $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object e : $this$none$iv) {
                UnstableSmartCast it4 = (UnstableSmartCast)e;
                boolean bl9 = false;
                if (!Intrinsics.areEqual(it4.getArgument(), receiver2)) continue;
                return null;
            }
            bl = true;
        }
        if (!bl) return null;
        boolean bl10 = true;
        if (!bl10) return null;
        SmartCastDiagnostic smartCastDiagnostic4 = smartCastDiagnostic3;
        return smartCastDiagnostic4;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportSmartCasts(ResolvedCallAtom candidate2, CallableDescriptor resultingDescriptor, KotlinDiagnosticsHolder kotlinDiagnosticsHolder, Collection<? extends KotlinCallDiagnostic> diagnostics2) {
        ResolutionCandidateKt.addDiagnosticIfNotNull(kotlinDiagnosticsHolder, this.reportSmartCastOnReceiver(candidate2, candidate2.getExtensionReceiverArgument(), resultingDescriptor.getExtensionReceiverParameter(), diagnostics2));
        ResolutionCandidateKt.addDiagnosticIfNotNull(kotlinDiagnosticsHolder, this.reportSmartCastOnReceiver(candidate2, candidate2.getDispatchReceiverArgument(), resultingDescriptor.getDispatchReceiverParameter(), diagnostics2));
        for (ValueParameterDescriptor parameter : resultingDescriptor.getValueParameters()) {
            Map<ValueParameterDescriptor, ResolvedCallArgument> map2 = candidate2.getArgumentMappingByOriginal();
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "parameter");
            Object object = map2.get(valueParameterDescriptor.getOriginal());
            if (object == null || (object = ((ResolvedCallArgument)object).getArguments()) == null) {
                continue;
            }
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                SmartCastDiagnostic smartCastDiagnostic;
                boolean thereIsUnstableSmartCastError;
                boolean bl;
                block8: {
                    void $this$filterIsInstanceTo$iv$iv;
                    UnwrappedType effectiveExpectedType;
                    KotlinCallArgument argument = (KotlinCallArgument)iterator2.next();
                    if (this.createSmartCastDiagnostic(candidate2, argument, effectiveExpectedType = ArgumentsUtilsKt.getExpectedType(argument, parameter, this.languageVersionSettings)) == null) {
                        continue;
                    }
                    Iterable $this$filterIsInstance$iv = diagnostics2;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof UnstableSmartCast)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    Iterable $this$any$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            UnstableSmartCast it = (UnstableSmartCast)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getArgument(), argument)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (thereIsUnstableSmartCastError = bl) continue;
                kotlinDiagnosticsHolder.addDiagnostic(smartCastDiagnostic);
            }
        }
    }

    public AdditionalDiagnosticReporter(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }
}

