/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ref.DebugReflectionUtil;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class CachedValueLeakChecker {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.CachedValueChecker");
    private static final boolean DO_CHECKS = ApplicationManager.getApplication().isUnitTestMode();
    private static final Set<String> ourCheckedKeys = ContainerUtil.newConcurrentSet();

    static void checkProvider(@NotNull CachedValueProvider provider, @NotNull Key key, @NotNull UserDataHolder userDataHolder) {
        if (provider == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(0);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(1);
        }
        if (userDataHolder == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(2);
        }
        if (!DO_CHECKS || ApplicationInfoImpl.isInStressTest()) {
            return;
        }
        if (!ourCheckedKeys.add(key.toString())) {
            return;
        }
        if (!SystemInfo.IS_AT_LEAST_JAVA9) {
            CachedValueLeakChecker.findReferencedPsi(provider, key, userDataHolder, 5);
        }
    }

    private static synchronized void findReferencedPsi(@NotNull Object root2, @NotNull Key key, @NotNull UserDataHolder toIgnore, int depth) {
        if (root2 == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(3);
        }
        if (key == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(4);
        }
        if (toIgnore == null) {
            CachedValueLeakChecker.$$$reportNull$$$0(5);
        }
        Condition<Object> shouldExamineValue = value -> {
            if (toIgnore == null) {
                CachedValueLeakChecker.$$$reportNull$$$0(7);
            }
            if (value == toIgnore) {
                return false;
            }
            if (value instanceof ASTNode && (value = ((ASTNode)value).getPsi()) == toIgnore) {
                return false;
            }
            if (value instanceof Project || value instanceof Module || value instanceof Application) {
                return false;
            }
            return !(value instanceof PsiElement) || !(toIgnore instanceof PsiElement) || ((PsiElement)toIgnore).getContainingFile() == null || !PsiTreeUtil.isAncestor((PsiElement)value, (PsiElement)toIgnore, true);
        };
        Map<Object, String> roots2 = Collections.singletonMap(root2, "CachedValueProvider " + key);
        DebugReflectionUtil.walkObjects(depth, roots2, PsiElement.class, shouldExamineValue, (value, backLink) -> {
            if (root2 == null) {
                CachedValueLeakChecker.$$$reportNull$$$0(6);
            }
            if (value instanceof PsiElement) {
                LOG.error("Incorrect CachedValue use. Provider references PSI, causing memory leaks and possible invalid element access, provider=" + root2 + "\n" + backLink);
                return false;
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataHolder";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIgnore";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/CachedValueLeakChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findReferencedPsi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findReferencedPsi$1";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$findReferencedPsi$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

