/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.BS;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.JmolRendererInterface;
import org.jmol.c.STR;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.renderbio.RocketsRenderer;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.Viewer;

public class RocketRenderer {
    private boolean tPending;
    private ProteinStructure proteinstructurePending;
    private int startIndexPending;
    private int endIndexPending;
    private V3 vtemp;
    private P3 screenA;
    private P3 screenB;
    private P3 screenC;
    private short colix;
    private short mad;
    private RocketsRenderer rr;
    private Viewer vwr;
    private JmolRendererInterface g3d;
    private TransformManager tm;
    private boolean renderArrowHeads;
    private boolean isRockets;
    private static final int[][] boxFaces;
    private static final int[][] arrowHeadFaces;
    private P3 ptC;
    private P3 ptTip;
    private P3[] corners;
    private P3[] screenCorners;
    private V3 vW;
    private V3 vH;
    private MeshSurface meshSurface;

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 2;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[4];
        nArray2[1] = 2;
        nArray2[2] = 6;
        nArray2[3] = 4;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[4];
        nArray3[1] = 4;
        nArray3[2] = 5;
        nArray3[3] = 1;
        nArrayArray[2] = nArray3;
        nArrayArray[3] = new int[]{7, 5, 4, 6};
        nArrayArray[4] = new int[]{7, 6, 2, 3};
        nArrayArray[5] = new int[]{7, 3, 1, 5};
        boxFaces = nArrayArray;
        int[][] nArrayArray2 = new int[5][];
        int[] nArray4 = new int[3];
        nArray4[0] = 1;
        nArray4[2] = 4;
        nArrayArray2[0] = nArray4;
        nArrayArray2[1] = new int[]{2, 3, 5};
        int[] nArray5 = new int[4];
        nArray5[1] = 1;
        nArray5[2] = 3;
        nArray5[3] = 2;
        nArrayArray2[2] = nArray5;
        int[] nArray6 = new int[4];
        nArray6[0] = 2;
        nArray6[1] = 5;
        nArray6[2] = 4;
        nArrayArray2[3] = nArray6;
        nArrayArray2[4] = new int[]{1, 4, 5, 3};
        arrowHeadFaces = nArrayArray2;
    }

    RocketRenderer set(RocketsRenderer rocketsRenderer) {
        this.screenA = new P3();
        this.screenB = new P3();
        this.screenC = new P3();
        this.vtemp = new V3();
        this.rr = rocketsRenderer;
        this.vwr = rocketsRenderer.vwr;
        this.tm = rocketsRenderer.vwr.tm;
        this.isRockets = rocketsRenderer.isRockets;
        return this;
    }

    void renderRockets() {
        this.g3d = this.rr.g3d;
        this.tPending = false;
        this.renderArrowHeads = this.rr.renderArrowHeads;
        BS bS = this.rr.bsVisible;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (this.rr.structureTypes[n] == STR.HELIX || this.isRockets && this.rr.structureTypes[n] == STR.SHEET) {
                this.renderSpecialSegment((AlphaMonomer)this.rr.monomers[n], this.rr.getLeadColix(n), this.rr.mads[n]);
            } else if (this.isRockets) {
                this.renderPending();
                this.rr.renderHermiteConic(n, true, 7);
            }
            n = bS.nextSetBit(n + 1);
        }
        this.renderPending();
    }

    private void renderSpecialSegment(AlphaMonomer alphaMonomer, short s, short s2) {
        ProteinStructure proteinStructure = alphaMonomer.proteinStructure;
        if (this.tPending) {
            if (proteinStructure == this.proteinstructurePending && s2 == this.mad && s == this.colix && proteinStructure.getIndex(alphaMonomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinStructure;
        this.startIndexPending = this.endIndexPending = proteinStructure.getIndex(alphaMonomer);
        this.colix = s;
        this.mad = s2;
        this.tPending = true;
    }

    private void renderPending() {
        boolean bl;
        if (!this.tPending) {
            return;
        }
        P3[] p3Array = this.proteinstructurePending.getSegments();
        boolean bl2 = bl = this.renderArrowHeads && this.endIndexPending == this.proteinstructurePending.nRes - 1;
        if (this.proteinstructurePending instanceof Helix) {
            this.renderPendingRocketSegment(this.endIndexPending, p3Array[this.startIndexPending], p3Array[this.endIndexPending], p3Array[this.endIndexPending + 1], bl);
        } else if (this.proteinstructurePending instanceof Sheet && ((Sheet)this.proteinstructurePending).apolymer instanceof AminoPolymer) {
            this.renderPendingSheetPlank(p3Array[this.startIndexPending], p3Array[this.endIndexPending], p3Array[this.endIndexPending + 1], bl);
        }
        this.tPending = false;
    }

    private void renderPendingRocketSegment(int n, P3 p3, P3 p32, P3 p33, boolean bl) {
        if (this.g3d.setC(this.colix)) {
            this.tm.transformPt3f(p3, this.screenA);
            this.tm.transformPt3f(bl ? p32 : p33, this.screenB);
            int n2 = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
            int n3 = (int)this.vwr.tm.scaleToScreen(n2, this.mad);
            if (!bl || p3 != p32) {
                this.g3d.fillCylinderBits((byte)2, n3, this.screenA, this.screenB);
            }
            if (bl) {
                this.screenA.sub2(p33, p32);
                this.tm.transformPt3f(p33, this.screenC);
                int n4 = (this.mad << 1) - (this.mad >> 1);
                n4 = (int)this.vwr.tm.scaleToScreen((int)Math.floor(this.screenB.z), n4);
                this.g3d.fillConeScreen3f((byte)2, n4, this.screenB, this.screenC, false);
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            P3 p34 = this.screenB;
            this.screenB = this.screenC;
            this.screenC = p34;
        }
    }

    private void renderPendingSheetPlank(P3 p3, P3 p32, P3 p33, boolean bl) {
        int n;
        if (!this.g3d.setC(this.colix)) {
            return;
        }
        if (this.corners == null) {
            this.ptC = new P3();
            this.ptTip = new P3();
            this.vW = new V3();
            this.vH = new V3();
            this.screenCorners = new P3[8];
            this.corners = new P3[8];
            n = 8;
            while (--n >= 0) {
                this.corners[n] = new P3();
                this.screenCorners[n] = new P3();
            }
        }
        if (bl) {
            this.setBox(1.25f, 0.333f, p32);
            this.ptTip.scaleAdd2(-0.5f, this.vH, p33);
            n = 4;
            while (--n >= 0) {
                P3 p34 = this.corners[n];
                p34.setT(this.ptC);
                if ((n & 1) != 0) {
                    p34.add(this.vW);
                }
                if ((n & 2) == 0) continue;
                p34.add(this.vH);
            }
            this.corners[4].setT(this.ptTip);
            this.corners[5].add2(this.ptTip, this.vH);
            this.renderPart(arrowHeadFaces);
            p33 = p32;
        }
        this.setBox(1.0f, 0.25f, p3);
        this.vtemp.sub2(p33, p3);
        if (this.vtemp.lengthSquared() == 0.0f) {
            return;
        }
        this.buildBox(this.ptC, this.vW, this.vH, this.vtemp);
        this.renderPart(boxFaces);
    }

    private void setBox(float f, float f2, P3 p3) {
        ((Sheet)this.proteinstructurePending).setBox(f, f2, p3, this.vW, this.vH, this.ptC, (float)this.mad / 1000.0f);
    }

    private void buildBox(P3 p3, V3 v3, V3 v32, V3 v33) {
        int n = 8;
        while (--n >= 0) {
            P3 p32 = this.corners[n];
            p32.setT(p3);
            if ((n & 1) != 0) {
                p32.add(v3);
            }
            if ((n & 2) != 0) {
                p32.add(v32);
            }
            if ((n & 4) == 0) continue;
            p32.add(v33);
        }
    }

    private void renderPart(int[][] nArray) {
        if (this.rr.exportType == 1) {
            if (this.meshSurface == null) {
                this.meshSurface = new MeshSurface();
                this.meshSurface.vs = this.corners;
                this.meshSurface.haveQuads = true;
                this.meshSurface.vc = this.corners.length;
            }
            this.meshSurface.pis = nArray;
            this.meshSurface.pc = nArray.length;
            this.g3d.drawSurface(this.meshSurface, this.colix);
        } else {
            int n = 8;
            while (--n >= 0) {
                this.tm.transformPt3f(this.corners[n], this.screenCorners[n]);
            }
            n = nArray.length;
            while (--n >= 0) {
                int[] nArray2 = nArray[n];
                if (nArray2.length == 3) {
                    this.g3d.fillTriangle3f(this.screenCorners[nArray2[0]], this.screenCorners[nArray2[1]], this.screenCorners[nArray2[2]], true);
                    continue;
                }
                this.g3d.fillQuadrilateral(this.screenCorners[nArray2[0]], this.screenCorners[nArray2[1]], this.screenCorners[nArray2[2]], this.screenCorners[nArray2[3]], true);
            }
        }
    }
}

