/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Model;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicPolymer;
import org.jmol.modelsetbio.ProteinStructure;

public abstract class BioPolymer
implements Structure {
    public Model model;
    public Monomer[] monomers;
    protected boolean hasStructure;
    protected P3[] leadMidpoints;
    protected P3[] leadPoints;
    protected P3[] controlPoints;
    protected V3[] wingVectors;
    protected int[] leadAtomIndices;
    protected int type = 0;
    public int bioPolymerIndexInModel;
    public int monomerCount;
    protected static final int TYPE_NOBONDING = 0;
    protected static final int TYPE_AMINO = 1;
    protected static final int TYPE_NUCLEIC = 2;
    protected static final int TYPE_CARBOHYDRATE = 3;
    public int cyclicFlag;
    private boolean invalidLead;
    protected boolean invalidControl = false;
    protected float sheetSmoothing;
    protected boolean hasWingPoints;
    public BS reversed;
    public boolean twistedSheets;
    private final V3 unitVectorX = V3.new3(1.0f, 0.0f, 0.0f);
    private int selectedMonomerCount;
    BS bsSelectedMonomers;
    public boolean haveParameters;

    protected BioPolymer() {
    }

    protected void set(Monomer[] monomerArray) {
        this.monomers = monomerArray;
        int n = this.monomerCount = monomerArray.length;
        while (--n >= 0) {
            monomerArray[n].setBioPolymer(this, n);
        }
        this.model = monomerArray[0].getModel();
    }

    @Override
    public void setAtomBits(BS bS) {
        this.getRange(bS, true);
    }

    @Override
    public void setAtomBitsAndClear(BS bS, BS bS2) {
        int n = this.monomerCount;
        while (--n >= 0) {
            this.monomers[n].setAtomBitsAndClear(bS, bS2);
        }
    }

    public void getRange(BS bS, boolean bl) {
        if (this.monomerCount == 0) {
            return;
        }
        if (bl) {
            int n = this.monomerCount;
            while (--n >= 0) {
                this.monomers[n].setAtomBits(bS);
            }
        } else {
            bS.setBits(this.monomers[0].firstAtomIndex, this.monomers[this.monomerCount - 1].lastAtomIndex + 1);
        }
    }

    public void clearStructures() {
    }

    public int[] getLeadAtomIndices() {
        if (this.leadAtomIndices == null) {
            this.leadAtomIndices = new int[this.monomerCount];
            this.invalidLead = true;
        }
        if (this.invalidLead) {
            int n = this.monomerCount;
            while (--n >= 0) {
                this.leadAtomIndices[n] = this.monomers[n].leadAtomIndex;
            }
            this.invalidLead = false;
        }
        return this.leadAtomIndices;
    }

    protected int getIndex(int n, int n2, int n3, int n4) {
        int n5 = this.monomerCount;
        while (--n5 >= 0) {
            Monomer monomer = this.monomers[n5];
            if (monomer.chain.chainID == n && monomer.seqcode == n2 && (n3 < 0 || n3 == monomer.firstAtomIndex || n4 == monomer.lastAtomIndex)) break;
        }
        return n5;
    }

    final P3 getLeadPoint(int n) {
        return this.monomers[n].getLeadAtom();
    }

    private final P3 getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom();
    }

    private final P3 getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom();
    }

    void getLeadMidPoint(int n, P3 p3) {
        if (n == this.monomerCount) {
            --n;
        } else if (n > 0) {
            p3.ave(this.getLeadPoint(n), this.getLeadPoint(n - 1));
            return;
        }
        p3.setT(this.getLeadPoint(n));
    }

    final P3 getWingPoint(int n) {
        return this.monomers[n].getWingAtom();
    }

    public void setConformation(BS bS) {
        Atom[] atomArray = this.model.ms.at;
        int n = this.monomerCount;
        while (--n >= 0) {
            this.monomers[n].updateOffsetsForAlternativeLocations(atomArray, bS);
        }
        this.recalculateLeadMidpointsAndWingVectors();
    }

    public void recalculateLeadMidpointsAndWingVectors() {
        this.invalidControl = true;
        this.invalidLead = true;
        this.getLeadAtomIndices();
        this.resetHydrogenPoints();
        this.calcLeadMidpointsAndWingVectors();
    }

    protected void resetHydrogenPoints() {
    }

    public P3[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadMidpoints;
    }

    P3[] getLeadPoints() {
        if (this.leadPoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadPoints;
    }

    public P3[] getControlPoints(boolean bl, float f, boolean bl2) {
        if (bl2) {
            this.invalidControl = true;
        }
        return !bl ? this.leadMidpoints : (f == 0.0f ? this.leadPoints : this.getControlPoints2(f));
    }

    private P3[] getControlPoints2(float f) {
        if (!this.invalidControl && f == this.sheetSmoothing) {
            return this.controlPoints;
        }
        this.getLeadPoints();
        V3 v3 = new V3();
        if (this.controlPoints == null) {
            this.controlPoints = new P3[this.monomerCount + 1];
        }
        if (!Float.isNaN(f)) {
            this.sheetSmoothing = f;
        }
        int n = 0;
        while (n < this.monomerCount) {
            this.controlPoints[n] = this.getControlPoint(n, v3);
            ++n;
        }
        this.controlPoints[this.monomerCount] = this.getTerminatorPoint();
        this.invalidControl = false;
        return this.controlPoints;
    }

    protected P3 getControlPoint(int n, V3 v3) {
        return this.leadPoints[n];
    }

    public final V3[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.wingVectors;
    }

    private final void calcLeadMidpointsAndWingVectors() {
        P3 p3;
        if (this.leadMidpoints == null) {
            this.leadMidpoints = new P3[this.monomerCount + 1];
            this.leadPoints = new P3[this.monomerCount + 1];
            this.wingVectors = new V3[this.monomerCount + 1];
            this.sheetSmoothing = Float.MIN_VALUE;
        }
        if (this.reversed == null) {
            this.reversed = BS.newN(this.monomerCount);
        } else {
            this.reversed.clearAll();
        }
        this.twistedSheets = this.model.ms.vwr.getBoolean(603979968);
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        V3 v34 = new V3();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        this.leadPoints[0] = p3 = this.getLeadPoint(0);
        V3 v35 = null;
        int n = 1;
        while (n < this.monomerCount) {
            P3 p32 = p3;
            this.leadPoints[n] = p3 = this.getLeadPoint(n);
            P3 p33 = new P3();
            p33.ave(p3, p32);
            this.leadMidpoints[n] = p33;
            if (this.hasWingPoints) {
                v3.sub2(p3, p32);
                v32.sub2(p32, this.getWingPoint(n - 1));
                v33.cross(v3, v32);
                v34.cross(v3, v33);
                v34.normalize();
                if (!this.twistedSheets && v35 != null && (double)v35.angle(v34) > 1.5707963267948966) {
                    this.reversed.set(n);
                    v34.scale(-1.0f);
                }
                v35 = this.wingVectors[n] = V3.newV(v34);
            }
            ++n;
        }
        this.leadPoints[this.monomerCount] = this.leadMidpoints[this.monomerCount] = this.getTerminatorPoint();
        if (!this.hasWingPoints) {
            if (this.monomerCount < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                V3 v36 = null;
                int n2 = 1;
                while (n2 < this.monomerCount) {
                    v3.sub2(this.leadMidpoints[n2], this.leadPoints[n2]);
                    v32.sub2(this.leadPoints[n2], this.leadMidpoints[n2 + 1]);
                    v33.cross(v3, v32);
                    v33.normalize();
                    if (v36 != null && (double)v36.angle(v33) > 1.5707963267948966) {
                        v33.scale(-1.0f);
                    }
                    v36 = this.wingVectors[n2] = V3.newV(v33);
                    ++n2;
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[this.monomerCount] = this.wingVectors[this.monomerCount - 1];
    }

    public void findNearestAtomIndex(int n, int n2, Atom[] atomArray, short[] sArray, int n3, BS bS) {
        int n4 = this.monomerCount;
        while (--n4 >= 0) {
            Atom atom;
            if ((this.monomers[n4].shapeVisibilityFlags & n3) == 0 || !(atom = this.monomers[n4].getLeadAtom()).checkVisible() || bS != null && bS.get(atom.i) || sArray[n4] <= 0 && sArray[n4 + 1] <= 0) continue;
            this.monomers[n4].findNearestAtomIndex(n, n2, atomArray, sArray[n4], sArray[n4 + 1]);
        }
    }

    int getSelectedMonomerCount() {
        return this.selectedMonomerCount;
    }

    public void calcSelectedMonomersCount(BS bS) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BS();
        }
        this.bsSelectedMonomers.clearAll();
        int n = 0;
        while (n < this.monomerCount) {
            if (this.monomers[n].isSelected(bS)) {
                ++this.selectedMonomerCount;
                this.bsSelectedMonomers.set(n);
            }
            ++n;
        }
    }

    boolean isMonomerSelected(int n) {
        return n >= 0 && this.bsSelectedMonomers.get(n);
    }

    public int getPolymerPointsAndVectors(int n, BS bS, Lst<P3[]> lst, boolean bl, float f) {
        P3[] p3Array = this.getControlPoints(bl, f, false);
        V3[] v3Array = this.getWingVectors();
        int n2 = this.monomerCount;
        int n3 = 0;
        while (n3 < n2) {
            if (bS.get(this.monomers[n3].leadAtomIndex)) {
                lst.addLast(new P3[]{p3Array[n3], P3.newP(v3Array[n3])});
                n = n3;
            } else if (n != 0x7FFFFFFE) {
                lst.addLast(new P3[]{p3Array[n3], P3.newP(v3Array[n3])});
                n = 0x7FFFFFFE;
            }
            ++n3;
        }
        if (n + 1 < n2) {
            lst.addLast(new P3[]{p3Array[n + 1], P3.newP(v3Array[n + 1])});
        }
        return n;
    }

    public String getSequence() {
        char[] cArray = new char[this.monomerCount];
        int n = 0;
        while (n < this.monomerCount) {
            cArray[n] = this.monomers[n].getGroup1();
            ++n;
        }
        return String.valueOf(cArray);
    }

    public void getPolymerSequenceAtoms(int n, int n2, BS bS, BS bS2) {
        int n3 = Math.min(this.monomerCount, n + n2);
        while (--n3 >= n) {
            this.monomers[n3].getMonomerSequenceAtoms(bS, bS2);
        }
    }

    public ProteinStructure getProteinStructure(int n) {
        return null;
    }

    public boolean calcParameters() {
        this.haveParameters = true;
        return this.calcEtaThetaAngles() || this.calcPhiPsiAngles();
    }

    protected boolean calcEtaThetaAngles() {
        return false;
    }

    protected boolean calcPhiPsiAngles() {
        return false;
    }

    protected float calculateRamachandranHelixAngle(int n, char c) {
        return Float.NaN;
    }

    public boolean isNucleic() {
        return this.monomerCount > 0 && this instanceof NucleicPolymer;
    }

    public void getRangeGroups(int n, BS bS, BS bS2) {
        BS bS3 = new BS();
        int n2 = 0;
        while (n2 < this.monomerCount) {
            if (this.monomers[n2].isSelected(bS)) {
                bS3.setBits(Math.max(0, n2 - n), n2 + n + 1);
                n2 += n - 1;
            }
            ++n2;
        }
        n2 = bS3.nextSetBit(0);
        while (n2 >= 0 && n2 < this.monomerCount) {
            this.monomers[n2].setAtomBits(bS2);
            n2 = bS3.nextSetBit(n2 + 1);
        }
    }

    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BS bS, BS bS2, Lst<Bond> lst, int n, int[][][] nArray, boolean bl, boolean bl2) {
    }

    public int getType() {
        return this.type;
    }

    public boolean isCyclic() {
        return (this.cyclicFlag == 0 ? (this.cyclicFlag = this.monomerCount >= 4 && this.monomers[0].isConnectedAfter(this.monomers[this.monomerCount - 1]) ? 1 : -1) : this.cyclicFlag) == 1;
    }
}

