#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tamarin-prover-term
version: 1.4.1
id: tamarin-prover-term-1.4.1-7XrNofx4ThtHRCEgWiQdSM
key: tamarin-prover-term-1.4.1-7XrNofx4ThtHRCEgWiQdSM
license: LicenseRef-GPL
copyright: Benedikt Schmidt, Simon Meier, Jannik Dreier, Ralf Sasse, ETH Zurich, 2010-2018
maintainer: Simon Meier <simon.meier@inf.ethz.ch>,
            Jannik Dreier <research@jannikdreier.net>,
            Ralf Sasse <ralf.sasse@gmail.com>
author: Benedikt Schmidt <benedikt.schmidt@inf.ethz.ch>,
        Simon Meier <simon.meier@inf.ethz.ch>,
        Jannik Dreier <research@jannikdreier.net>,
        Ralf Sasse <ralf.sasse@gmail.com>
homepage: https://tamarin-prover.github.io/
synopsis: Term manipulation library for the tamarin prover.
description:
    This is an internal library of the Tamarin prover for
    security protocol verification
    (<hackage.haskell.org/package/tamarin-prover>).
    .
    This library provides term manipulation infrastructure
    (matching, unification, narrowing, finite variants) for
    the Tamarin prover. It uses maude
    (<http://maude.cs.uiuc.edu/>) as a backend for
    normalization, equational matching, and unification.
category: Theorem Provers
abi: cd6a12778cc1a52663e877fb5821d9f0
exposed: True
exposed-modules:
    Term.Builtin.Convenience Term.Builtin.Rules Term.Builtin.Signature
    Term.LTerm Term.Maude.Parser Term.Maude.Process
    Term.Maude.Signature Term.Maude.Types Term.Narrowing.Variants
    Term.Narrowing.Variants.Check Term.Narrowing.Variants.Compute
    Term.Positions Term.Rewriting.Definitions Term.Rewriting.Norm
    Term.Substitution Term.Subsumption Term.SubtermRule
    Term.Unification Term.UnitTests Term.VTerm
hidden-modules: Term.Term Term.Term.Classes Term.Term.Raw
                Term.Term.FunctionSymbols Term.Narrowing.Narrow
                Term.Substitution.SubstVFree Term.Substitution.SubstVFresh
import-dirs: /usr/lib/ghc-8.6.4/site-local/tamarin-prover-term-1.4.1
library-dirs: /usr/lib/ghc-8.6.4/site-local/tamarin-prover-term-1.4.1
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/x86_64-linux-ghc-8.6.4/tamarin-prover-term-1.4.1
hs-libraries: HStamarin-prover-term-1.4.1-7XrNofx4ThtHRCEgWiQdSM
depends:
    HUnit-1.6.0.0-Kc3RXVOuMSQ9Y4PmNrdWEj
    attoparsec-0.13.2.2-3nUJVHBWBICGFmP4JcM3ay base-4.12.0.0
    binary-0.8.6.0 bytestring-0.10.8.2 containers-0.6.0.1
    deepseq-1.4.4.0 dlist-0.8.0.6-CQRMCGRgL5B3ZxhntX4iOr mtl-2.2.2
    process-1.6.5.0 safe-0.3.17-43oyx4B630gDZMbTh3Ttji
    tamarin-prover-utils-1.4.1-D5ufDjkZNOzK01f8ixXgYL
haddock-interfaces: /usr/share/doc/haskell-tamarin-prover-term/html/tamarin-prover-term.haddock
haddock-html: /usr/share/doc/haskell-tamarin-prover-term/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

