/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.IncludedBuildSpec;
import org.gradle.internal.build.BuildState;
import org.gradle.util.Path;

public abstract class AbstractBuildState
implements BuildState {
    public String toString() {
        return this.getBuildIdentifier().toString();
    }

    @Override
    public void assertCanAdd(IncludedBuildSpec includedBuildSpec) {
        throw new UnsupportedOperationException("Cannot include build '" + includedBuildSpec.rootDir.getName() + "' in " + this.getBuildIdentifier() + ". This is not supported yet.");
    }

    @Override
    public ProjectComponentIdentifier getIdentifierForProject(Path projectPath) {
        BuildIdentifier buildIdentifier = this.getBuildIdentifier();
        Path identityPath = this.getIdentityPathForProject(projectPath);
        DefaultProjectDescriptor project = this.getLoadedSettings().getProjectRegistry().getProject(projectPath.getPath());
        if (project == null) {
            throw new IllegalArgumentException("Project " + projectPath + " not found.");
        }
        String name = project.getName();
        return new DefaultProjectComponentIdentifier(buildIdentifier, identityPath, projectPath, name);
    }
}

